/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.util.helpers.EntityHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.slots.Slot;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1613;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2231;
import net.minecraft.class_2237;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2304;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2428;
import net.minecraft.class_243;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class ProjectileProtectionWallTask
extends Task
implements ITaskRequiresGrounded {
    private final PlayerEngineController mod;
    private final TimerGame waitForBlockPlacement = new TimerGame(2.0);
    private class_2338 targetPlacePos;

    public ProjectileProtectionWallTask(PlayerEngineController mod) {
        this.mod = mod;
    }

    @Override
    protected void onStart() {
        this.waitForBlockPlacement.forceElapse();
    }

    @Override
    protected Task onTick() {
        if (this.targetPlacePos != null && !WorldHelper.isSolidBlock(this.controller, this.targetPlacePos)) {
            Optional<Slot> slot = StorageHelper.getSlotWithThrowawayBlock(this.mod, true);
            if (slot.isPresent()) {
                this.place(this.targetPlacePos, class_1268.field_5808, slot.get().getInventorySlot());
                this.targetPlacePos = null;
                this.setDebugState(null);
            }
            return null;
        }
        Optional<class_1297> sentity = this.mod.getEntityTracker().getClosestEntity(e -> e instanceof class_1613 && EntityHelper.isAngryAtPlayer(this.mod, e) && ((class_1613)e).method_6048() > 8, class_1613.class);
        if (sentity.isPresent()) {
            class_243 playerPos = this.mod.getPlayer().method_19538();
            class_243 targetPos = sentity.get().method_19538();
            class_243 direction = playerPos.method_1020(targetPos).method_1029();
            double x = playerPos.field_1352 - 2.0 * direction.field_1352;
            double y = playerPos.field_1351 + direction.field_1351;
            double z = playerPos.field_1350 - 2.0 * direction.field_1350;
            this.targetPlacePos = new class_2338((int)x, (int)y + 1, (int)z);
            this.setDebugState("Placing at " + this.targetPlacePos.toString());
            this.waitForBlockPlacement.reset();
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        assert (this.controller.getWorld() != null);
        Optional<class_1297> entity = this.mod.getEntityTracker().getClosestEntity(e -> e instanceof class_1613 && EntityHelper.isAngryAtPlayer(this.mod, e) && ((class_1613)e).method_6048() > 3, class_1613.class);
        return this.targetPlacePos != null && WorldHelper.isSolidBlock(this.mod, this.targetPlacePos) || entity.isEmpty();
    }

    @Override
    protected boolean isEqual(Task other) {
        return true;
    }

    @Override
    protected String toDebugString() {
        return "Placing blocks to block projectiles";
    }

    public class_2350 getPlaceSide(class_2338 blockPos) {
        for (class_2350 side : class_2350.values()) {
            class_2338 neighbor = blockPos.method_10093(side);
            class_2680 state = this.mod.getWorld().method_8320(neighbor);
            if (state.method_26215() || ProjectileProtectionWallTask.isClickable(state.method_26204()) || !state.method_26227().method_15769()) continue;
            return side;
        }
        return null;
    }

    public boolean place(class_2338 blockPos, class_1268 hand, int slot) {
        if (slot < 0 || slot > 8) {
            return false;
        }
        if (!this.canPlace(blockPos)) {
            return false;
        }
        class_243 hitPos = class_243.method_24953((class_2382)blockPos);
        class_2350 side = this.getPlaceSide(blockPos);
        if (side == null) {
            this.place(blockPos.method_10074(), hand, slot);
            return false;
        }
        class_2338 neighbour = blockPos.method_10093(side);
        hitPos = hitPos.method_1031((double)side.method_10148() * 0.5, (double)side.method_10164() * 0.5, (double)side.method_10165() * 0.5);
        class_3965 bhr = new class_3965(hitPos, side.method_10153(), neighbour, false);
        this.mod.getPlayer().method_36456((float)this.getYaw(hitPos));
        this.mod.getPlayer().method_36457((float)this.getPitch(hitPos));
        this.swap(slot);
        this.interact(bhr, hand);
        return true;
    }

    public static boolean isClickable(class_2248 block) {
        return block instanceof class_2304 || block instanceof class_2199 || block instanceof class_2269 || block instanceof class_2231 || block instanceof class_2237 || block instanceof class_2244 || block instanceof class_2349 || block instanceof class_2323 || block instanceof class_2428 || block instanceof class_2533;
    }

    public void interact(class_3965 blockHitResult, class_1268 hand) {
        boolean wasSneaking = this.mod.getPlayer().method_5715();
        this.mod.getPlayer().method_5660(false);
        class_1269 result = this.mod.getBaritone().getEntityContext().playerController().processRightClickBlock(this.mod.getPlayer(), (class_1937)this.mod.getWorld(), hand, blockHitResult);
        if (result.method_23666()) {
            this.mod.getPlayer().method_6104(hand);
        }
        this.mod.getPlayer().method_5660(wasSneaking);
    }

    public boolean canPlace(class_2338 blockPos, boolean checkEntities) {
        if (blockPos == null) {
            return false;
        }
        if (!class_1937.method_25953((class_2338)blockPos) || !this.controller.getWorld().method_24794(blockPos)) {
            return false;
        }
        return !this.mod.getWorld().method_8320(blockPos).method_45474() ? false : !checkEntities || this.mod.getWorld().method_8628(class_2246.field_10540.method_9564(), blockPos, class_3726.method_16194());
    }

    public boolean canPlace(class_2338 blockPos) {
        return this.canPlace(blockPos, true);
    }

    public boolean swap(int slot) {
        if (slot == this.mod.getBaritone().getEntityContext().inventory().selectedSlot) {
            return true;
        }
        if (slot >= 0 && slot <= 8) {
            this.mod.getBaritone().getEntityContext().inventory().selectedSlot = slot;
            return true;
        }
        return false;
    }

    public double getYaw(class_243 pos) {
        return this.mod.getPlayer().method_36454() + class_3532.method_15393((float)((float)Math.toDegrees(Math.atan2(pos.method_10215() - this.mod.getPlayer().method_23321(), pos.method_10216() - this.mod.getPlayer().method_23317())) - 90.0f - this.mod.getPlayer().method_36454()));
    }

    public double getPitch(class_243 pos) {
        double diffX = pos.method_10216() - this.mod.getPlayer().method_23317();
        double diffY = pos.method_10214() - this.mod.getPlayer().method_23318() + (double)this.mod.getPlayer().method_18381(this.mod.getPlayer().method_18376());
        double diffZ = pos.method_10215() - this.mod.getPlayer().method_23321();
        double diffXZ = Math.sqrt(diffX * diffX + diffZ * diffZ);
        return this.mod.getPlayer().method_36455() + class_3532.method_15393((float)((float)(-Math.toDegrees(Math.atan2(diffY, diffXZ))) - this.mod.getPlayer().method_36455()));
    }
}

