/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2621;

public class StoreInContainerTask
extends Task {
    public static final class_2248[] CONTAINER_BLOCKS = (class_2248[])Stream.concat(Arrays.stream(new class_2248[]{class_2246.field_10034, class_2246.field_10380, class_2246.field_16328}), Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.SHULKER_BOXES))).toArray(class_2248[]::new);
    private final class_2338 containerPos;
    private final boolean getIfNotPresent;
    private final ItemTarget[] toStore;

    public StoreInContainerTask(class_2338 targetContainer, boolean getIfNotPresent, ItemTarget ... toStore) {
        this.containerPos = targetContainer;
        this.getIfNotPresent = getIfNotPresent;
        this.toStore = toStore;
    }

    @Override
    protected void onStart() {
        for (ItemTarget target : this.toStore) {
            this.controller.getBehaviour().addProtectedItems(target.getMatches());
        }
    }

    @Override
    protected Task onTick() {
        if (this.isFinished()) {
            return null;
        }
        if (this.getIfNotPresent) {
            for (ItemTarget target : this.toStore) {
                int needed = target.getTargetCount();
                if (this.controller.getItemStorage().getItemCount(target) >= needed) continue;
                this.setDebugState("Collecting " + String.valueOf(target) + " first.");
                return TaskCatalogue.getItemTask(target);
            }
        }
        if (!this.containerPos.method_19771(new class_2382((int)this.controller.getEntity().method_19538().field_1352, (int)this.controller.getEntity().method_19538().field_1351, (int)this.controller.getEntity().method_19538().field_1350), 4.5)) {
            this.setDebugState("Going to container");
            return new GetToBlockTask(this.containerPos);
        }
        class_2586 class_25862 = this.controller.getWorld().method_8321(this.containerPos);
        if (!(class_25862 instanceof class_2621)) {
            Debug.logWarning("Block at " + String.valueOf(this.containerPos) + " is not a lootable container. Stopping.");
            return null;
        }
        class_2621 container = (class_2621)class_25862;
        class_2621 var19 = container;
        LivingEntityInventory var20 = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        this.controller.getItemStorage().containers.WritableCache(this.controller, this.containerPos);
        this.setDebugState("Storing items");
        for (ItemTarget targetx : this.toStore) {
            int currentInContainer = this.countItem((class_1263)var19, targetx);
            if (currentInContainer >= targetx.getTargetCount()) continue;
            int neededInContainer = targetx.getTargetCount() - currentInContainer;
            for (int i = 0; i < var20.method_5439(); ++i) {
                class_1799 remainder;
                int moved;
                class_1799 playerStack = var20.method_5438(i);
                if (!targetx.matches(playerStack.method_7909())) continue;
                int toMove = Math.min(neededInContainer, playerStack.method_7947());
                class_1799 toInsert = playerStack.method_7972();
                toInsert.method_7939(toMove);
                if (this.insertStack((class_1263)var19, toInsert, true).method_7947() == toInsert.method_7947() || (moved = toMove - (remainder = this.insertStack((class_1263)var19, toInsert, false)).method_7947()) <= 0) continue;
                playerStack.method_7934(moved);
                var20.method_5447(i, playerStack);
                container.method_5431();
                this.controller.getItemStorage().registerSlotAction();
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isFinished() {
        boolean bl;
        class_2586 class_25862 = this.controller.getWorld().method_8321(this.containerPos);
        if (class_25862 instanceof class_1263) {
            class_1263 containerInv = (class_1263)class_25862;
            bl = Arrays.stream(this.toStore).allMatch(target -> this.countItem(containerInv, (ItemTarget)target) >= target.getTargetCount());
        } else {
            bl = Arrays.stream(this.toStore).allMatch(target -> this.controller.getItemStorage().getItemCount((ItemTarget)target) == 0);
        }
        return bl;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof StoreInContainerTask)) {
            bl = false;
        } else {
            StoreInContainerTask task = (StoreInContainerTask)other;
            bl = Objects.equals(task.containerPos, this.containerPos) && task.getIfNotPresent == this.getIfNotPresent && Arrays.equals(task.toStore, this.toStore);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Storing in container[" + this.containerPos.method_23854() + "] " + Arrays.toString(this.toStore);
    }

    private int countItem(class_1263 inventory, ItemTarget target) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!target.matches(stack.method_7909())) continue;
            count += stack.method_7947();
        }
        return count;
    }

    private class_1799 insertStack(class_1263 inventory, class_1799 stack, boolean simulate) {
        if (simulate) {
            stack = stack.method_7972();
        }
        for (int i = 0; i < inventory.method_5439() && !stack.method_7960(); ++i) {
            class_1799 slotStack = inventory.method_5438(i);
            if (!class_1799.method_31577((class_1799)stack, (class_1799)slotStack)) continue;
            int space = slotStack.method_7914() - slotStack.method_7947();
            int toTransfer = Math.min(stack.method_7947(), space);
            if (toTransfer <= 0) continue;
            slotStack.method_7933(toTransfer);
            stack.method_7934(toTransfer);
            if (simulate) continue;
            inventory.method_5447(i, slotStack);
        }
        for (int ix = 0; ix < inventory.method_5439() && !stack.method_7960(); ++ix) {
            if (!inventory.method_5438(ix).method_7960()) continue;
            if (!simulate) {
                inventory.method_5447(ix, stack.method_7972());
            }
            stack.method_7939(0);
        }
        return stack;
    }
}

