/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.PrimitiveSequenceTask;

public class BodyLanguageTask
extends Task {
    private final Type type;
    private static final float shakeNodHeadAngle = 40.0f;
    private static final int shakeNodHeadTime = 10;
    private final PrimitiveSequenceTask seqGreeting = BodyLanguageTask.makeGreeting();
    private final PrimitiveSequenceTask seqNodHead = BodyLanguageTask.makeNodHead(2);
    private final PrimitiveSequenceTask seqShake = BodyLanguageTask.makeShakeHead(2);
    private final PrimitiveSequenceTask seqVictory = BodyLanguageTask.makeVictoryDance();
    private Task actuallyRunningTask;

    public BodyLanguageTask(String type) {
        this.type = BodyLanguageTask.parseType(type);
    }

    private static Type parseType(String t) {
        try {
            return Type.valueOf(t.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return Type.GREETING;
        }
    }

    @Override
    protected void onStart() {
        switch (this.type.ordinal()) {
            case 0: {
                this.actuallyRunningTask = this.seqGreeting;
                break;
            }
            case 1: {
                this.actuallyRunningTask = this.seqNodHead;
                break;
            }
            case 2: {
                this.actuallyRunningTask = this.seqShake;
                break;
            }
            case 3: {
                this.actuallyRunningTask = this.seqVictory;
            }
        }
    }

    @Override
    protected Task onTick() {
        return this.actuallyRunningTask;
    }

    @Override
    public boolean isFinished() {
        return this.actuallyRunningTask != null && this.actuallyRunningTask.isFinished();
    }

    @Override
    protected boolean isEqual(Task other) {
        if (!(other instanceof BodyLanguageTask)) {
            return false;
        }
        BodyLanguageTask o = (BodyLanguageTask)other;
        return o.type == this.type;
    }

    @Override
    protected void onStop(Task next) {
        PlayerEngineController mod = this.controller;
        mod.getInputControls().release(Input.SNEAK);
        mod.getInputControls().release(Input.JUMP);
        mod.getInputControls().release(Input.SPRINT);
        mod.getInputControls().release(Input.MOVE_FORWARD);
        mod.getInputControls().release(Input.MOVE_BACK);
        mod.getInputControls().release(Input.MOVE_LEFT);
        mod.getInputControls().release(Input.MOVE_RIGHT);
    }

    @Override
    protected String toDebugString() {
        return "BodyLanguage(" + String.valueOf((Object)this.type) + ")";
    }

    private static PrimitiveSequenceTask makeGreeting() {
        PrimitiveSequenceTask.Sequence.Builder b = PrimitiveSequenceTask.builder();
        int sneakCount = 3;
        int holdTicks = 6;
        int pauseTicks = 6;
        for (int i = 0; i < sneakCount; ++i) {
            b.jump().waitTicks(pauseTicks).jump().waitTicks(pauseTicks);
        }
        return b.build();
    }

    private static PrimitiveSequenceTask makeNodHead(int nods) {
        PrimitiveSequenceTask.Sequence.Builder b = PrimitiveSequenceTask.builder();
        for (int i = 0; i < nods; ++i) {
            b.lookRelative(new Rotation(0.0f, 40.0f), 10);
            b.lookRelative(new Rotation(0.0f, -40.0f), 10);
        }
        b.waitTicks(2);
        return b.build();
    }

    private static PrimitiveSequenceTask makeShakeHead(int shakes) {
        PrimitiveSequenceTask.Sequence.Builder b = PrimitiveSequenceTask.builder();
        for (int i = 0; i < shakes; ++i) {
            b.lookRelative(new Rotation(40.0f, 0.0f), 10);
            b.lookRelative(new Rotation(-40.0f, 0.0f), 10);
        }
        return b.build();
    }

    private static PrimitiveSequenceTask makeVictoryDance() {
        return PrimitiveSequenceTask.builder().jump().waitTicks(4).lookRelative(new Rotation(180.0f, 0.0f), 20).lookRelative(new Rotation(-180.0f, 0.0f), 20).hold(Input.SNEAK).waitTicks(6).release(Input.SNEAK).jump().build();
    }

    public static enum Type {
        GREETING,
        NOD_HEAD,
        SHAKE_HEAD,
        VICTORY;

    }
}

