/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2338;

public class CollectStrippedLogTask
extends ResourceTask {
    private static final class_1792[] axes = new class_1792[]{class_1802.field_8406, class_1802.field_8062, class_1802.field_8825, class_1802.field_8475, class_1802.field_8556, class_1802.field_22025};
    private final class_1792[] strippedLogs;
    private final class_1792[] strippableLogs;
    private final int targetCount;

    public CollectStrippedLogTask(class_1792[] strippedLogs, class_1792[] strippableLogs, int count) {
        super(new ItemTarget(strippedLogs, count));
        this.strippedLogs = strippedLogs;
        this.strippableLogs = strippableLogs;
        this.targetCount = count;
    }

    public CollectStrippedLogTask(int count) {
        this(ItemHelper.STRIPPED_LOGS, ItemHelper.STRIPPABLE_LOGS, count);
    }

    public CollectStrippedLogTask(class_1792 strippedLogs, class_1792 strippableLogs, int count) {
        this(new class_1792[]{strippedLogs}, new class_1792[]{strippableLogs}, count);
    }

    public CollectStrippedLogTask(class_1792 strippedLog, int count) {
        this(strippedLog, ItemHelper.strippedToLogs(strippedLog), count);
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        Optional<class_2338> strippedLogBlockPos;
        if (!mod.getItemStorage().hasItem(axes)) {
            this.setDebugState("Getting axe for stripping");
            return TaskCatalogue.getItemTask(class_1802.field_8406, 1);
        }
        if (mod.getItemStorage().getItemCount(this.strippedLogs) < this.targetCount && (strippedLogBlockPos = mod.getBlockScanner().getNearestBlock(ItemHelper.itemsToBlocks(this.strippedLogs))).isPresent()) {
            this.setDebugState("Getting stripped log");
            return new MineAndCollectTask(new ItemTarget(this.strippedLogs), ItemHelper.itemsToBlocks(this.strippedLogs), MiningRequirement.HAND);
        }
        Optional<class_2338> strippableLogBlockPos = mod.getBlockScanner().getNearestBlock(ItemHelper.itemsToBlocks(this.strippableLogs));
        if (strippableLogBlockPos.isPresent()) {
            this.setDebugState("Stripping log");
            return new InteractWithBlockTask(new ItemTarget(axes), strippableLogBlockPos.get());
        }
        this.setDebugState("Searching log");
        return new TimeoutWanderTask();
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof CollectStrippedLogTask) {
            CollectStrippedLogTask task = (CollectStrippedLogTask)other;
            bl = task.targetCount == this.targetCount;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect Stripped Log";
    }
}

