/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.entity.KillEntitiesTask;
import com.player2.playerengine.tasks.entity.KillEntityTask;
import com.player2.playerengine.tasks.movement.GetWithinRangeOfBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1560;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;

public class KillEndermanTask
extends ResourceTask {
    private final int count;
    private final TimerGame lookDelay = new TimerGame(0.2);

    public KillEndermanTask(int count) {
        super(new ItemTarget(class_1802.field_8634, count));
        this.count = count;
        this.forceDimension(Dimension.NETHER);
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (!mod.getEntityTracker().entityFound(class_1560.class)) {
            if (WorldHelper.getCurrentDimension(mod) != Dimension.NETHER) {
                return this.getToCorrectDimensionTask(mod);
            }
            Optional<class_2338> nearest = mod.getBlockScanner().getNearestBlock(class_2246.field_23078, class_2246.field_23079, class_2246.field_22503, class_2246.field_22113);
            if (nearest.isPresent()) {
                if (WorldHelper.inRangeXZ(nearest.get(), mod.getPlayer().method_24515(), 40.0)) {
                    this.setDebugState("Waiting for endermen to spawn...");
                    return null;
                }
                this.setDebugState("Getting to warped forest biome");
                return new GetWithinRangeOfBlockTask(nearest.get(), 35);
            }
            this.setDebugState("Warped forest biome not found");
            return new TimeoutWanderTask();
        }
        Predicate<class_1297> belowNetherRoof = entityx -> WorldHelper.getCurrentDimension(mod) != Dimension.NETHER || entityx.method_23318() < 125.0;
        int TOO_FAR_AWAY = WorldHelper.getCurrentDimension(mod) == Dimension.NETHER ? 10 : 256;
        for (class_1560 entity : mod.getEntityTracker().getTrackedEntities(class_1560.class)) {
            if (!entity.method_5805() || !belowNetherRoof.test((class_1297)entity) || !entity.method_7028() || !entity.method_19538().method_24802((class_2374)mod.getPlayer().method_19538(), (double)TOO_FAR_AWAY)) continue;
            return new KillEntityTask((class_1297)entity);
        }
        return new KillEntitiesTask(belowNetherRoof, class_1560.class);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof KillEndermanTask) {
            KillEndermanTask task = (KillEndermanTask)other;
            bl = task.count == this.count;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Hunting endermen for pearls - " + this.controller.getItemStorage().getItemCount(class_1802.field_8634) + "/" + this.count;
    }
}

