/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers.storage;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.trackers.Tracker;
import com.player2.playerengine.trackers.TrackerManager;
import com.player2.playerengine.trackers.storage.ContainerCache;
import com.player2.playerengine.trackers.storage.ContainerSubTracker;
import com.player2.playerengine.trackers.storage.InventorySubTracker;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.slots.Slot;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class ItemStorageTracker
extends Tracker {
    private final InventorySubTracker inventory;
    public final ContainerSubTracker containers;

    public ItemStorageTracker(PlayerEngineController mod, TrackerManager manager, Consumer<ContainerSubTracker> containerTrackerConsumer) {
        super(manager);
        this.inventory = new InventorySubTracker(manager);
        this.containers = new ContainerSubTracker(manager);
        containerTrackerConsumer.accept(this.containers);
    }

    public int getItemCount(class_1792 ... items) {
        return this.inventory.getItemCount(items);
    }

    public int getItemCount(ItemTarget ... targets) {
        return Arrays.stream(targets).mapToInt(target -> this.getItemCount(target.getMatches())).sum();
    }

    @Deprecated
    public int getItemCountScreen(class_1792 ... items) {
        return this.getItemCount(items);
    }

    public int getItemCountInventoryOnly(class_1792 ... items) {
        return this.getItemCount(items);
    }

    public boolean hasItemInventoryOnly(class_1792 ... items) {
        return this.inventory.hasItem(items);
    }

    public boolean hasItem(class_1792 ... items) {
        return this.inventory.hasItem(items);
    }

    public boolean hasItemAll(class_1792 ... items) {
        return Arrays.stream(items).allMatch(xva$0 -> this.hasItem((class_1792)xva$0));
    }

    public boolean hasItem(ItemTarget ... targets) {
        return Arrays.stream(targets).anyMatch(target -> this.hasItem(target.getMatches()));
    }

    public boolean hasItemInOffhand(PlayerEngineController controller, class_1792 item) {
        class_1799 offhand = StorageHelper.getItemStackInSlot(new Slot(controller.getInventory().offHand, 0));
        return offhand.method_7909() == item;
    }

    public List<Slot> getSlotsWithItemPlayerInventory(boolean includeArmor, class_1792 ... items) {
        return this.inventory.getSlotsWithItemsPlayerInventory(includeArmor, items);
    }

    public List<class_1799> getItemStacksPlayerInventory(boolean includeCursorSlot) {
        List<class_1799> stacks = this.inventory.getInventoryStacks();
        if (includeCursorSlot) {
            stacks.add(0, this.mod.getSlotHandler().getCursorStack());
        }
        return stacks;
    }

    public List<Slot> getSlotsThatCanFitInPlayerInventory(class_1799 stack, boolean acceptPartial) {
        return this.inventory.getSlotsThatCanFit(stack, acceptPartial);
    }

    public Optional<Slot> getSlotThatCanFitInPlayerInventory(class_1799 stack, boolean acceptPartial) {
        return this.getSlotsThatCanFitInPlayerInventory(stack, acceptPartial).stream().findFirst();
    }

    public boolean hasEmptyInventorySlot() {
        return this.inventory.hasEmptySlot();
    }

    public boolean hasItemContainer(Predicate<ContainerCache> accept, class_1792 ... items) {
        return this.containers.getCachedContainers(accept).stream().anyMatch(cache -> cache.hasItem(items));
    }

    public Optional<ContainerCache> getContainerAtPosition(class_2338 pos) {
        return this.containers.getContainerAtPosition(pos);
    }

    public List<ContainerCache> getContainersWithItem(class_1792 ... items) {
        return this.containers.getContainersWithItem(items);
    }

    public Optional<ContainerCache> getClosestContainerWithItem(class_243 pos, class_1792 ... items) {
        return this.containers.getCachedContainers(c -> c.hasItem(items)).stream().min(Comparator.comparingDouble(c -> c.getBlockPos().method_10262(new class_2382((int)pos.method_10216(), (int)pos.method_10214(), (int)pos.method_10215()))));
    }

    public Optional<class_2338> getLastBlockPosInteraction() {
        return this.containers.getLastInteractedContainer();
    }

    public void registerSlotAction() {
        this.inventory.setDirty();
    }

    @Override
    protected void updateState() {
        this.inventory.ensureUpdated();
        this.containers.ensureUpdated();
    }

    @Override
    protected void reset() {
        this.inventory.reset();
        this.containers.reset();
    }
}

