/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.baritone;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalXZ;
import com.player2.playerengine.automaton.api.pathing.goals.GoalYLevel;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import java.util.List;
import net.minecraft.class_1297;

public abstract class GoalRunAwayFromEntities
implements Goal {
    private final PlayerEngineController mod;
    private final double distance;
    private final boolean xzOnly;
    private final double penaltyFactor;

    public GoalRunAwayFromEntities(PlayerEngineController mod, double distance, boolean xzOnly, double penaltyFactor) {
        this.mod = mod;
        this.distance = distance;
        this.xzOnly = xzOnly;
        this.penaltyFactor = penaltyFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInGoal(int x, int y, int z) {
        List<class_1297> entities = this.getEntities(this.mod);
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            if (!entities.isEmpty()) {
                for (class_1297 entity : entities) {
                    double sqDistance;
                    if (entity == null || !entity.method_5805() || !((sqDistance = this.xzOnly ? entity.method_19538().method_1023((double)x, (double)y, (double)z).method_18805(1.0, 0.0, 1.0).method_1027() : entity.method_5649((double)x, (double)y, (double)z)) < this.distance * this.distance)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double heuristic(int x, int y, int z) {
        double costSum = 0.0;
        List<class_1297> entities = this.getEntities(this.mod);
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            int max = 10;
            int counter = 0;
            if (!entities.isEmpty()) {
                for (class_1297 entity : entities) {
                    ++counter;
                    if (entity == null || !entity.method_5805()) continue;
                    double cost = this.getCostOfEntity(entity, x, y, z);
                    costSum = cost != 0.0 ? (costSum += 1.0 / cost) : (costSum += 1000.0);
                    if (counter < max) continue;
                    break;
                }
            }
            if (counter > 0) {
                costSum /= (double)counter;
            }
            return costSum * this.penaltyFactor;
        }
    }

    protected abstract List<class_1297> getEntities(PlayerEngineController var1);

    protected double getCostOfEntity(class_1297 entity, int x, int y, int z) {
        double heuristic = 0.0;
        if (!this.xzOnly) {
            heuristic += GoalYLevel.calculate(entity.method_24515().method_10264(), y);
        }
        return heuristic + GoalXZ.calculate(entity.method_24515().method_10263() - x, entity.method_24515().method_10260() - z);
    }
}

