/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.AdditionalBaritoneSettings;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.utils.Debug;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;

public class BotBehaviour {
    private final PlayerEngineController mod;
    Deque<State> states = new ArrayDeque<State>();

    public BotBehaviour(PlayerEngineController mod) {
        this.mod = mod;
        this.push();
    }

    public boolean shouldEscapeLava() {
        return this.current().escapeLava;
    }

    public void setEscapeLava(boolean allow) {
        this.current().escapeLava = allow;
        this.current().applyState();
    }

    public void setFollowDistance(double distance) {
        this.current().followOffsetDistance = distance;
        this.current().applyState();
    }

    public void setMineScanDroppedItems(boolean value) {
        this.current().mineScanDroppedItems = value;
        this.current().applyState();
    }

    public boolean exclusivelyMineLogs() {
        return this.current().exclusivelyMineLogs;
    }

    public void setExclusivelyMineLogs(boolean value) {
        this.current().exclusivelyMineLogs = value;
        this.current().applyState();
    }

    public boolean shouldExcludeFromForcefield(Entity entity) {
        if (!this.current().excludeFromForceField.isEmpty()) {
            for (Predicate<Entity> pred : this.current().excludeFromForceField) {
                if (!pred.test(entity)) continue;
                return true;
            }
        }
        return false;
    }

    public void addForceFieldExclusion(Predicate<Entity> pred) {
        this.current().excludeFromForceField.add(pred);
    }

    public void avoidBlockBreaking(BlockPos pos) {
        this.current().blocksToAvoidBreaking.add(pos);
        this.current().applyState();
    }

    public void avoidBlockBreaking(Predicate<BlockPos> pred) {
        this.current().toAvoidBreaking.add(pred);
        this.current().applyState();
    }

    public void avoidBlockPlacing(Predicate<BlockPos> pred) {
        this.current().toAvoidPlacing.add(pred);
        this.current().applyState();
    }

    public void allowWalkingOn(Predicate<BlockPos> pred) {
        this.current().allowWalking.add(pred);
        this.current().applyState();
    }

    public void avoidWalkingThrough(Predicate<BlockPos> pred) {
        this.current().avoidWalkingThrough.add(pred);
        this.current().applyState();
    }

    public void forceUseTool(BiPredicate<BlockState, ItemStack> pred) {
        this.current().forceUseTools.add(pred);
        this.current().applyState();
    }

    public void setRayTracingFluidHandling(ClipContext.Fluid fluidHandling) {
        this.current().rayFluidHandling = fluidHandling;
        this.current().applyState();
    }

    public void setAllowWalkThroughFlowingWater(boolean value) {
        this.current().allowWalkThroughFlowingWater = value;
        this.current().applyState();
    }

    public void setPauseOnLostFocus(boolean pauseOnLostFocus) {
        this.current().pauseOnLostFocus = pauseOnLostFocus;
        this.current().applyState();
    }

    public void addProtectedItems(Item ... items) {
        Collections.addAll(this.current().protectedItems, items);
        this.current().applyState();
    }

    public void removeProtectedItems(Item ... items) {
        this.current().protectedItems.removeAll(Arrays.asList(items));
        this.current().applyState();
    }

    public boolean isProtected(Item item) {
        return this.current().protectedItems.contains(item);
    }

    public boolean shouldForceFieldPlayers() {
        return this.current().forceFieldPlayers;
    }

    public void setForceFieldPlayers(boolean forceFieldPlayers) {
        this.current().forceFieldPlayers = forceFieldPlayers;
    }

    public void allowSwimThroughLava(boolean allow) {
        this.current().swimThroughLava = allow;
        this.current().applyState();
    }

    public void setPreferredStairs(boolean allow) {
        this.current().applyState();
    }

    public void setAllowDiagonalAscend(boolean allow) {
        this.current().allowDiagonalAscend = allow;
        this.current().applyState();
    }

    public void setBlockPlacePenalty(double penalty) {
        this.current().blockPlacePenalty = penalty;
        this.current().applyState();
    }

    public void setBlockBreakAdditionalPenalty(double penalty) {
        this.current().blockBreakAdditionalPenalty = penalty;
        this.current().applyState();
    }

    public void avoidDodgingProjectile(Predicate<Entity> whenToDodge) {
        this.current().avoidDodgingProjectile.add(whenToDodge);
    }

    public void addGlobalHeuristic(BiFunction<Double, BlockPos, Double> heuristic) {
        this.current().globalHeuristics.add(heuristic);
        this.current().applyState();
    }

    public boolean shouldAvoidDodgingProjectile(Entity entity) {
        if (!this.current().avoidDodgingProjectile.isEmpty()) {
            for (Predicate<Entity> test : this.current().avoidDodgingProjectile) {
                if (!test.test(entity)) continue;
                return true;
            }
        }
        return false;
    }

    public void push() {
        if (this.states.isEmpty()) {
            this.states.push(new State());
        } else {
            this.states.push(new State(this.current()));
        }
    }

    public void push(State customState) {
        this.states.push(customState);
    }

    public State pop() {
        if (this.states.isEmpty()) {
            Debug.logError("State stack is empty. This shouldn't be happening.");
            return null;
        }
        State popped = this.states.pop();
        if (this.states.isEmpty()) {
            Debug.logError("State stack is empty after pop. This shouldn't be happening.");
            return null;
        }
        this.states.peek().applyState();
        return popped;
    }

    private State current() {
        if (this.states.isEmpty()) {
            Debug.logError("STATE EMPTY, UNEMPTIED!");
            this.push();
        }
        return this.states.peek();
    }

    private class State {
        public double followOffsetDistance;
        public HashSet<Item> protectedItems = new HashSet();
        public boolean mineScanDroppedItems;
        public boolean swimThroughLava;
        public boolean allowDiagonalAscend;
        public double blockPlacePenalty;
        public double blockBreakAdditionalPenalty;
        public boolean exclusivelyMineLogs;
        public boolean forceFieldPlayers;
        public List<Predicate<Entity>> avoidDodgingProjectile = new ArrayList<Predicate<Entity>>();
        public List<Predicate<Entity>> excludeFromForceField = new ArrayList<Predicate<Entity>>();
        public HashSet<BlockPos> blocksToAvoidBreaking = new HashSet();
        public List<Predicate<BlockPos>> toAvoidBreaking = new ArrayList<Predicate<BlockPos>>();
        public List<Predicate<BlockPos>> toAvoidPlacing = new ArrayList<Predicate<BlockPos>>();
        public List<Predicate<BlockPos>> allowWalking = new ArrayList<Predicate<BlockPos>>();
        public List<Predicate<BlockPos>> avoidWalkingThrough = new ArrayList<Predicate<BlockPos>>();
        public List<BiPredicate<BlockState, ItemStack>> forceUseTools = new ArrayList<BiPredicate<BlockState, ItemStack>>();
        public List<BiFunction<Double, BlockPos, Double>> globalHeuristics = new ArrayList<BiFunction<Double, BlockPos, Double>>();
        public boolean allowWalkThroughFlowingWater = false;
        public boolean pauseOnLostFocus = true;
        public ClipContext.Fluid rayFluidHandling;
        public boolean escapeLava = true;

        public State() {
            this(null);
        }

        public State(State toCopy) {
            this.readState(BotBehaviour.this.mod.getBaritoneSettings());
            this.readExtraState(BotBehaviour.this.mod.getExtraBaritoneSettings());
            this.readMinecraftState();
            if (toCopy != null) {
                this.exclusivelyMineLogs = toCopy.exclusivelyMineLogs;
                this.avoidDodgingProjectile.addAll(toCopy.avoidDodgingProjectile);
                this.excludeFromForceField.addAll(toCopy.excludeFromForceField);
                this.forceFieldPlayers = toCopy.forceFieldPlayers;
                this.escapeLava = toCopy.escapeLava;
            }
        }

        public void applyState() {
            this.applyState(BotBehaviour.this.mod.getBaritoneSettings(), BotBehaviour.this.mod.getExtraBaritoneSettings());
        }

        private void readState(Settings s) {
            this.followOffsetDistance = s.followOffsetDistance.get();
            this.mineScanDroppedItems = s.mineScanDroppedItems.get();
            this.swimThroughLava = s.assumeWalkOnLava.get();
            this.allowDiagonalAscend = s.allowDiagonalAscend.get();
            this.blockPlacePenalty = s.blockPlacementPenalty.get();
            this.blockBreakAdditionalPenalty = s.blockBreakAdditionalPenalty.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readExtraState(AdditionalBaritoneSettings settings) {
            Object object = settings.getBreakMutex();
            synchronized (object) {
                Object object2 = settings.getPlaceMutex();
                synchronized (object2) {
                    this.blocksToAvoidBreaking = new HashSet<BlockPos>(settings.getBlocksToAvoidBreaking());
                    this.toAvoidBreaking = new ArrayList<Predicate<BlockPos>>(settings.getBreakAvoiders());
                    this.toAvoidPlacing = new ArrayList<Predicate<BlockPos>>(settings.getPlaceAvoiders());
                    this.protectedItems = new HashSet<Item>(settings.getProtectedItems());
                    Object object3 = settings.getPropertiesMutex();
                    synchronized (object3) {
                        this.allowWalking = new ArrayList<Predicate<BlockPos>>(settings.getForceWalkOnPredicates());
                        this.avoidWalkingThrough = new ArrayList<Predicate<BlockPos>>(settings.getForceAvoidWalkThroughPredicates());
                        this.forceUseTools = new ArrayList<BiPredicate<BlockState, ItemStack>>(settings.getForceUseToolPredicates());
                    }
                }
            }
            object = settings.getGlobalHeuristicMutex();
            synchronized (object) {
                this.globalHeuristics = new ArrayList<BiFunction<Double, BlockPos, Double>>(settings.getGlobalHeuristics());
            }
            this.allowWalkThroughFlowingWater = settings.isFlowingWaterPassAllowed();
            this.rayFluidHandling = RayTraceUtils.fluidHandling;
        }

        private void readMinecraftState() {
            this.pauseOnLostFocus = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyState(Settings s, AdditionalBaritoneSettings sa) {
            s.followOffsetDistance.set(this.followOffsetDistance);
            s.mineScanDroppedItems.set(this.mineScanDroppedItems);
            s.allowDiagonalAscend.set(this.allowDiagonalAscend);
            s.blockPlacementPenalty.set(this.blockPlacePenalty);
            s.blockBreakAdditionalPenalty.set(this.blockBreakAdditionalPenalty);
            Object object = sa.getBreakMutex();
            synchronized (object) {
                Object object2 = sa.getPlaceMutex();
                synchronized (object2) {
                    sa.getBreakAvoiders().clear();
                    sa.getBreakAvoiders().addAll(this.toAvoidBreaking);
                    sa.getBlocksToAvoidBreaking().clear();
                    sa.getBlocksToAvoidBreaking().addAll(this.blocksToAvoidBreaking);
                    sa.getPlaceAvoiders().clear();
                    sa.getPlaceAvoiders().addAll(this.toAvoidPlacing);
                    sa.getProtectedItems().clear();
                    sa.getProtectedItems().addAll(this.protectedItems);
                    Object object3 = sa.getPropertiesMutex();
                    synchronized (object3) {
                        sa.getForceWalkOnPredicates().clear();
                        sa.getForceWalkOnPredicates().addAll(this.allowWalking);
                        sa.getForceAvoidWalkThroughPredicates().clear();
                        sa.getForceAvoidWalkThroughPredicates().addAll(this.avoidWalkingThrough);
                        sa.getForceUseToolPredicates().clear();
                        sa.getForceUseToolPredicates().addAll(this.forceUseTools);
                    }
                }
            }
            object = sa.getGlobalHeuristicMutex();
            synchronized (object) {
                sa.getGlobalHeuristics().clear();
                sa.getGlobalHeuristics().addAll(this.globalHeuristics);
            }
            sa.setFlowingWaterPass(this.allowWalkThroughFlowingWater);
            sa.allowSwimThroughLava(this.swimThroughLava);
            RayTraceUtils.fluidHandling = this.rayFluidHandling;
        }
    }
}

