/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.command;

import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public interface ICommand {
    public void execute(CommandSourceStack var1, String var2, IArgConsumer var3, IBaritone var4) throws CommandException;

    public Stream<String> tabComplete(String var1, IArgConsumer var2) throws CommandException;

    public String getShortDesc();

    public List<String> getLongDesc();

    public List<String> getNames();

    default public boolean hiddenFromHelp() {
        return false;
    }

    default public void logDirect(CommandSourceStack source, Component ... components) {
        source.sendSuccess(() -> {
            MutableComponent component = Component.literal((String)"");
            component.append(BaritoneAPI.getPrefix());
            component.append((Component)Component.literal((String)" "));
            for (Component t : components) {
                component.append(t);
            }
            return component;
        }, false);
    }

    default public void logDirect(CommandSourceStack source, String message, ChatFormatting color) {
        Stream.of(message.split("\n")).forEach(line -> {
            MutableComponent component = Component.literal((String)line.replace("\t", "    "));
            component.setStyle(component.getStyle().applyFormat(color));
            this.logDirect(source, new Component[]{component});
        });
    }

    default public void logDirect(CommandSourceStack source, String message) {
        this.logDirect(source, message, ChatFormatting.GRAY);
    }
}

