/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class RotationUtils {
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    private static final Vec3[] BLOCK_SIDE_MULTIPLIERS = new Vec3[]{new Vec3(0.5, 0.0, 0.5), new Vec3(0.5, 1.0, 0.5), new Vec3(0.5, 0.5, 0.0), new Vec3(0.5, 0.5, 1.0), new Vec3(0.0, 0.5, 0.5), new Vec3(1.0, 0.5, 0.5)};

    private RotationUtils() {
    }

    public static Rotation calcRotationFromCoords(BlockPos orig, BlockPos dest) {
        return RotationUtils.calcRotationFromVec3d(new Vec3((double)orig.getX(), (double)orig.getY(), (double)orig.getZ()), new Vec3((double)dest.getX(), (double)dest.getY(), (double)dest.getZ()));
    }

    public static Rotation wrapAnglesToRelative(Rotation current, Rotation target) {
        return current.yawIsReallyClose(target) ? new Rotation(current.getYaw(), target.getPitch()) : target.subtract(current).normalize().add(current);
    }

    public static Rotation calcRotationFromVec3d(Vec3 orig, Vec3 dest, Rotation current) {
        return RotationUtils.wrapAnglesToRelative(current, RotationUtils.calcRotationFromVec3d(orig, dest));
    }

    public static Rotation calcRotationFromVec3d(Vec3 orig, Vec3 dest) {
        double[] delta = new double[]{orig.x - dest.x, orig.y - dest.y, orig.z - dest.z};
        double yaw = Mth.atan2((double)delta[0], (double)(-delta[2]));
        double dist = Math.sqrt(delta[0] * delta[0] + delta[2] * delta[2]);
        double pitch = Mth.atan2((double)delta[1], (double)dist);
        return new Rotation((float)(yaw * 57.29577951308232), (float)(pitch * 57.29577951308232));
    }

    public static Vec3 calcVector3dFromRotation(Rotation rotation) {
        float f = Mth.cos((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.sin((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.cos((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        float f3 = Mth.sin((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static Optional<Rotation> reachable(IEntityContext ctx, BlockPos pos) {
        return RotationUtils.reachable(ctx.entity(), pos, ctx.playerController().getBlockReachDistance());
    }

    public static Optional<Rotation> reachable(IEntityContext ctx, BlockPos pos, boolean wouldSneak) {
        return RotationUtils.reachable(ctx.entity(), pos, ctx.playerController().getBlockReachDistance(), wouldSneak);
    }

    public static Optional<Rotation> reachable(LivingEntity entity, BlockPos pos, double blockReachDistance) {
        return RotationUtils.reachable(entity, pos, blockReachDistance, false);
    }

    public static Optional<Rotation> reachable(LivingEntity entity, BlockPos pos, double blockReachDistance, boolean wouldSneak) {
        Optional<Rotation> possibleRotation;
        IBaritone baritone = BaritoneAPI.getProvider().getBaritone(entity);
        if (baritone.getEntityContext().isLookingAt(pos)) {
            Rotation hypothetical = new Rotation(entity.getYRot(), entity.getXRot() + 1.0E-4f);
            if (!wouldSneak) {
                return Optional.of(hypothetical);
            }
            HitResult result = RayTraceUtils.rayTraceTowards((Entity)entity, hypothetical, blockReachDistance, true);
            if (result != null && result.getType() == HitResult.Type.BLOCK && ((BlockHitResult)result).getBlockPos().equals((Object)pos)) {
                return Optional.of(hypothetical);
            }
        }
        if ((possibleRotation = RotationUtils.reachableCenter((Entity)entity, pos, blockReachDistance, wouldSneak)).isPresent()) {
            return possibleRotation;
        }
        BlockState state = entity.level().getBlockState(pos);
        VoxelShape shape = state.getShape((BlockGetter)entity.level(), pos);
        if (shape.isEmpty()) {
            shape = Shapes.block();
        }
        for (Vec3 sideOffset : BLOCK_SIDE_MULTIPLIERS) {
            double xDiff = shape.min(Direction.Axis.X) * sideOffset.x + shape.max(Direction.Axis.X) * (1.0 - sideOffset.x);
            double yDiff = shape.min(Direction.Axis.Y) * sideOffset.y + shape.max(Direction.Axis.Y) * (1.0 - sideOffset.y);
            double zDiff = shape.min(Direction.Axis.Z) * sideOffset.z + shape.max(Direction.Axis.Z) * (1.0 - sideOffset.z);
            possibleRotation = RotationUtils.reachableOffset((Entity)entity, pos, new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(xDiff, yDiff, zDiff), blockReachDistance, wouldSneak);
            if (!possibleRotation.isPresent()) continue;
            return possibleRotation;
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableOffset(Entity entity, BlockPos pos, Vec3 offsetPos, double blockReachDistance, boolean wouldSneak) {
        Vec3 eyes = wouldSneak ? RayTraceUtils.inferSneakingEyePosition(entity) : entity.getEyePosition(1.0f);
        Rotation rotation = RotationUtils.calcRotationFromVec3d(eyes, offsetPos, new Rotation(entity.getYRot(), entity.getXRot()));
        HitResult result = RayTraceUtils.rayTraceTowards(entity, rotation, blockReachDistance, wouldSneak);
        if (result != null && result.getType() == HitResult.Type.BLOCK) {
            if (((BlockHitResult)result).getBlockPos().equals((Object)pos)) {
                return Optional.of(rotation);
            }
            if (entity.level().getBlockState(pos).getBlock() instanceof BaseFireBlock && ((BlockHitResult)result).getBlockPos().equals((Object)pos.below())) {
                return Optional.of(rotation);
            }
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableCenter(Entity entity, BlockPos pos, double blockReachDistance, boolean wouldSneak) {
        return RotationUtils.reachableOffset(entity, pos, VecUtils.calculateBlockCenter(entity.level(), pos), blockReachDistance, wouldSneak);
    }
}

