/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.player2.playerengine.automaton.entity.CustomFishingBobberEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CustomFishingBobberRenderer
extends EntityRenderer<CustomFishingBobberEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.tryParse((String)"textures/entity/fishing_hook.png");
    private static final RenderType LAYER = RenderType.entityCutout((ResourceLocation)TEXTURE);
    private static final double BOBBING_VIEW_SCALE = 960.0;

    public CustomFishingBobberRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(CustomFishingBobberEntity fishingBobberEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        LivingEntity playerEntity = fishingBobberEntity.getPlayerOwner();
        if (playerEntity != null) {
            float r;
            double q;
            double p;
            double o;
            double s;
            matrixStack.pushPose();
            matrixStack.pushPose();
            matrixStack.scale(0.5f, 0.5f, 0.5f);
            matrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            PoseStack.Pose entry = matrixStack.last();
            Matrix4f matrix4f = entry.pose();
            Matrix3f matrix3f = entry.normal();
            VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(LAYER);
            CustomFishingBobberRenderer.vertex(matrixStack, vertexConsumer, matrix4f, matrix3f, i, 0.0f, 0, 0, 1);
            CustomFishingBobberRenderer.vertex(matrixStack, vertexConsumer, matrix4f, matrix3f, i, 1.0f, 0, 1, 1);
            CustomFishingBobberRenderer.vertex(matrixStack, vertexConsumer, matrix4f, matrix3f, i, 1.0f, 1, 1, 0);
            CustomFishingBobberRenderer.vertex(matrixStack, vertexConsumer, matrix4f, matrix3f, i, 0.0f, 1, 0, 0);
            matrixStack.popPose();
            int j = playerEntity.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
            ItemStack itemStack = playerEntity.getMainHandItem();
            if (!itemStack.is(Items.FISHING_ROD)) {
                j = -j;
            }
            float h = playerEntity.getAttackAnim(g);
            float k = Mth.sin((float)(Mth.sqrt((float)h) * (float)Math.PI));
            float l = Mth.lerp((float)g, (float)playerEntity.yBodyRotO, (float)playerEntity.yBodyRot) * ((float)Math.PI / 180);
            double d = Mth.sin((float)l);
            double e = Mth.cos((float)l);
            double m = (double)j * 0.35;
            double n = 0.8;
            if ((this.entityRenderDispatcher.options == null || this.entityRenderDispatcher.options.getCameraType().isFirstPerson()) && playerEntity == Minecraft.getInstance().player) {
                s = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
                Vec3 vec3d = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)j * 0.525f, -0.1f);
                vec3d = vec3d.scale(s);
                vec3d = vec3d.yRot(k * 0.5f);
                vec3d = vec3d.xRot(-k * 0.7f);
                o = Mth.lerp((double)g, (double)playerEntity.xo, (double)playerEntity.getX()) + vec3d.x;
                p = Mth.lerp((double)g, (double)playerEntity.yo, (double)playerEntity.getY()) + vec3d.y;
                q = Mth.lerp((double)g, (double)playerEntity.zo, (double)playerEntity.getZ()) + vec3d.z;
                r = playerEntity.getEyeHeight();
            } else {
                o = Mth.lerp((double)g, (double)playerEntity.xo, (double)playerEntity.getX()) - e * m - d * 0.8;
                p = playerEntity.yo + (double)playerEntity.getEyeHeight() + (playerEntity.getY() - playerEntity.yo) * (double)g - 0.45;
                q = Mth.lerp((double)g, (double)playerEntity.zo, (double)playerEntity.getZ()) - d * m + e * 0.8;
                r = playerEntity.isCrouching() ? -0.1875f : 0.0f;
            }
            s = Mth.lerp((double)g, (double)fishingBobberEntity.xo, (double)fishingBobberEntity.getX());
            double t = Mth.lerp((double)g, (double)fishingBobberEntity.yo, (double)fishingBobberEntity.getY()) + 0.25;
            double u = Mth.lerp((double)g, (double)fishingBobberEntity.zo, (double)fishingBobberEntity.getZ());
            float v = (float)(o - s);
            float w = (float)(p - t) + r;
            float x = (float)(q - u);
            VertexConsumer vertexConsumer2 = vertexConsumerProvider.getBuffer(RenderType.lineStrip());
            PoseStack.Pose entry2 = matrixStack.last();
            int y = 16;
            for (int z = 0; z <= 16; ++z) {
                CustomFishingBobberRenderer.drawArcSection(v, w, x, vertexConsumer2, entry2, CustomFishingBobberRenderer.percentage(z, 16), CustomFishingBobberRenderer.percentage(z + 1, 16));
            }
            matrixStack.popPose();
            super.render((Entity)fishingBobberEntity, f, g, matrixStack, vertexConsumerProvider, i);
        }
    }

    private static float percentage(int value, int max) {
        return (float)value / (float)max;
    }

    private static void vertex(PoseStack matrixStack, VertexConsumer buffer, Matrix4f matrix, Matrix3f normalMatrix, int light, float x, int y, int u, int v) {
        buffer.addVertex(matrix, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(255, 255, 255, 255).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(matrixStack.last(), 0.0f, 1.0f, 0.0f);
    }

    private static void drawArcSection(float x, float y, float z, VertexConsumer buffer, PoseStack.Pose normal, float startPercent, float endPercent) {
        float f = x * startPercent;
        float g = y * (startPercent * startPercent + startPercent) * 0.5f + 0.25f;
        float h = z * startPercent;
        float i = x * endPercent - f;
        float j = y * (endPercent * endPercent + endPercent) * 0.5f + 0.25f - g;
        float k = z * endPercent - h;
        float l = Mth.sqrt((float)(i * i + j * j + k * k));
        buffer.addVertex(normal.pose(), f, g, h).setColor(0, 0, 0, 255).setNormal(normal, i /= l, j /= l, k /= l);
    }

    public ResourceLocation getTextureLocation(CustomFishingBobberEntity fishingBobberEntity) {
        return TEXTURE;
    }
}

