/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.command.defaults;

import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.command.Command;
import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.command.exception.CommandInvalidStateException;
import com.player2.playerengine.automaton.api.command.manager.ICommandManager;
import com.player2.playerengine.automaton.api.process.IBaritoneProcess;
import com.player2.playerengine.automaton.api.process.PathingCommand;
import com.player2.playerengine.automaton.api.process.PathingCommandType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;

public class ExecutionControlCommands {
    private final Command pauseCommand = new Command(this, new String[]{"pause", "p"}){

        @Override
        public void execute(CommandSourceStack source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
            args.requireMax(0);
            ExecControlProcess controlProcess = (ExecControlProcess)((Baritone)baritone).getExecControlProcess();
            if (controlProcess.paused) {
                throw new CommandInvalidStateException("Already paused");
            }
            controlProcess.paused = true;
            this.logDirect(source, "Paused");
        }

        @Override
        public Stream<String> tabComplete(String label, IArgConsumer args) {
            return Stream.empty();
        }

        @Override
        public String getShortDesc() {
            return "Pauses Automatone until you use resume";
        }

        @Override
        public List<String> getLongDesc() {
            return Arrays.asList("The pause command tells Automatone to temporarily stop whatever it's doing.", "", "This can be used to pause pathing, building, following, whatever. A single use of the resume command will start it right back up again!", "", "Usage:", "> pause");
        }
    };
    private final Command resumeCommand = new Command(this, new String[]{"resume", "r"}){

        @Override
        public void execute(CommandSourceStack source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
            args.requireMax(0);
            baritone.getBuilderProcess().resume();
            ExecControlProcess controlProcess = (ExecControlProcess)((Baritone)baritone).getExecControlProcess();
            if (!controlProcess.paused) {
                throw new CommandInvalidStateException("Not paused");
            }
            controlProcess.paused = false;
            this.logDirect(source, "Resumed");
        }

        @Override
        public Stream<String> tabComplete(String label, IArgConsumer args) {
            return Stream.empty();
        }

        @Override
        public String getShortDesc() {
            return "Resumes Automatone processes after a pause";
        }

        @Override
        public List<String> getLongDesc() {
            return Arrays.asList("The resume command tells Automatone to resume whatever it was doing when you last used pause.", "", "Usage:", "> resume");
        }
    };
    private final Command pausedCommand = new Command(this, new String[]{"paused"}){

        @Override
        public void execute(CommandSourceStack source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
            args.requireMax(0);
            boolean paused = ((ExecControlProcess)((Baritone)baritone).getExecControlProcess()).paused;
            this.logDirect(source, String.format("Automatone is %spaused", paused ? "" : "not "));
        }

        @Override
        public Stream<String> tabComplete(String label, IArgConsumer args) {
            return Stream.empty();
        }

        @Override
        public String getShortDesc() {
            return "Tells you if Baritone is paused";
        }

        @Override
        public List<String> getLongDesc() {
            return Arrays.asList("The paused command tells you if Baritone is currently paused by use of the pause command.", "", "Usage:", "> paused");
        }
    };
    private final Command cancelCommand = new Command(this, new String[]{"cancel", "c", "stop"}){

        @Override
        public void execute(CommandSourceStack source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
            args.requireMax(0);
            ((ExecControlProcess)((Baritone)baritone).getExecControlProcess()).paused = false;
            baritone.getPathingBehavior().cancelEverything();
            this.logDirect(source, "ok canceled");
        }

        @Override
        public Stream<String> tabComplete(String label, IArgConsumer args) {
            return Stream.empty();
        }

        @Override
        public String getShortDesc() {
            return "Cancel what Baritone is currently doing";
        }

        @Override
        public List<String> getLongDesc() {
            return Arrays.asList("The cancel command tells Automatone to stop whatever it's currently doing.", "", "Usage:", "> cancel");
        }
    };

    public void registerCommands() {
        ICommandManager.registry.register(this.pauseCommand);
        ICommandManager.registry.register(this.resumeCommand);
        ICommandManager.registry.register(this.pausedCommand);
        ICommandManager.registry.register(this.cancelCommand);
    }

    public IBaritoneProcess registerProcess(IBaritone baritone) {
        ExecControlProcess proc = new ExecControlProcess();
        baritone.getPathingControlManager().registerProcess(proc);
        return proc;
    }

    private static class ExecControlProcess
    implements IBaritoneProcess {
        boolean paused;

        private ExecControlProcess() {
        }

        @Override
        public boolean isActive() {
            return this.paused;
        }

        @Override
        public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }

        @Override
        public boolean isTemporary() {
            return true;
        }

        @Override
        public void onLostControl() {
        }

        @Override
        public double priority() {
            return 0.0;
        }

        @Override
        public String displayName0() {
            return "Pause/Resume Commands";
        }
    }
}

