/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.process;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalBlock;
import com.player2.playerengine.automaton.api.pathing.goals.GoalComposite;
import com.player2.playerengine.automaton.api.process.IFarmProcess;
import com.player2.playerengine.automaton.api.process.PathingCommand;
import com.player2.playerengine.automaton.api.process.PathingCommandType;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.api.utils.interfaces.IGoalRenderPos;
import com.player2.playerengine.automaton.cache.WorldScanner;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.process.BuilderProcess;
import com.player2.playerengine.automaton.utils.BaritoneProcessHelper;
import com.player2.playerengine.automaton.utils.NotificationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class FarmProcess
extends BaritoneProcessHelper
implements IFarmProcess {
    private boolean active;
    private List<BlockPos> locations;
    private int tickCount;
    private int range;
    private BlockPos center;
    private static final List<Item> FARMLAND_PLANTABLE = Arrays.asList(Items.BEETROOT_SEEDS, Items.MELON_SEEDS, Items.WHEAT_SEEDS, Items.PUMPKIN_SEEDS, Items.POTATO, Items.CARROT);
    private static final List<Item> PICKUP_DROPPED = Arrays.asList(Items.BEETROOT_SEEDS, Items.BEETROOT, Items.MELON_SEEDS, Items.MELON_SLICE, Blocks.MELON.asItem(), Items.WHEAT_SEEDS, Items.WHEAT, Items.PUMPKIN_SEEDS, Blocks.PUMPKIN.asItem(), Items.POTATO, Items.CARROT, Items.NETHER_WART, Blocks.SUGAR_CANE.asItem(), Blocks.CACTUS.asItem());

    public FarmProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void farm(int range, BlockPos pos) {
        this.center = pos == null ? this.baritone.getEntityContext().feetPos() : pos;
        this.range = range;
        this.active = true;
        this.locations = null;
    }

    private boolean readyForHarvest(Level world, BlockPos pos, BlockState state) {
        for (Harvest harvest : Harvest.values()) {
            if (harvest.block != state.getBlock()) continue;
            return harvest.readyToHarvest(world, pos, state, this.baritone.settings());
        }
        return false;
    }

    private boolean isPlantable(ItemStack stack) {
        return FARMLAND_PLANTABLE.contains(stack.getItem());
    }

    private boolean isBoneMeal(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem().equals(Items.BONE_MEAL);
    }

    private boolean isNetherWart(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem().equals(Items.NETHER_WART);
    }

    @Override
    public PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        ArrayList<Block> scan = new ArrayList<Block>();
        for (Harvest harvest : Harvest.values()) {
            scan.add(harvest.block);
        }
        if (this.baritone.settings().replantCrops.get().booleanValue()) {
            scan.add(Blocks.FARMLAND);
            if (this.baritone.settings().replantNetherWart.get().booleanValue()) {
                scan.add(Blocks.SOUL_SAND);
            }
        }
        if (this.baritone.settings().mineGoalUpdateInterval.get() != 0 && this.tickCount++ % this.baritone.settings().mineGoalUpdateInterval.get() == 0) {
            PlayerEngine.getExecutor().execute(() -> {
                this.locations = WorldScanner.INSTANCE.scanChunkRadius(this.ctx, scan, 256, 10, 10);
            });
        }
        if (this.locations == null) {
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<BlockPos> toBreak = new ArrayList<BlockPos>();
        ArrayList<BlockPos> openFarmland = new ArrayList<BlockPos>();
        ArrayList<BlockPos> bonemealable = new ArrayList<BlockPos>();
        ArrayList<BlockPos> openSoulsand = new ArrayList<BlockPos>();
        for (BlockPos blockPos : this.locations) {
            BonemealableBlock ig;
            if (this.range != 0 && blockPos.distSqr((Vec3i)this.center) > (double)(this.range * this.range)) continue;
            BlockState state = this.ctx.world().getBlockState(blockPos);
            boolean airAbove = this.ctx.world().getBlockState(blockPos.above()).getBlock() instanceof AirBlock;
            if (state.getBlock() == Blocks.FARMLAND) {
                if (!airAbove) continue;
                openFarmland.add(blockPos);
                continue;
            }
            if (state.getBlock() == Blocks.SOUL_SAND) {
                if (!airAbove) continue;
                openSoulsand.add(blockPos);
                continue;
            }
            if (this.readyForHarvest((Level)this.ctx.world(), blockPos, state)) {
                toBreak.add(blockPos);
                continue;
            }
            if (!(state.getBlock() instanceof BonemealableBlock) || !(ig = (BonemealableBlock)state.getBlock()).isValidBonemealTarget((LevelReader)this.ctx.world(), blockPos, state) || !ig.isBonemealSuccess((Level)this.ctx.world(), this.ctx.world().random, blockPos, state)) continue;
            bonemealable.add(blockPos);
        }
        this.baritone.getInputOverrideHandler().clearAllKeys();
        for (BlockPos blockPos : toBreak) {
            Optional<Rotation> rot = RotationUtils.reachable(this.ctx, blockPos);
            if (!rot.isPresent() || !isSafeToCancel) continue;
            this.baritone.getLookBehavior().updateTarget(rot.get(), true);
            MovementHelper.switchToBestToolFor(this.ctx, this.ctx.world().getBlockState(blockPos));
            if (this.ctx.isLookingAt(blockPos)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_LEFT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<BlockPos> both = new ArrayList<BlockPos>(openFarmland);
        both.addAll(openSoulsand);
        for (BlockPos posxx : both) {
            HitResult result;
            boolean soulsand = openSoulsand.contains(posxx);
            Optional<Rotation> rot = RotationUtils.reachableOffset((Entity)this.ctx.entity(), posxx, new Vec3((double)posxx.getX() + 0.5, (double)(posxx.getY() + 1), (double)posxx.getZ() + 0.5), this.ctx.playerController().getBlockReachDistance(), false);
            if (!rot.isPresent() || !isSafeToCancel || !this.baritone.getInventoryBehavior().throwaway(true, soulsand ? this::isNetherWart : this::isPlantable) || !((result = RayTraceUtils.rayTraceTowards((Entity)this.ctx.entity(), rot.get(), this.ctx.playerController().getBlockReachDistance())) instanceof BlockHitResult) || ((BlockHitResult)result).getDirection() != Direction.UP) continue;
            this.baritone.getLookBehavior().updateTarget(rot.get(), true);
            if (this.ctx.isLookingAt(posxx)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        for (BlockPos posxxx : bonemealable) {
            Optional<Rotation> rot = RotationUtils.reachable(this.ctx, posxxx);
            if (!rot.isPresent() || !isSafeToCancel || !this.baritone.getInventoryBehavior().throwaway(true, this::isBoneMeal)) continue;
            this.baritone.getLookBehavior().updateTarget(rot.get(), true);
            if (this.ctx.isLookingAt(posxxx)) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        if (calcFailed) {
            this.logDirect("Farm failed");
            if (this.baritone.settings().desktopNotifications.get().booleanValue() && this.baritone.settings().notificationOnFarmFail.get().booleanValue()) {
                NotificationHelper.notify("Farm failed", true);
            }
            this.onLostControl();
            return new PathingCommand(null, PathingCommandType.REQUEST_PAUSE);
        }
        ArrayList<IGoalRenderPos> arrayList = new ArrayList<IGoalRenderPos>();
        for (BlockPos posxxxx : toBreak) {
            arrayList.add(new BuilderProcess.GoalBreak(posxxxx));
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isPlantable)) {
            for (BlockPos posxxxx : openFarmland) {
                arrayList.add(new GoalBlock(posxxxx.above()));
            }
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isNetherWart)) {
            for (BlockPos posxxxx : openSoulsand) {
                arrayList.add(new GoalBlock(posxxxx.above()));
            }
        }
        if (this.baritone.getInventoryBehavior().throwaway(false, this::isBoneMeal)) {
            for (BlockPos posxxxx : bonemealable) {
                arrayList.add(new GoalBlock(posxxxx));
            }
        }
        for (ItemEntity item : this.ctx.world().getEntitiesOfClass(ItemEntity.class, this.ctx.entity().getBoundingBox().inflate(30.0), Entity::onGround)) {
            if (!PICKUP_DROPPED.contains(item.getItem().getItem())) continue;
            arrayList.add(new GoalBlock(BlockPos.containing((double)item.getX(), (double)(item.getY() + 0.1), (double)item.getZ())));
        }
        return arrayList.isEmpty() ? new PathingCommand(null, PathingCommandType.REQUEST_PAUSE) : new PathingCommand(new GoalComposite(arrayList.toArray(new Goal[0])), PathingCommandType.SET_GOAL_AND_PATH);
    }

    @Override
    public void onLostControl() {
        this.active = false;
    }

    @Override
    public String displayName0() {
        return "Farming";
    }

    private static enum Harvest {
        WHEAT((CropBlock)Blocks.WHEAT),
        CARROTS((CropBlock)Blocks.CARROTS),
        POTATOES((CropBlock)Blocks.POTATOES),
        BEETROOT((CropBlock)Blocks.BEETROOTS),
        PUMPKIN(Blocks.PUMPKIN, state -> true),
        MELON(Blocks.MELON, state -> true),
        NETHERWART(Blocks.NETHER_WART, state -> (Integer)state.getValue((Property)NetherWartBlock.AGE) >= 3),
        SUGARCANE(Blocks.SUGAR_CANE, null){

            @Override
            public boolean readyToHarvest(Level world, BlockPos pos, BlockState state, Settings settings) {
                return settings.replantCrops.get() != false ? world.getBlockState(pos.below()).getBlock() instanceof SugarCaneBlock : true;
            }
        }
        ,
        CACTUS(Blocks.CACTUS, null){

            @Override
            public boolean readyToHarvest(Level world, BlockPos pos, BlockState state, Settings settings) {
                return settings.replantCrops.get() != false ? world.getBlockState(pos.below()).getBlock() instanceof CactusBlock : true;
            }
        };

        public final Block block;
        public final Predicate<BlockState> readyToHarvest;

        private Harvest(CropBlock blockCrops) {
            this((Block)blockCrops, arg_0 -> ((CropBlock)blockCrops).isMaxAge(arg_0));
        }

        private Harvest(Block block, Predicate<BlockState> readyToHarvest) {
            this.block = block;
            this.readyToHarvest = readyToHarvest;
        }

        public boolean readyToHarvest(Level world, BlockPos pos, BlockState state, Settings settings) {
            return this.readyToHarvest.test(state);
        }
    }
}

