/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils;

import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.utils.IInputOverrideHandler;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.behavior.Behavior;
import com.player2.playerengine.automaton.utils.BlockBreakHelper;
import com.player2.playerengine.automaton.utils.BlockPlaceHelper;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;

public final class InputOverrideHandler
extends Behavior
implements IInputOverrideHandler {
    private final Set<Input> inputForceStateMap = EnumSet.noneOf(Input.class);
    private final BlockBreakHelper blockBreakHelper;
    private final BlockPlaceHelper blockPlaceHelper;
    private boolean needsUpdate;

    public InputOverrideHandler(Baritone baritone) {
        super(baritone);
        this.blockBreakHelper = new BlockBreakHelper(baritone.getEntityContext());
        this.blockPlaceHelper = new BlockPlaceHelper(baritone.getEntityContext());
    }

    @Override
    public final synchronized boolean isInputForcedDown(Input input) {
        return input != null && this.inputForceStateMap.contains((Object)input);
    }

    @Override
    public final synchronized void setInputForceState(Input input, boolean forced) {
        if (forced) {
            this.inputForceStateMap.add(input);
        } else {
            this.inputForceStateMap.remove((Object)input);
        }
        this.needsUpdate = true;
    }

    @Override
    public final synchronized void clearAllKeys() {
        if (this.ctx.entity().isSprinting()) {
            this.ctx.entity().setSprinting(false);
        }
        this.inputForceStateMap.clear();
        this.needsUpdate = true;
    }

    @Override
    public final void onTickServer() {
        if (this.needsUpdate) {
            if (this.isInputForcedDown(Input.CLICK_LEFT)) {
                this.setInputForceState(Input.CLICK_RIGHT, false);
            }
            LivingEntity entity = this.ctx.entity();
            entity.xxa = 0.0f;
            entity.zza = 0.0f;
            entity.setShiftKeyDown(false);
            entity.setJumping(this.isInputForcedDown(Input.JUMP));
            float speed = 0.3f;
            if (this.isInputForcedDown(Input.MOVE_FORWARD)) {
                entity.zza += speed;
            }
            if (this.isInputForcedDown(Input.MOVE_BACK)) {
                entity.zza -= speed;
            }
            if (this.isInputForcedDown(Input.MOVE_LEFT)) {
                entity.xxa += speed;
            }
            if (this.isInputForcedDown(Input.MOVE_RIGHT)) {
                entity.xxa -= speed;
            }
            if (this.isInputForcedDown(Input.SNEAK)) {
                entity.setShiftKeyDown(true);
                entity.xxa = (float)((double)entity.xxa * 0.3);
                entity.zza = (float)((double)entity.zza * 0.3);
            }
            this.blockBreakHelper.tick(this.isInputForcedDown(Input.CLICK_LEFT));
            this.blockPlaceHelper.tick(this.isInputForcedDown(Input.CLICK_RIGHT));
            this.needsUpdate = false;
        }
    }

    public BlockBreakHelper getBlockBreakHelper() {
        return this.blockBreakHelper;
    }
}

