/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.commands;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.commands.base.Arg;
import com.player2.playerengine.commands.base.ArgParser;
import com.player2.playerengine.commands.base.Command;
import com.player2.playerengine.commands.base.CommandException;
import com.player2.playerengine.tasks.movement.FollowPlayerTask;

public class FollowCommand
extends Command {
    public FollowCommand() throws CommandException {
        super("follow", "Follows you or someone else. Example: `follow Player` to follow player with username=Player", new Arg<Object>(String.class, "username", null, 0));
    }

    @Override
    protected void call(PlayerEngineController mod, ArgParser parser) throws CommandException {
        String username = parser.get(String.class);
        if (username == null) {
            if (mod.getOwner() == null) {
                mod.logWarning("No butler user currently present. Running this command with no user argument can ONLY be done via butler.");
                this.finish();
                return;
            }
            username = mod.getOwner().getName().getString();
        }
        mod.runUserTask(new FollowPlayerTask(username), () -> this.finish());
    }
}

