/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.auth;

import com.player2.playerengine.automaton.utils.DirUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;

public class TokenStorage {
    private static final Path PATH = DirUtil.getGameDir().resolve("playerengine_token_storage.dat");
    private static final TokenStorage INSTANCE = new TokenStorage();
    private CompoundTag tokensStored = new CompoundTag();

    private TokenStorage() {
        this.load();
    }

    private String makeKey(String username, String clientId) {
        return username + ":" + clientId;
    }

    public static String getToken(String username, String clientId) {
        return TokenStorage.getInstance().tokensStored.getString(TokenStorage.getInstance().makeKey(username, clientId));
    }

    static void storeToken(String username, String clientId, String token) {
        System.out.println("[TokenStorage]: Storing token for player " + username + " and client " + clientId);
        TokenStorage.getInstance().tokensStored.putString(TokenStorage.getInstance().makeKey(username, clientId), token);
        TokenStorage.getInstance().save();
    }

    private void load() {
        if (Files.exists(PATH, new LinkOption[0])) {
            try {
                this.tokensStored = NbtIo.readCompressed((Path)PATH.toFile().toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void save() {
        System.out.println("[TokenStorage]: save() called");
        try {
            NbtIo.writeCompressed((CompoundTag)this.tokensStored, (Path)PATH.toFile().toPath());
            System.out.println("[TokenStorage]: Writing to file...");
        }
        catch (IOException e) {
            System.err.println("[TokenStorage]: Writing to file FAILED");
            e.printStackTrace();
        }
    }

    private static TokenStorage getInstance() {
        return INSTANCE;
    }
}

