/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction;

import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceStructureBlockTask;
import com.player2.playerengine.util.ItemTarget;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;

public class ClearLiquidTask
extends Task {
    private final BlockPos liquidPos;

    public ClearLiquidTask(BlockPos liquidPos) {
        this.liquidPos = liquidPos;
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        if (this.controller.getItemStorage().hasItem(Items.BUCKET)) {
            this.controller.getBehaviour().setRayTracingFluidHandling(ClipContext.Fluid.SOURCE_ONLY);
            return new InteractWithBlockTask(new ItemTarget(Items.BUCKET, 1), this.liquidPos, false);
        }
        return new PlaceStructureBlockTask(this.liquidPos);
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return this.controller.getChunkTracker().isChunkLoaded(this.liquidPos) ? this.controller.getWorld().getBlockState(this.liquidPos).getFluidState().isEmpty() : false;
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof ClearLiquidTask) {
            ClearLiquidTask task = (ClearLiquidTask)other;
            bl = task.liquidPos.equals((Object)this.liquidPos);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Clear liquid at " + String.valueOf(this.liquidPos);
    }
}

