/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction;

import com.player2.playerengine.BotBehaviour;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.commands.BlockScanner;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.ClearLiquidTask;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PlaceObsidianBucketTask
extends Task {
    public static final Vec3i[] CAST_FRAME = new Vec3i[]{new Vec3i(0, -1, 0), new Vec3i(0, -1, -1), new Vec3i(0, -1, 1), new Vec3i(-1, -1, 0), new Vec3i(1, -1, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1), new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(1, 1, 0)};
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private final BlockPos pos;
    private BlockPos currentCastTarget;
    private BlockPos currentDestroyTarget;

    public PlaceObsidianBucketTask(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    protected void onStart() {
        BotBehaviour botBehaviour = this.controller.getBehaviour();
        botBehaviour.push();
        botBehaviour.avoidBlockBreaking(this::isBlockInCastFrame);
        botBehaviour.avoidBlockPlacing(this::isBlockInCastWaterOrLava);
        this.progressChecker.reset();
        Debug.logInternal("Started onStart method");
        Debug.logInternal("Behaviour pushed");
        Debug.logInternal("Avoiding block breaking");
        Debug.logInternal("Avoiding block placing");
        Debug.logInternal("Progress checker reset");
    }

    private boolean isBlockInCastFrame(BlockPos block) {
        return Arrays.stream(CAST_FRAME).map(arg_0 -> ((BlockPos)this.pos).offset(arg_0)).anyMatch(arg_0 -> ((BlockPos)block).equals(arg_0));
    }

    private boolean isBlockInCastWaterOrLava(BlockPos blockPos) {
        BlockPos waterTarget = this.pos.above();
        Debug.logInternal("blockPos: " + String.valueOf(blockPos));
        Debug.logInternal("waterTarget: " + String.valueOf(waterTarget));
        return blockPos.equals((Object)this.pos) || blockPos.equals((Object)waterTarget);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progressChecker.reset();
        }
        if (mod.getBlockScanner().isBlockAtPosition(this.pos, Blocks.OBSIDIAN) && mod.getBlockScanner().isBlockAtPosition(this.pos.above(), Blocks.WATER)) {
            return new ClearLiquidTask(this.pos.above());
        }
        if (!mod.getItemStorage().hasItem(Items.WATER_BUCKET)) {
            this.progressChecker.reset();
            return TaskCatalogue.getItemTask(Items.WATER_BUCKET, 1);
        }
        if (!mod.getItemStorage().hasItem(Items.LAVA_BUCKET) && !mod.getBlockScanner().isBlockAtPosition(this.pos, Blocks.LAVA)) {
            this.progressChecker.reset();
            return TaskCatalogue.getItemTask(Items.LAVA_BUCKET, 1);
        }
        if (!this.progressChecker.check(mod)) {
            mod.getBaritone().getPathingBehavior().forceCancel();
            mod.getBlockScanner().requestBlockUnreachable(this.pos);
            this.progressChecker.reset();
            return new TimeoutWanderTask(5.0f);
        }
        if (this.currentCastTarget != null) {
            if (!WorldHelper.isSolidBlock(this.controller, this.currentCastTarget)) {
                return new PlaceBlockTask(this.currentCastTarget, (Block[])Arrays.stream(ItemHelper.itemsToBlocks(mod.getModSettings().getThrowawayItems(mod))).filter(b -> !Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.LEAVES)).toList().contains(b)).toArray(Block[]::new));
            }
            this.currentCastTarget = null;
        }
        if (this.currentDestroyTarget != null) {
            if (WorldHelper.isSolidBlock(this.controller, this.currentDestroyTarget)) {
                return new DestroyBlockTask(this.currentDestroyTarget);
            }
            this.currentDestroyTarget = null;
        }
        if (this.currentCastTarget != null && WorldHelper.isSolidBlock(this.controller, this.currentCastTarget)) {
            this.currentCastTarget = null;
        }
        for (Vec3i castPosRelative : CAST_FRAME) {
            BlockPos castPos = this.pos.offset(castPosRelative);
            if (WorldHelper.isSolidBlock(this.controller, castPos)) continue;
            this.currentCastTarget = castPos;
            Debug.logInternal("Building cast frame...");
            return null;
        }
        if (mod.getWorld().getBlockState(this.pos).getBlock() != Blocks.LAVA) {
            BlockPos targetPos = this.pos.offset(-1, 1, 0);
            if (!mod.getPlayer().blockPosition().equals((Object)targetPos) && mod.getItemStorage().hasItem(Items.LAVA_BUCKET)) {
                Debug.logInternal("Positioning player before placing lava...");
                return new GetToBlockTask(targetPos, false);
            }
            if (WorldHelper.isSolidBlock(this.controller, this.pos)) {
                Debug.logInternal("Clearing space around lava...");
                this.currentDestroyTarget = this.pos;
                return null;
            }
            if (WorldHelper.isSolidBlock(this.controller, this.pos.above())) {
                Debug.logInternal("Clearing space around lava...");
                this.currentDestroyTarget = this.pos.above();
                return null;
            }
            if (WorldHelper.isSolidBlock(this.controller, this.pos.above(2))) {
                Debug.logInternal("Clearing space around lava...");
                this.currentDestroyTarget = this.pos.above(2);
                return null;
            }
            Debug.logInternal("Placing lava for cast...");
            return new InteractWithBlockTask(new ItemTarget(Items.LAVA_BUCKET, 1), Direction.WEST, this.pos.offset(1, 0, 0), false);
        }
        BlockPos waterCheck = this.pos.above();
        if (mod.getWorld().getBlockState(waterCheck).getBlock() != Blocks.WATER) {
            Debug.logInternal("Placing water for cast...");
            BlockPos targetPos = this.pos.offset(-1, 1, 0);
            if (!mod.getPlayer().blockPosition().equals((Object)targetPos) && mod.getItemStorage().hasItem(Items.WATER_BUCKET)) {
                Debug.logInternal("Positioning player before placing water...");
                return new GetToBlockTask(targetPos, false);
            }
            if (WorldHelper.isSolidBlock(this.controller, waterCheck)) {
                this.currentDestroyTarget = waterCheck;
                return null;
            }
            if (WorldHelper.isSolidBlock(this.controller, waterCheck.above())) {
                this.currentDestroyTarget = waterCheck.above();
                return null;
            }
            return new InteractWithBlockTask(new ItemTarget(Items.WATER_BUCKET, 1), Direction.WEST, this.pos.offset(1, 1, 0), true);
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        if (this.controller.getBehaviour() != null) {
            this.controller.getBehaviour().pop();
            Debug.logInternal("Behaviour popped.");
        }
    }

    @Override
    public boolean isFinished() {
        BlockScanner blockTracker = this.controller.getBlockScanner();
        BlockPos pos = this.pos;
        boolean isObsidian = blockTracker.isBlockAtPosition(pos, Blocks.OBSIDIAN);
        Debug.logInternal("isObsidian: " + isObsidian);
        boolean isNotWaterAbove = !blockTracker.isBlockAtPosition(pos.above(), Blocks.WATER);
        Debug.logInternal("isNotWaterAbove: " + isNotWaterAbove);
        boolean isFinished = isObsidian && isNotWaterAbove;
        Debug.logInternal("isFinished: " + isFinished);
        return isFinished;
    }

    @Override
    protected boolean isEqual(Task other) {
        if (other instanceof PlaceObsidianBucketTask) {
            PlaceObsidianBucketTask task = (PlaceObsidianBucketTask)other;
            boolean isEqual = task.getPos().equals((Object)this.getPos());
            Debug.logInternal("isEqual: " + isEqual);
            return isEqual;
        }
        Debug.logInternal("isEqual: false");
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Placing obsidian at " + String.valueOf(this.pos) + " with a cast";
    }

    public BlockPos getPos() {
        Debug.logInternal("Entering getPos()");
        return this.pos;
    }
}

