/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;

public class StoreInContainerTask
extends Task {
    public static final Block[] CONTAINER_BLOCKS = (Block[])Stream.concat(Arrays.stream(new Block[]{Blocks.CHEST, Blocks.TRAPPED_CHEST, Blocks.BARREL}), Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.SHULKER_BOXES))).toArray(Block[]::new);
    private final BlockPos containerPos;
    private final boolean getIfNotPresent;
    private final ItemTarget[] toStore;

    public StoreInContainerTask(BlockPos targetContainer, boolean getIfNotPresent, ItemTarget ... toStore) {
        this.containerPos = targetContainer;
        this.getIfNotPresent = getIfNotPresent;
        this.toStore = toStore;
    }

    @Override
    protected void onStart() {
        for (ItemTarget target : this.toStore) {
            this.controller.getBehaviour().addProtectedItems(target.getMatches());
        }
    }

    @Override
    protected Task onTick() {
        if (this.isFinished()) {
            return null;
        }
        if (this.getIfNotPresent) {
            for (ItemTarget target : this.toStore) {
                int needed = target.getTargetCount();
                if (this.controller.getItemStorage().getItemCount(target) >= needed) continue;
                this.setDebugState("Collecting " + String.valueOf(target) + " first.");
                return TaskCatalogue.getItemTask(target);
            }
        }
        if (!this.containerPos.closerThan(new Vec3i((int)this.controller.getEntity().position().x, (int)this.controller.getEntity().position().y, (int)this.controller.getEntity().position().z), 4.5)) {
            this.setDebugState("Going to container");
            return new GetToBlockTask(this.containerPos);
        }
        BlockEntity blockEntity = this.controller.getWorld().getBlockEntity(this.containerPos);
        if (!(blockEntity instanceof RandomizableContainerBlockEntity)) {
            Debug.logWarning("Block at " + String.valueOf(this.containerPos) + " is not a lootable container. Stopping.");
            return null;
        }
        RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntity;
        RandomizableContainerBlockEntity var19 = container;
        LivingEntityInventory var20 = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        this.controller.getItemStorage().containers.WritableCache(this.controller, this.containerPos);
        this.setDebugState("Storing items");
        for (ItemTarget targetx : this.toStore) {
            int currentInContainer = this.countItem((Container)var19, targetx);
            if (currentInContainer >= targetx.getTargetCount()) continue;
            int neededInContainer = targetx.getTargetCount() - currentInContainer;
            for (int i = 0; i < var20.getContainerSize(); ++i) {
                ItemStack remainder;
                int moved;
                ItemStack playerStack = var20.getItem(i);
                if (!targetx.matches(playerStack.getItem())) continue;
                int toMove = Math.min(neededInContainer, playerStack.getCount());
                ItemStack toInsert = playerStack.copy();
                toInsert.setCount(toMove);
                if (this.insertStack((Container)var19, toInsert, true).getCount() == toInsert.getCount() || (moved = toMove - (remainder = this.insertStack((Container)var19, toInsert, false)).getCount()) <= 0) continue;
                playerStack.shrink(moved);
                var20.setItem(i, playerStack);
                container.setChanged();
                this.controller.getItemStorage().registerSlotAction();
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isFinished() {
        boolean bl;
        BlockEntity blockEntity = this.controller.getWorld().getBlockEntity(this.containerPos);
        if (blockEntity instanceof Container) {
            Container containerInv = (Container)blockEntity;
            bl = Arrays.stream(this.toStore).allMatch(target -> this.countItem(containerInv, (ItemTarget)target) >= target.getTargetCount());
        } else {
            bl = Arrays.stream(this.toStore).allMatch(target -> this.controller.getItemStorage().getItemCount((ItemTarget)target) == 0);
        }
        return bl;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof StoreInContainerTask)) {
            bl = false;
        } else {
            StoreInContainerTask task = (StoreInContainerTask)other;
            bl = Objects.equals(task.containerPos, this.containerPos) && task.getIfNotPresent == this.getIfNotPresent && Arrays.equals(task.toStore, this.toStore);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Storing in container[" + this.containerPos.toShortString() + "] " + Arrays.toString(this.toStore);
    }

    private int countItem(Container inventory, ItemTarget target) {
        int count = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!target.matches(stack.getItem())) continue;
            count += stack.getCount();
        }
        return count;
    }

    private ItemStack insertStack(Container inventory, ItemStack stack, boolean simulate) {
        if (simulate) {
            stack = stack.copy();
        }
        for (int i = 0; i < inventory.getContainerSize() && !stack.isEmpty(); ++i) {
            ItemStack slotStack = inventory.getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack)) continue;
            int space = slotStack.getMaxStackSize() - slotStack.getCount();
            int toTransfer = Math.min(stack.getCount(), space);
            if (toTransfer <= 0) continue;
            slotStack.grow(toTransfer);
            stack.shrink(toTransfer);
            if (simulate) continue;
            inventory.setItem(i, slotStack);
        }
        for (int ix = 0; ix < inventory.getContainerSize() && !stack.isEmpty(); ++ix) {
            if (!inventory.getItem(ix).isEmpty()) continue;
            if (!simulate) {
                inventory.setItem(ix, stack.copy());
            }
            stack.setCount(0);
        }
        return stack;
    }
}

