/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.entity;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.AbstractDoToClosestObjectTask;
import com.player2.playerengine.tasks.base.Task;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class DoToClosestEntityTask
extends AbstractDoToClosestObjectTask<Entity> {
    private final Class[] targetEntities;
    private final Supplier<Vec3> getOriginPos;
    private final Function<Entity, Task> getTargetTask;
    private final Predicate<Entity> shouldInteractWith;

    public DoToClosestEntityTask(Supplier<Vec3> getOriginSupplier, Function<Entity, Task> getTargetTask, Predicate<Entity> shouldInteractWith, Class ... entities) {
        this.getOriginPos = getOriginSupplier;
        this.getTargetTask = getTargetTask;
        this.shouldInteractWith = shouldInteractWith;
        this.targetEntities = entities;
    }

    public DoToClosestEntityTask(Supplier<Vec3> getOriginSupplier, Function<Entity, Task> getTargetTask, Class ... entities) {
        this(getOriginSupplier, getTargetTask, (Entity entity) -> true, entities);
    }

    public DoToClosestEntityTask(Function<Entity, Task> getTargetTask, Predicate<Entity> shouldInteractWith, Class ... entities) {
        this((Supplier<Vec3>)null, getTargetTask, shouldInteractWith, entities);
    }

    public DoToClosestEntityTask(Function<Entity, Task> getTargetTask, Class ... entities) {
        this((Supplier<Vec3>)null, getTargetTask, (Entity entity) -> true, entities);
    }

    @Override
    protected Vec3 getPos(PlayerEngineController mod, Entity obj) {
        return obj.position();
    }

    @Override
    protected Optional<Entity> getClosestTo(PlayerEngineController mod, Vec3 pos) {
        return !mod.getEntityTracker().entityFound(this.targetEntities) ? Optional.empty() : mod.getEntityTracker().getClosestEntity(pos, this.shouldInteractWith, this.targetEntities);
    }

    @Override
    protected Vec3 getOriginPos(PlayerEngineController mod) {
        return this.getOriginPos != null ? this.getOriginPos.get() : mod.getPlayer().position();
    }

    @Override
    protected Task getGoalTask(Entity obj) {
        return this.getTargetTask.apply(obj);
    }

    @Override
    protected boolean isValid(PlayerEngineController mod, Entity obj) {
        return obj.isAlive() && mod.getEntityTracker().isEntityReachable(obj) && obj != mod.getEntity();
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof DoToClosestEntityTask) {
            DoToClosestEntityTask task = (DoToClosestEntityTask)other;
            bl = Arrays.equals(task.targetEntities, this.targetEntities);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Doing something to closest entity...";
    }
}

