/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.entity;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.trackers.storage.ItemStorageTracker;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class ShootArrowSimpleProjectileTask
extends Task {
    private final Entity target;
    private boolean shooting = false;
    private boolean shot = false;
    private final TimerGame shotTimer = new TimerGame(1.0);

    public ShootArrowSimpleProjectileTask(Entity target) {
        this.target = target;
    }

    @Override
    protected void onStart() {
        this.shooting = false;
    }

    private static Rotation calculateThrowLook(PlayerEngineController mod, Entity target) {
        float velocity = (float)(mod.getPlayer().getTicksUsingItem() - mod.getPlayer().getUseItemRemainingTicks()) / 20.0f;
        if ((velocity = (velocity * velocity + velocity * 2.0f) / 3.0f) > 1.0f) {
            velocity = 1.0f;
        }
        Vec3 targetCenter = target.getBoundingBox().getCenter();
        double posX = targetCenter.x();
        double posY = targetCenter.y();
        double posZ = targetCenter.z();
        double relativeX = posX - mod.getPlayer().getX();
        double relativeY = (posY -= (double)(1.9f - target.getBbHeight())) - mod.getPlayer().getY();
        double relativeZ = posZ - mod.getPlayer().getZ();
        double hDistance = Math.sqrt(relativeX * relativeX + relativeZ * relativeZ);
        double hDistanceSq = hDistance * hDistance;
        float g = 0.006f;
        float velocitySq = velocity * velocity;
        float pitch = (float)(-Math.toDegrees(Math.atan(((double)velocitySq - Math.sqrt((double)(velocitySq * velocitySq) - (double)0.006f * ((double)0.006f * hDistanceSq + 2.0 * relativeY * (double)velocitySq))) / (double)0.006f * hDistance)));
        return Float.isNaN(pitch) ? new Rotation(target.getYRot(), target.getXRot()) : new Rotation(ShootArrowSimpleProjectileTask.Vec3dToYaw(mod, new Vec3(posX, posY, posZ)), pitch);
    }

    private static float Vec3dToYaw(PlayerEngineController mod, Vec3 vec) {
        return mod.getPlayer().getYRot() + Mth.wrapDegrees((float)((float)Math.toDegrees(Math.atan2(vec.z() - mod.getPlayer().getZ(), vec.x() - mod.getPlayer().getX())) - 90.0f - mod.getPlayer().getYRot()));
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        this.setDebugState("Shooting projectile");
        List<Item> requiredArrows = Arrays.asList(Items.ARROW, Items.SPECTRAL_ARROW, Items.TIPPED_ARROW);
        if (mod.getItemStorage().hasItem(Items.BOW)) {
            if (requiredArrows.stream().anyMatch(arg_0 -> ShootArrowSimpleProjectileTask.lambda$onTick$0(mod.getItemStorage(), arg_0))) {
                Rotation lookTarget = ShootArrowSimpleProjectileTask.calculateThrowLook(mod, this.target);
                LookHelper.lookAt(this.controller, lookTarget);
                boolean charged = mod.getPlayer().getTicksUsingItem() > 20 && mod.getPlayer().getUseItem().getItem() == Items.BOW;
                mod.getSlotHandler().forceEquipItem(Items.BOW);
                if (LookHelper.isLookingAt(mod, lookTarget) && !this.shooting) {
                    mod.getInputControls().hold(Input.CLICK_RIGHT);
                    this.shooting = true;
                    this.shotTimer.reset();
                }
                if (this.shooting && charged) {
                    for (Arrow arrow : mod.getEntityTracker().getTrackedEntities(Arrow.class)) {
                        Vec3 delta;
                        Vec3 velocity;
                        boolean isMovingTowardsTarget;
                        if (arrow.getOwner() != mod.getPlayer() || !(isMovingTowardsTarget = (velocity = arrow.getDeltaMovement()).dot(delta = this.target.position().subtract(arrow.position())) > 0.0)) continue;
                        return null;
                    }
                    mod.getInputControls().release(Input.CLICK_RIGHT);
                    this.shot = true;
                }
                return null;
            }
        }
        Debug.logMessage("Missing items, stopping.");
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getInputControls().release(Input.CLICK_RIGHT);
    }

    @Override
    public boolean isFinished() {
        return this.shot;
    }

    @Override
    protected boolean isEqual(Task other) {
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Shooting arrow at " + this.target.getType().getDescriptionId();
    }

    private static /* synthetic */ boolean lambda$onTick$0(ItemStorageTracker rec$, Item xva$0) {
        return rec$.hasItem(xva$0);
    }
}

