/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.AbstractDoToClosestObjectTask;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToEntityTask;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.SatisfyMiningRequirementTask;
import com.player2.playerengine.tasks.slot.EnsureFreeInventorySlotTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.StlHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.phys.Vec3;

public class PickupDroppedItemTask
extends AbstractDoToClosestObjectTask<ItemEntity>
implements ITaskRequiresGrounded {
    private static final Task getPickaxeFirstTask = new SatisfyMiningRequirementTask(MiningRequirement.STONE);
    private static boolean isGettingPickaxeFirstFlag = false;
    private final TimeoutWanderTask wanderTask = new TimeoutWanderTask(5.0f, true);
    private final MovementProgressChecker stuckCheck = new MovementProgressChecker();
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private final ItemTarget[] itemTargets;
    private final Set<ItemEntity> blacklist = new HashSet<ItemEntity>();
    private final boolean freeInventoryIfFull;
    Block[] annoyingBlocks = new Block[]{Blocks.VINE, Blocks.NETHER_SPROUTS, Blocks.CAVE_VINES, Blocks.CAVE_VINES_PLANT, Blocks.TWISTING_VINES, Blocks.TWISTING_VINES_PLANT, Blocks.WEEPING_VINES_PLANT, Blocks.LADDER, Blocks.BIG_DRIPLEAF, Blocks.BIG_DRIPLEAF_STEM, Blocks.SMALL_DRIPLEAF, Blocks.TALL_GRASS, Blocks.GRASS_BLOCK};
    private Task unstuckTask = null;
    private PlayerEngineController mod;
    private boolean collectingPickaxeForThisResource = false;
    private ItemEntity currentDrop = null;

    public PickupDroppedItemTask(ItemTarget[] itemTargets, boolean freeInventoryIfFull) {
        this.itemTargets = itemTargets;
        this.freeInventoryIfFull = freeInventoryIfFull;
    }

    public PickupDroppedItemTask(ItemTarget target, boolean freeInventoryIfFull) {
        this(new ItemTarget[]{target}, freeInventoryIfFull);
    }

    public PickupDroppedItemTask(Item item, int targetCount, boolean freeInventoryIfFull) {
        this(new ItemTarget(item, targetCount), freeInventoryIfFull);
    }

    public PickupDroppedItemTask(Item item, int targetCount) {
        this(item, targetCount, true);
    }

    private static BlockPos[] generateSides(BlockPos pos) {
        return new BlockPos[]{pos.offset(1, 0, 0), pos.offset(-1, 0, 0), pos.offset(0, 0, 1), pos.offset(0, 0, -1), pos.offset(1, 0, -1), pos.offset(1, 0, 1), pos.offset(-1, 0, -1), pos.offset(-1, 0, 1)};
    }

    public static boolean isIsGettingPickaxeFirst(PlayerEngineController mod) {
        return isGettingPickaxeFirstFlag && mod.getModSettings().shouldCollectPickaxeFirst();
    }

    private boolean isAnnoying(PlayerEngineController mod, BlockPos pos) {
        Block[] var3;
        int var4;
        int var5;
        if (this.annoyingBlocks != null && (var5 = 0) < (var4 = (var3 = this.annoyingBlocks).length)) {
            Block AnnoyingBlocks = var3[var5];
            return mod.getWorld().getBlockState(pos).getBlock() == AnnoyingBlocks || mod.getWorld().getBlockState(pos).getBlock() instanceof DoorBlock || mod.getWorld().getBlockState(pos).getBlock() instanceof FenceBlock || mod.getWorld().getBlockState(pos).getBlock() instanceof FenceGateBlock || mod.getWorld().getBlockState(pos).getBlock() instanceof FlowerBlock;
        }
        return false;
    }

    private BlockPos stuckInBlock(PlayerEngineController mod) {
        BlockPos[] toCheckHigh;
        BlockPos[] toCheck;
        BlockPos p = mod.getPlayer().blockPosition();
        if (this.isAnnoying(mod, p)) {
            return p;
        }
        if (this.isAnnoying(mod, p.above())) {
            return p.above();
        }
        for (BlockPos check : toCheck = PickupDroppedItemTask.generateSides(p)) {
            if (!this.isAnnoying(mod, check)) continue;
            return check;
        }
        for (BlockPos checkx : toCheckHigh = PickupDroppedItemTask.generateSides(p.above())) {
            if (!this.isAnnoying(mod, checkx)) continue;
            return checkx;
        }
        return null;
    }

    private Task getFenceUnstuckTask() {
        return new SafeRandomShimmyTask();
    }

    public boolean isCollectingPickaxeForThis() {
        return this.collectingPickaxeForThisResource;
    }

    @Override
    protected void onStart() {
        this.wanderTask.reset();
        this.progressChecker.reset();
        this.stuckCheck.reset();
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected Task onTick() {
        if (this.wanderTask.isActive() && !this.wanderTask.isFinished()) {
            this.setDebugState("Wandering.");
            return this.wanderTask;
        }
        PlayerEngineController mod = this.controller;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progressChecker.reset();
        }
        if (this.unstuckTask != null && this.unstuckTask.isActive() && !this.unstuckTask.isFinished() && this.stuckInBlock(mod) != null) {
            this.setDebugState("Getting unstuck from block.");
            this.stuckCheck.reset();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getExploreProcess().onLostControl();
            return this.unstuckTask;
        }
        if (!this.progressChecker.check(mod) || !this.stuckCheck.check(mod)) {
            BlockPos blockStuck = this.stuckInBlock(mod);
            if (blockStuck != null) {
                this.unstuckTask = this.getFenceUnstuckTask();
                return this.unstuckTask;
            }
            this.stuckCheck.reset();
        }
        this.mod = mod;
        if (PickupDroppedItemTask.isIsGettingPickaxeFirst(mod) && this.collectingPickaxeForThisResource && !StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.STONE)) {
            this.progressChecker.reset();
            this.setDebugState("Collecting pickaxe first");
            return getPickaxeFirstTask;
        }
        if (StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.STONE)) {
            isGettingPickaxeFirstFlag = false;
        }
        this.collectingPickaxeForThisResource = false;
        if (!this.progressChecker.check(mod)) {
            mod.getBaritone().getPathingBehavior().forceCancel();
            if (this.currentDrop != null && !this.currentDrop.getItem().isEmpty()) {
                if (!isGettingPickaxeFirstFlag && mod.getModSettings().shouldCollectPickaxeFirst() && !StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.STONE)) {
                    Debug.logMessage("Failed to pick up drop, will try to collect a stone pickaxe first and try again!");
                    this.collectingPickaxeForThisResource = true;
                    isGettingPickaxeFirstFlag = true;
                    return getPickaxeFirstTask;
                }
                Debug.logMessage(StlHelper.toString(this.blacklist, element -> element == null ? "(null)" : element.getItem().getItem().getDescriptionId()));
                Debug.logMessage("Failed to pick up drop, suggesting it's unreachable.");
                this.blacklist.add(this.currentDrop);
                mod.getEntityTracker().requestEntityUnreachable((Entity)this.currentDrop);
                return this.wanderTask;
            }
        }
        return super.onTick();
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof PickupDroppedItemTask)) {
            bl = false;
        } else {
            PickupDroppedItemTask task = (PickupDroppedItemTask)other;
            bl = Arrays.equals(task.itemTargets, this.itemTargets) && task.freeInventoryIfFull == this.freeInventoryIfFull;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        StringBuilder result = new StringBuilder();
        result.append("Pickup Dropped Items: [");
        int c = 0;
        for (ItemTarget target : this.itemTargets) {
            result.append(target.toString());
            if (++c == this.itemTargets.length) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    @Override
    protected Vec3 getPos(PlayerEngineController mod, ItemEntity obj) {
        if (!obj.onGround() && !obj.isInWater()) {
            BlockPos p = obj.blockPosition();
            return !WorldHelper.isSolidBlock(this.controller, p.below(3)) ? obj.position().subtract(0.0, 2.0, 0.0) : obj.position().subtract(0.0, 1.0, 0.0);
        }
        return obj.position();
    }

    @Override
    protected Optional<ItemEntity> getClosestTo(PlayerEngineController mod, Vec3 pos) {
        return mod.getEntityTracker().getClosestItemDrop(pos, this.itemTargets);
    }

    @Override
    protected Vec3 getOriginPos(PlayerEngineController mod) {
        return mod.getPlayer().position();
    }

    @Override
    protected Task getGoalTask(ItemEntity itemEntity) {
        boolean touching;
        if (!itemEntity.equals((Object)this.currentDrop)) {
            this.currentDrop = itemEntity;
            this.progressChecker.reset();
            if (isGettingPickaxeFirstFlag && this.collectingPickaxeForThisResource) {
                Debug.logMessage("New goal, no longer collecting a pickaxe.");
                this.collectingPickaxeForThisResource = false;
                isGettingPickaxeFirstFlag = false;
            }
        }
        return (touching = this.mod.getEntityTracker().isCollidingWithPlayer((Entity)itemEntity)) && this.freeInventoryIfFull && this.mod.getItemStorage().getSlotsThatCanFitInPlayerInventory(itemEntity.getItem(), false).isEmpty() ? new EnsureFreeInventorySlotTask() : new GetToEntityTask((Entity)itemEntity);
    }

    @Override
    protected boolean isValid(PlayerEngineController mod, ItemEntity obj) {
        return obj.isAlive() && !this.blacklist.contains(obj);
    }
}

