/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.SearchChunksExploreTask;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.ArrayUtils;

public class SearchChunkForBlockTask
extends SearchChunksExploreTask {
    private final HashSet<Block> toSearchFor = new HashSet();

    public SearchChunkForBlockTask(Block ... blocks) {
        this.toSearchFor.addAll(Arrays.asList(blocks));
    }

    @Override
    protected boolean isChunkWithinSearchSpace(PlayerEngineController mod, ChunkPos pos) {
        return mod.getChunkTracker().scanChunk(pos, block -> this.toSearchFor.contains(mod.getWorld().getBlockState(block).getBlock()));
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof SearchChunkForBlockTask) {
            SearchChunkForBlockTask blockTask = (SearchChunkForBlockTask)other;
            bl = Arrays.equals(blockTask.toSearchFor.toArray(Block[]::new), this.toSearchFor.toArray(Block[]::new));
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Searching chunk for blocks " + ArrayUtils.toString(this.toSearchFor.toArray(Block[]::new));
    }
}

