/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PutOutFireTask;
import com.player2.playerengine.tasks.entity.KillEntitiesTask;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.RunAwayFromHostilesTask;
import com.player2.playerengine.tasks.movement.SearchChunkForBlockTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CollectBlazeRodsTask
extends ResourceTask {
    private static final double SPAWNER_BLAZE_RADIUS = 32.0;
    private static final double TOO_LITTLE_HEALTH_BLAZE = 10.0;
    private static final int TOO_MANY_BLAZES = 5;
    private final int count;
    private final Task searcher = new SearchChunkForBlockTask(Blocks.NETHER_BRICKS);
    private BlockPos foundBlazeSpawner = null;

    public CollectBlazeRodsTask(int count) {
        super(Items.BLAZE_ROD, count);
        this.count = count;
    }

    private static boolean isHoveringAboveLavaOrTooHigh(PlayerEngineController mod, Entity entity) {
        int MAX_HEIGHT = 11;
        BlockPos check = entity.blockPosition();
        while (entity.blockPosition().getY() - check.getY() < MAX_HEIGHT) {
            if (mod.getWorld().getBlockState(check).getBlock() == Blocks.LAVA) {
                return true;
            }
            if (WorldHelper.isSolidBlock(mod, check)) {
                return false;
            }
            check = check.below();
        }
        return true;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (WorldHelper.getCurrentDimension(this.controller) != Dimension.NETHER) {
            this.setDebugState("Going to nether");
            return new DefaultGoToDimensionTask(Dimension.NETHER);
        }
        Optional<Object> toKill = Optional.empty();
        if (mod.getEntityTracker().entityFound(Blaze.class)) {
            BlockHitResult hit;
            Entity kill;
            Vec3 nearest;
            double sqDistanceToPlayer;
            toKill = mod.getEntityTracker().getClosestEntity(Blaze.class);
            if (toKill.isPresent() && (double)mod.getPlayer().getHealth() <= 10.0 && mod.getEntityTracker().getTrackedEntities(Blaze.class).size() >= 5) {
                this.setDebugState("Running away as there are too many blazes nearby.");
                return new RunAwayFromHostilesTask(30.0, true);
            }
            if (this.foundBlazeSpawner != null && toKill.isPresent() && (sqDistanceToPlayer = (nearest = (kill = (Entity)toKill.get()).position()).distanceToSqr(mod.getPlayer().position())) > 1024.0 && (hit = mod.getWorld().clip(new ClipContext(mod.getPlayer().getEyePosition(1.0f), kill.getEyePosition(1.0f), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)mod.getPlayer()))) != null && BlockPosVer.getSquaredDistance(hit.getBlockPos(), (Position)mod.getPlayer().position()) < sqDistanceToPlayer) {
                toKill = Optional.empty();
            }
        }
        if (toKill.isPresent() && ((Entity)toKill.get()).isAlive() && !CollectBlazeRodsTask.isHoveringAboveLavaOrTooHigh(mod, (Entity)toKill.get())) {
            this.setDebugState("Killing blaze");
            Predicate<Entity> safeToPursue = entity -> !CollectBlazeRodsTask.isHoveringAboveLavaOrTooHigh(mod, entity);
            return new KillEntitiesTask(safeToPursue, ((Entity)toKill.get()).getClass());
        }
        if (this.foundBlazeSpawner != null && mod.getChunkTracker().isChunkLoaded(this.foundBlazeSpawner) && !this.isValidBlazeSpawner(mod, this.foundBlazeSpawner)) {
            Debug.logMessage("Blaze spawner at " + String.valueOf(this.foundBlazeSpawner) + " too far away or invalid. Re-searching.");
            this.foundBlazeSpawner = null;
        }
        if (this.foundBlazeSpawner != null) {
            if (!this.foundBlazeSpawner.closerToCenterThan((Position)mod.getPlayer().position(), 4.0)) {
                this.setDebugState("Going to blaze spawner");
                return new GetToBlockTask(this.foundBlazeSpawner.above(), false);
            }
            Optional<BlockPos> nearestFire = mod.getBlockScanner().getNearestWithinRange(this.foundBlazeSpawner, 5.0, Blocks.FIRE);
            if (nearestFire.isPresent()) {
                this.setDebugState("Clearing fire around spawner to prevent loss of blaze rods.");
                return new PutOutFireTask(nearestFire.get());
            }
            this.setDebugState("Waiting near blaze spawner for blazes to spawn");
            return null;
        }
        Optional<BlockPos> pos = mod.getBlockScanner().getNearestBlock(blockPos -> this.isValidBlazeSpawner(mod, (BlockPos)blockPos), Blocks.SPAWNER);
        pos.ifPresent(blockPos -> {
            this.foundBlazeSpawner = blockPos;
        });
        this.setDebugState("Searching for fortress/Traveling around fortress");
        return this.searcher;
    }

    private boolean isValidBlazeSpawner(PlayerEngineController mod, BlockPos pos) {
        return !mod.getChunkTracker().isChunkLoaded(pos) ? false : WorldHelper.getSpawnerEntity(mod, pos) instanceof Blaze;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectBlazeRodsTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect blaze rods - " + this.controller.getItemStorage().getItemCount(Items.BLAZE_ROD) + "/" + this.count;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }
}

