/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.StlHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class CollectCropTask
extends ResourceTask {
    private final ItemTarget cropToCollect;
    private final Item[] cropSeed;
    private final Predicate<BlockPos> canBreak;
    private final Block[] cropBlock;
    private final Set<BlockPos> emptyCropland = new HashSet<BlockPos>();
    private final Task collectSeedTask;
    private final HashSet<BlockPos> wasFullyGrown = new HashSet();

    public CollectCropTask(ItemTarget cropToCollect, Block[] cropBlock, Item[] cropSeed, Predicate<BlockPos> canBreak) {
        super(cropToCollect);
        this.cropToCollect = cropToCollect;
        this.cropSeed = cropSeed;
        this.canBreak = canBreak;
        this.cropBlock = cropBlock;
        this.collectSeedTask = new PickupDroppedItemTask(new ItemTarget(cropSeed, 1), true);
    }

    public CollectCropTask(ItemTarget cropToCollect, Block[] cropBlock, Item ... cropSeed) {
        this(cropToCollect, cropBlock, cropSeed, (BlockPos canBreak) -> true);
    }

    public CollectCropTask(ItemTarget cropToCollect, Block cropBlock, Item ... cropSeed) {
        this(cropToCollect, new Block[]{cropBlock}, cropSeed);
    }

    public CollectCropTask(Item cropItem, int count, Block cropBlock, Item ... cropSeed) {
        this(new ItemTarget(cropItem, count), cropBlock, cropSeed);
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (this.hasEmptyCrops(mod) && mod.getModSettings().shouldReplantCrops() && !mod.getItemStorage().hasItem(this.cropSeed)) {
            Optional<ItemEntity> closest;
            if (this.collectSeedTask.isActive() && !this.collectSeedTask.isFinished()) {
                this.setDebugState("Picking up dropped seeds");
                return this.collectSeedTask;
            }
            if (mod.getEntityTracker().itemDropped(this.cropSeed) && (closest = mod.getEntityTracker().getClosestItemDrop(mod.getPlayer().position(), this.cropSeed)).isPresent() && closest.get().closerThan((Entity)mod.getPlayer(), 7.0)) {
                return this.collectSeedTask;
            }
        }
        if (this.shouldReplantNow(mod)) {
            this.setDebugState("Replanting...");
            this.emptyCropland.removeIf(blockPos -> !this.isEmptyCrop(mod, (BlockPos)blockPos));
            assert (!this.emptyCropland.isEmpty());
            return new DoToClosestBlockTask(blockPos -> new InteractWithBlockTask(new ItemTarget(this.cropSeed, 1), Direction.UP, blockPos.below(), true), pos -> this.emptyCropland.stream().min(StlHelper.compareValues(block -> BlockPosVer.getSquaredDistance(block, (Position)pos))), this.emptyCropland::contains, Blocks.FARMLAND);
        }
        Predicate<BlockPos> validCrop = blockPos -> !this.canBreak.test((BlockPos)blockPos) ? false : (mod.getModSettings().shouldReplantCrops() && !this.isMature(mod, (BlockPos)blockPos) ? false : (mod.getWorld().getBlockState(blockPos).getBlock() == Blocks.WHEAT ? this.isMature(mod, (BlockPos)blockPos) : true));
        if (this.isInWrongDimension(mod) && !mod.getBlockScanner().anyFound(validCrop, this.cropBlock)) {
            return this.getToCorrectDimensionTask(mod);
        }
        this.setDebugState("Breaking crops.");
        return new DoToClosestBlockTask(blockPos -> {
            this.emptyCropland.add((BlockPos)blockPos);
            return new DestroyBlockTask((BlockPos)blockPos);
        }, validCrop, this.cropBlock);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return this.shouldReplantNow(this.controller) ? false : super.isFinished();
    }

    private boolean shouldReplantNow(PlayerEngineController mod) {
        return mod.getModSettings().shouldReplantCrops() && this.hasEmptyCrops(mod) && mod.getItemStorage().hasItem(this.cropSeed);
    }

    private boolean hasEmptyCrops(PlayerEngineController mod) {
        for (BlockPos pos : this.emptyCropland) {
            if (!this.isEmptyCrop(mod, pos)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmptyCrop(PlayerEngineController mod, BlockPos pos) {
        return WorldHelper.isAir(mod.getWorld().getBlockState(pos).getBlock());
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (!(other instanceof CollectCropTask)) {
            bl = false;
        } else {
            CollectCropTask task = (CollectCropTask)other;
            bl = Arrays.equals(task.cropSeed, this.cropSeed) && Arrays.equals(task.cropBlock, this.cropBlock) && task.cropToCollect.equals(this.cropToCollect);
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting crops: " + String.valueOf(this.cropToCollect);
    }

    private boolean isMature(PlayerEngineController mod, BlockPos blockPos) {
        if (mod.getChunkTracker().isChunkLoaded(blockPos) && WorldHelper.canReach(this.controller, blockPos)) {
            BlockState s = mod.getWorld().getBlockState(blockPos);
            Block block = s.getBlock();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                boolean mature = crop.isMaxAge(s);
                if (this.wasFullyGrown.contains(blockPos)) {
                    if (!mature) {
                        this.wasFullyGrown.remove(blockPos);
                    }
                } else if (mature) {
                    this.wasFullyGrown.add(blockPos);
                }
                return mature;
            }
            return false;
        }
        return this.wasFullyGrown.contains(blockPos);
    }
}

