/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.ToolMaterialVer;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.AbstractDoToClosestObjectTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.resources.SatisfyMiningRequirementTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.slots.CursorSlot;
import com.player2.playerengine.util.slots.PlayerSlot;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class MineAndCollectTask
extends ResourceTask {
    private final Block[] blocksToMine;
    private final MiningRequirement requirement;
    private final TimerGame cursorStackTimer = new TimerGame(3.0);
    private final MineOrCollectTask subtask;

    public MineAndCollectTask(ItemTarget[] itemTargets, Block[] blocksToMine, MiningRequirement requirement) {
        super(itemTargets);
        this.requirement = requirement;
        this.blocksToMine = blocksToMine;
        this.subtask = new MineOrCollectTask(this.blocksToMine, itemTargets);
    }

    public MineAndCollectTask(ItemTarget[] blocksToMine, MiningRequirement requirement) {
        this(blocksToMine, MineAndCollectTask.itemTargetToBlockList(blocksToMine), requirement);
    }

    public MineAndCollectTask(ItemTarget target, Block[] blocksToMine, MiningRequirement requirement) {
        this(new ItemTarget[]{target}, blocksToMine, requirement);
    }

    public MineAndCollectTask(Item item, int count, Block[] blocksToMine, MiningRequirement requirement) {
        this(new ItemTarget(item, count), blocksToMine, requirement);
    }

    public static Block[] itemTargetToBlockList(ItemTarget[] targets) {
        ArrayList<Block> result = new ArrayList<Block>(targets.length);
        for (ItemTarget target : targets) {
            for (Item item : target.getMatches()) {
                Block block = Block.byItem((Item)item);
                if (block == null || WorldHelper.isAir(block)) continue;
                result.add(block);
            }
        }
        return (Block[])result.toArray(Block[]::new);
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
        mod.getBehaviour().addProtectedItems(Items.WOODEN_PICKAXE, Items.STONE_PICKAXE, Items.IRON_PICKAXE, Items.DIAMOND_PICKAXE, Items.NETHERITE_PICKAXE);
        this.subtask.resetSearch();
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return true;
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (!StorageHelper.miningRequirementMet(mod, this.requirement)) {
            return new SatisfyMiningRequirementTask(this.requirement);
        }
        if (this.subtask.isMining()) {
            this.makeSureToolIsEquipped(mod);
        }
        return this.subtask.wasWandering() && this.isInWrongDimension(mod) && !mod.getBlockScanner().anyFound(this.blocksToMine) ? this.getToCorrectDimensionTask(mod) : this.subtask;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof MineAndCollectTask) {
            MineAndCollectTask task = (MineAndCollectTask)other;
            bl = Arrays.equals(task.blocksToMine, this.blocksToMine);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Mine And Collect";
    }

    private void makeSureToolIsEquipped(PlayerEngineController mod) {
        if (this.cursorStackTimer.elapsed() && !mod.getFoodChain().needsToEat()) {
            Item item;
            assert (this.controller.getPlayer() != null);
            ItemStack cursorStack = StorageHelper.getItemStackInCursorSlot(this.controller);
            if (cursorStack != null && !cursorStack.isEmpty() && (item = cursorStack.getItem()).isCorrectToolForDrops(cursorStack, mod.getWorld().getBlockState(this.subtask.miningPos()))) {
                Item currentlyEquipped = StorageHelper.getItemStackInSlot(PlayerSlot.getEquipSlot(mod.getInventory())).getItem();
                if (item instanceof DiggerItem) {
                    if (currentlyEquipped instanceof DiggerItem) {
                        DiggerItem currentPick = (DiggerItem)currentlyEquipped;
                        DiggerItem swapPick = (DiggerItem)item;
                        if (ToolMaterialVer.getMiningLevel((TieredItem)swapPick) > ToolMaterialVer.getMiningLevel((TieredItem)currentPick)) {
                            mod.getSlotHandler().forceEquipSlot(this.controller, CursorSlot.SLOT);
                        }
                    } else {
                        mod.getSlotHandler().forceEquipSlot(this.controller, CursorSlot.SLOT);
                    }
                }
            }
            this.cursorStackTimer.reset();
        }
    }

    public static class MineOrCollectTask
    extends AbstractDoToClosestObjectTask<Object> {
        private final Block[] blocks;
        private final ItemTarget[] targets;
        private final Set<BlockPos> blacklist = new HashSet<BlockPos>();
        private final MovementProgressChecker progressChecker = new MovementProgressChecker();
        private final Task pickupTask;
        private BlockPos miningPos;

        public MineOrCollectTask(Block[] blocks, ItemTarget[] targets) {
            this.blocks = blocks;
            this.targets = targets;
            this.pickupTask = new PickupDroppedItemTask(targets, true);
        }

        @Override
        protected Vec3 getPos(PlayerEngineController mod, Object obj) {
            if (obj instanceof BlockPos) {
                BlockPos b = (BlockPos)obj;
                return WorldHelper.toVec3d(b);
            }
            if (obj instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)obj;
                return item.position();
            }
            throw new UnsupportedOperationException("Shouldn't try to get the position of object " + String.valueOf(obj) + " of type " + (obj != null ? obj.getClass().toString() : "(null object)"));
        }

        @Override
        protected Optional<Object> getClosestTo(PlayerEngineController mod, Vec3 pos) {
            Tuple<Double, Optional<BlockPos>> closestBlock = MineOrCollectTask.getClosestBlock(mod, pos, this.blocks);
            Tuple<Double, Optional<ItemEntity>> closestDrop = MineOrCollectTask.getClosestItemDrop(mod, pos, this.targets);
            double blockSq = (Double)closestBlock.getA();
            double dropSq = (Double)closestDrop.getA();
            if (mod.getExtraBaritoneSettings().isInteractionPaused()) {
                return ((Optional)closestDrop.getB()).map(Object.class::cast);
            }
            return dropSq <= blockSq ? ((Optional)closestDrop.getB()).map(Object.class::cast) : ((Optional)closestBlock.getB()).map(Object.class::cast);
        }

        public static Tuple<Double, Optional<ItemEntity>> getClosestItemDrop(PlayerEngineController mod, Vec3 pos, ItemTarget ... items) {
            Optional<ItemEntity> closestDrop = Optional.empty();
            if (mod.getEntityTracker().itemDropped(items)) {
                closestDrop = mod.getEntityTracker().getClosestItemDrop(pos, items);
            }
            return new Tuple((Object)closestDrop.map(itemEntity -> itemEntity.distanceToSqr(pos) + 10.0).orElse(Double.POSITIVE_INFINITY), closestDrop);
        }

        public static Tuple<Double, Optional<BlockPos>> getClosestBlock(PlayerEngineController mod, Vec3 pos, Block ... blocks) {
            Optional<BlockPos> closestBlock = mod.getBlockScanner().getNearestBlock(pos, check -> mod.getBlockScanner().isUnreachable((BlockPos)check) ? false : WorldHelper.canBreak(mod, check), blocks);
            return new Tuple((Object)closestBlock.map(blockPos -> BlockPosVer.getSquaredDistance(blockPos, (Position)pos)).orElse(Double.POSITIVE_INFINITY), closestBlock);
        }

        @Override
        protected Vec3 getOriginPos(PlayerEngineController mod) {
            return mod.getPlayer().position();
        }

        @Override
        protected Task onTick() {
            PlayerEngineController mod = this.controller;
            if (mod.getBaritone().getPathingBehavior().isPathing()) {
                this.progressChecker.reset();
            }
            if (this.miningPos != null && !this.progressChecker.check(mod)) {
                mod.getBaritone().getPathingBehavior().forceCancel();
                Debug.logMessage("Failed to mine block. Suggesting it may be unreachable.");
                mod.getBlockScanner().requestBlockUnreachable(this.miningPos, 2);
                this.blacklist.add(this.miningPos);
                this.miningPos = null;
                this.progressChecker.reset();
            }
            return super.onTick();
        }

        @Override
        protected Task getGoalTask(Object obj) {
            if (!(obj instanceof BlockPos)) {
                if (obj instanceof ItemEntity) {
                    this.miningPos = null;
                    return this.pickupTask;
                }
                throw new UnsupportedOperationException("Shouldn't try to get the goal from object " + String.valueOf(obj) + " of type " + (obj != null ? obj.getClass().toString() : "(null object)"));
            }
            BlockPos newPos = (BlockPos)obj;
            if (this.miningPos == null || !this.miningPos.equals((Object)newPos)) {
                this.progressChecker.reset();
            }
            this.miningPos = newPos;
            return new DestroyBlockTask(this.miningPos);
        }

        @Override
        protected boolean isValid(PlayerEngineController mod, Object obj) {
            if (obj instanceof BlockPos) {
                BlockPos b = (BlockPos)obj;
                return mod.getBlockScanner().isBlockAtPosition(b, this.blocks) && WorldHelper.canBreak(this.controller, b);
            }
            if (!(obj instanceof ItemEntity)) {
                return false;
            }
            ItemEntity drop = (ItemEntity)obj;
            Item item = drop.getItem().getItem();
            if (this.targets != null) {
                for (ItemTarget target : this.targets) {
                    if (!target.matches(item)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected void onStart() {
            this.progressChecker.reset();
            this.miningPos = null;
        }

        @Override
        protected void onStop(Task interruptTask) {
        }

        @Override
        protected boolean isEqual(Task other) {
            boolean bl;
            if (!(other instanceof MineOrCollectTask)) {
                bl = false;
            } else {
                MineOrCollectTask task = (MineOrCollectTask)other;
                bl = Arrays.equals(task.blocks, this.blocks) && Arrays.equals(task.targets, this.targets);
            }
            return bl;
        }

        @Override
        protected String toDebugString() {
            return "Mining or Collecting";
        }

        public boolean isMining() {
            return this.miningPos != null;
        }

        public BlockPos miningPos() {
            return this.miningPos;
        }
    }
}

