/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers.storage;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.trackers.Tracker;
import com.player2.playerengine.trackers.TrackerManager;
import com.player2.playerengine.trackers.storage.ContainerCache;
import com.player2.playerengine.trackers.storage.ContainerType;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ContainerSubTracker
extends Tracker {
    private final HashMap<Dimension, HashMap<BlockPos, ContainerCache>> containerCaches = new HashMap();
    private BlockPos lastInteractedContainer;

    public ContainerSubTracker(TrackerManager manager) {
        super(manager);
        for (Dimension dimension : Dimension.values()) {
            this.containerCaches.put(dimension, new HashMap());
        }
    }

    public Optional<ContainerCache> WritableCache(PlayerEngineController controller, BlockPos pos) {
        BlockEntity blockEntity = controller.getWorld().getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container containerInventory = (Container)blockEntity;
            this.lastInteractedContainer = pos;
            Block block = controller.getWorld().getBlockState(pos).getBlock();
            ContainerType type = ContainerType.getFromBlock(block);
            if (type == ContainerType.EMPTY) {
                return Optional.empty();
            }
            ContainerCache cache = this.containerCaches.get((Object)WorldHelper.getCurrentDimension(controller)).computeIfAbsent(pos, p -> new ContainerCache(WorldHelper.getCurrentDimension(controller), (BlockPos)p, type));
            cache.update(containerInventory, s -> {});
            return Optional.of(cache);
        }
        this.containerCaches.get((Object)WorldHelper.getCurrentDimension(controller)).remove(pos);
        return Optional.empty();
    }

    public Optional<ContainerCache> getContainerAtPosition(BlockPos pos) {
        return Optional.ofNullable(this.containerCaches.get((Object)WorldHelper.getCurrentDimension(this.mod)).get(pos));
    }

    public List<ContainerCache> getCachedContainers(Predicate<ContainerCache> accept) {
        ArrayList<ContainerCache> result = new ArrayList<ContainerCache>();
        this.containerCaches.get((Object)WorldHelper.getCurrentDimension(this.mod)).values().forEach(cache -> {
            if (accept.test((ContainerCache)cache)) {
                result.add((ContainerCache)cache);
            }
        });
        return result;
    }

    public List<ContainerCache> getContainersWithItem(Item ... items) {
        return this.getCachedContainers(cache -> cache.hasItem(items));
    }

    public Optional<BlockPos> getLastInteractedContainer() {
        return Optional.ofNullable(this.lastInteractedContainer);
    }

    @Override
    protected void updateState() {
    }

    @Override
    protected void reset() {
        this.containerCaches.values().forEach(HashMap::clear);
        this.lastInteractedContainer = null;
    }
}

