/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers.storage;

import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.trackers.Tracker;
import com.player2.playerengine.trackers.TrackerManager;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.slots.Slot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class InventorySubTracker
extends Tracker {
    private final Map<Item, List<Integer>> itemToSlotPlayer = new HashMap<Item, List<Integer>>();
    private final Map<Item, Integer> itemCountsPlayer = new HashMap<Item, Integer>();

    public InventorySubTracker(TrackerManager manager) {
        super(manager);
    }

    public int getItemCount(Item ... items) {
        this.ensureUpdated();
        int result = 0;
        ItemStack cursorStack = this.mod.getSlotHandler().getCursorStack();
        for (Item item : items) {
            if (cursorStack.is(item)) {
                result += cursorStack.getCount();
            }
            result += this.itemCountsPlayer.getOrDefault(item, 0).intValue();
        }
        return result;
    }

    public boolean hasItem(Item ... items) {
        this.ensureUpdated();
        ItemStack cursorStack = this.mod.getSlotHandler().getCursorStack();
        for (Item item : items) {
            if (cursorStack.is(item)) {
                return true;
            }
            if (!this.itemCountsPlayer.containsKey(item)) continue;
            return true;
        }
        return false;
    }

    public List<Slot> getSlotsWithItemsPlayerInventory(boolean includeArmor, Item ... items) {
        this.ensureUpdated();
        ArrayList<Slot> result = new ArrayList<Slot>();
        LivingEntityInventory inventory = ((IInventoryProvider)this.mod.getEntity()).getLivingInventory();
        for (Item item : items) {
            if (!this.itemToSlotPlayer.containsKey(item)) continue;
            for (Integer index : this.itemToSlotPlayer.get(item)) {
                result.add(new Slot(inventory.main, index));
            }
        }
        if (includeArmor) {
            for (int i = 0; i < inventory.armor.size(); ++i) {
                ItemStack stack = (ItemStack)inventory.armor.get(i);
                if (!Arrays.stream(items).anyMatch(arg_0 -> ((ItemStack)stack).is(arg_0))) continue;
                result.add(new Slot(inventory.armor, i));
            }
        }
        ItemStack offhandStack = (ItemStack)inventory.offHand.get(0);
        if (Arrays.stream(items).anyMatch(arg_0 -> ((ItemStack)offhandStack).is(arg_0))) {
            result.add(new Slot(inventory.offHand, 0));
        }
        return result;
    }

    public List<ItemStack> getInventoryStacks() {
        this.ensureUpdated();
        LivingEntityInventory inventory = ((IInventoryProvider)this.mod.getEntity()).getLivingInventory();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.addAll((Collection<ItemStack>)inventory.main);
        stacks.addAll((Collection<ItemStack>)inventory.armor);
        stacks.addAll((Collection<ItemStack>)inventory.offHand);
        return stacks;
    }

    public List<Slot> getSlotsThatCanFit(ItemStack item, boolean acceptPartial) {
        this.ensureUpdated();
        ArrayList<Slot> result = new ArrayList<Slot>();
        LivingEntityInventory inventory = ((IInventoryProvider)this.mod.getEntity()).getLivingInventory();
        if (item.isStackable()) {
            for (int i = 0; i < inventory.main.size(); ++i) {
                ItemStack stackInSlot = (ItemStack)inventory.main.get(i);
                if (!ItemHelper.canStackTogether(item, stackInSlot)) continue;
                int roomLeft = stackInSlot.getMaxStackSize() - stackInSlot.getCount();
                if (!acceptPartial && roomLeft < item.getCount()) continue;
                result.add(new Slot(inventory.main, i));
            }
        }
        for (int ix = 0; ix < inventory.main.size(); ++ix) {
            if (!((ItemStack)inventory.main.get(ix)).isEmpty()) continue;
            result.add(new Slot(inventory.main, ix));
        }
        return result;
    }

    public boolean hasEmptySlot() {
        this.ensureUpdated();
        return this.itemCountsPlayer.getOrDefault(Items.AIR, 0) > 0;
    }

    @Override
    protected void updateState() {
        this.reset();
        LivingEntityInventory inventory = ((IInventoryProvider)this.mod.getEntity()).getLivingInventory();
        if (inventory != null) {
            ItemStack stack;
            int i;
            for (i = 0; i < inventory.main.size(); ++i) {
                stack = (ItemStack)inventory.main.get(i);
                this.registerItem(stack, i, inventory.main);
            }
            for (i = 0; i < inventory.armor.size(); ++i) {
                stack = (ItemStack)inventory.armor.get(i);
                this.registerItem(stack, i, inventory.armor);
            }
            for (i = 0; i < inventory.offHand.size(); ++i) {
                stack = (ItemStack)inventory.offHand.get(i);
                this.registerItem(stack, i, inventory.offHand);
            }
        }
    }

    private void registerItem(ItemStack stack, int index, NonNullList<ItemStack> inventory) {
        Item item = stack.isEmpty() ? Items.AIR : stack.getItem();
        int count = stack.getCount();
        this.itemCountsPlayer.put(item, this.itemCountsPlayer.getOrDefault(item, 0) + count);
        if (inventory instanceof NonNullList) {
            this.itemToSlotPlayer.computeIfAbsent(item, k -> new ArrayList()).add(index);
        }
    }

    @Override
    protected void reset() {
        this.itemToSlotPlayer.clear();
        this.itemCountsPlayer.clear();
    }
}

