/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.DamageSourceWrapper;
import com.player2.playerengine.multiversion.MethodWrapper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EntityHelper {
    public static final double ENTITY_GRAVITY = 0.08;

    public static boolean isAngryAtPlayer(PlayerEngineController mod, Entity mob) {
        boolean bl;
        boolean hostile = EntityHelper.isProbablyHostileToPlayer(mod, mob);
        if (!(mob instanceof Mob)) {
            bl = hostile;
        } else {
            Mob entity = (Mob)mob;
            bl = hostile && entity.getTarget() == mod.getPlayer();
        }
        return bl;
    }

    public static boolean isProbablyHostileToPlayer(PlayerEngineController mod, Entity entity) {
        if (entity instanceof Mob) {
            boolean bl;
            Mob mob = (Mob)entity;
            if (mob instanceof Slime) {
                Slime slime = (Slime)mob;
                return slime.getAttributeValue(Attributes.ATTACK_DAMAGE) > 0.0;
            }
            if (mob instanceof Piglin) {
                Piglin piglin = (Piglin)mob;
                return piglin.isAggressive() && !EntityHelper.isTradingPiglin((Entity)mob) && piglin.isAdult();
            }
            if (mob instanceof EnderMan) {
                EnderMan enderman = (EnderMan)mob;
                return enderman.isCreepy();
            }
            if (mob instanceof ZombifiedPiglin) {
                ZombifiedPiglin zombifiedPiglin = (ZombifiedPiglin)mob;
                bl = zombifiedPiglin.isAggressive();
            } else {
                bl = mob.isAggressive() || mob instanceof Monster;
            }
            return bl;
        }
        return false;
    }

    public static boolean isTradingPiglin(Entity entity) {
        Piglin pig;
        if (entity instanceof Piglin && (pig = (Piglin)entity).getHandSlots() != null) {
            for (ItemStack stack : pig.getHandSlots()) {
                if (!stack.getItem().equals(Items.GOLD_INGOT)) continue;
                return true;
            }
        }
        return false;
    }

    public static double calculateResultingPlayerDamage(LivingEntity player, DamageSource src, double damageAmount) {
        DamageSourceWrapper source = DamageSourceWrapper.of(src);
        if (player.isInvulnerableTo(src)) {
            return 0.0;
        }
        if (!source.bypassesArmor()) {
            damageAmount = MethodWrapper.getDamageLeft(player, damageAmount, src, (double)player.getArmorValue(), player.getAttributeValue(Attributes.ARMOR_TOUGHNESS));
        }
        if (!source.bypassesShield()) {
            float k;
            if (player.hasEffect(MobEffects.DAMAGE_RESISTANCE) && source.isOutOfWorld()) {
                k = (player.getEffect(MobEffects.DAMAGE_RESISTANCE).getAmplifier() + 1) * 5;
                float j = 25.0f - k;
                double f = damageAmount * (double)j;
                damageAmount = Math.max(f / 25.0, 0.0);
            }
            if (damageAmount <= 0.0) {
                damageAmount = 0.0;
            } else {
                k = EnchantmentHelper.getDamageProtection((ServerLevel)((ServerLevel)player.level()), (LivingEntity)player, (DamageSource)src);
                if (k > 0.0f) {
                    damageAmount = CombatRules.getDamageAfterMagicAbsorb((float)((float)damageAmount), (float)k);
                }
            }
        }
        return Math.max(damageAmount - (double)player.getAbsorptionAmount(), 0.0);
    }
}

