/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.KeepName;
import com.player2.playerengine.automaton.client.CustomFishingBobberRenderer;
import com.player2.playerengine.player2api.utils.AudioUtils;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.resources.ResourceLocation;

@KeepName
public final class PlayerEngineClient {
    public static boolean enabledTTS = true;

    public static void onInitializeClient() {
        EntityRendererRegistry.register(PlayerEngine.FISHING_BOBBER, CustomFishingBobberRenderer::new);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"playerengine", (String)"stream_tts"), (buf, context) -> {
            if (!enabledTTS) {
                return;
            }
            String clientId = buf.readUtf();
            String token = buf.readUtf();
            String text = buf.readUtf();
            double speed = buf.readDouble();
            int voiceIdCount = buf.readVarInt();
            String[] voiceIds = new String[voiceIdCount];
            for (int i = 0; i < voiceIdCount; ++i) {
                voiceIds[i] = buf.readUtf();
            }
            CompletableFuture.runAsync(() -> AudioUtils.streamAudio(clientId, token, text, speed, voiceIds));
        });
    }
}

