/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api;

import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.behavior.ILookBehavior;
import com.player2.playerengine.automaton.api.behavior.IPathingBehavior;
import com.player2.playerengine.automaton.api.cache.IWorldProvider;
import com.player2.playerengine.automaton.api.command.manager.ICommandManager;
import com.player2.playerengine.automaton.api.component.EntityComponentKey;
import com.player2.playerengine.automaton.api.event.listener.IEventBus;
import com.player2.playerengine.automaton.api.pathing.calc.IPathingControlManager;
import com.player2.playerengine.automaton.api.process.IBuilderProcess;
import com.player2.playerengine.automaton.api.process.ICustomGoalProcess;
import com.player2.playerengine.automaton.api.process.IExploreProcess;
import com.player2.playerengine.automaton.api.process.IFarmProcess;
import com.player2.playerengine.automaton.api.process.IFollowProcess;
import com.player2.playerengine.automaton.api.process.IGetToBlockProcess;
import com.player2.playerengine.automaton.api.process.IMineProcess;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.IInputOverrideHandler;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public interface IBaritone {
    public static final EntityComponentKey<IBaritone> KEY = new EntityComponentKey<IBaritone>(Baritone::new);

    public IPathingBehavior getPathingBehavior();

    public ILookBehavior getLookBehavior();

    public IFollowProcess getFollowProcess();

    public IMineProcess getMineProcess();

    public IBuilderProcess getBuilderProcess();

    public IExploreProcess getExploreProcess();

    public IFarmProcess getFarmProcess();

    public ICustomGoalProcess getCustomGoalProcess();

    public IGetToBlockProcess getGetToBlockProcess();

    public IWorldProvider getWorldProvider();

    public IPathingControlManager getPathingControlManager();

    public IInputOverrideHandler getInputOverrideHandler();

    public IEntityContext getEntityContext();

    public IEventBus getGameEventHandler();

    public ICommandManager getCommandManager();

    public void logDebug(String var1);

    default public void logDirect(Component ... components) {
        IEntityContext playerContext = this.getEntityContext();
        LivingEntity entity = playerContext.entity();
        if (entity instanceof Player) {
            MutableComponent component = Component.literal((String)"");
            component.append(BaritoneAPI.getPrefix());
            component.append((Component)Component.literal((String)" "));
            Arrays.asList(components).forEach(arg_0 -> ((MutableComponent)component).append(arg_0));
            ((Player)entity).displayClientMessage((Component)component, false);
        } else {
            for (ServerPlayer p : entity.level().getServer().getPlayerList().getPlayers()) {
                if (!p.isCreative()) continue;
                MutableComponent component = Component.literal((String)"");
                component.append(BaritoneAPI.getPrefix());
                component.append((Component)Component.literal((String)" "));
                Arrays.asList(components).forEach(arg_0 -> ((MutableComponent)component).append(arg_0));
                p.displayClientMessage((Component)component, false);
            }
        }
    }

    default public void logDirect(String message, ChatFormatting color) {
        Stream.of(message.split("\n")).forEach(line -> {
            MutableComponent component = Component.literal((String)line.replace("\t", "    "));
            component.setStyle(component.getStyle().applyFormat(color));
            this.logDirect(new Component[]{component});
        });
    }

    default public void logDirect(String message) {
        this.logDirect(message, ChatFormatting.GRAY);
    }

    public boolean isActive();

    public Settings settings();

    public void serverTick();
}

