/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.command.helpers;

import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.command.exception.CommandInvalidTypeException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class Paginator<E> {
    private final CommandSourceStack source;
    public final List<E> entries;
    public int pageSize = 8;
    public int page = 1;

    public Paginator(CommandSourceStack source, List<E> entries) {
        this.source = source;
        this.entries = entries;
    }

    public Paginator<E> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public int getMaxPage() {
        return (this.entries.size() - 1) / this.pageSize + 1;
    }

    public boolean validPage(int page) {
        return page > 0 && page <= this.getMaxPage();
    }

    public Paginator<E> skipPages(int pages) {
        this.page += pages;
        return this;
    }

    public void display(Function<E, Component> transform, String commandPrefix) {
        int offset;
        for (int i = offset = (this.page - 1) * this.pageSize; i < offset + this.pageSize; ++i) {
            if (i < this.entries.size()) {
                Object entry = this.entries.get(i);
                this.source.sendSuccess(() -> (Component)transform.apply(entry), false);
                continue;
            }
            this.source.sendSuccess(() -> Component.literal((String)"--").withStyle(ChatFormatting.DARK_GRAY), false);
        }
        boolean hasPrevPage = commandPrefix != null && this.validPage(this.page - 1);
        boolean hasNextPage = commandPrefix != null && this.validPage(this.page + 1);
        MutableComponent prevPageComponent = Component.literal((String)"<<");
        if (hasPrevPage) {
            prevPageComponent.setStyle(prevPageComponent.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("%s %d", commandPrefix, this.page - 1))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to view previous page"))));
        } else {
            prevPageComponent.setStyle(prevPageComponent.getStyle().applyFormat(ChatFormatting.DARK_GRAY));
        }
        MutableComponent nextPageComponent = Component.literal((String)">>");
        if (hasNextPage) {
            nextPageComponent.setStyle(nextPageComponent.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("%s %d", commandPrefix, this.page + 1))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to view next page"))));
        } else {
            nextPageComponent.setStyle(nextPageComponent.getStyle().applyFormat(ChatFormatting.DARK_GRAY));
        }
        this.source.sendSuccess(() -> {
            MutableComponent pagerComponent = Component.literal((String)"");
            pagerComponent.setStyle(pagerComponent.getStyle().applyFormat(ChatFormatting.GRAY));
            pagerComponent.append((Component)prevPageComponent);
            pagerComponent.append(" | ");
            pagerComponent.append((Component)nextPageComponent);
            pagerComponent.append(String.format(" %d/%d", this.page, this.getMaxPage()));
            return pagerComponent;
        }, false);
    }

    public static <T> void paginate(IArgConsumer consumer, Paginator<T> pagi, Runnable pre, Function<T, Component> transform, String commandPrefix) throws CommandException {
        int page = 1;
        consumer.requireMax(1);
        if (consumer.hasAny() && !pagi.validPage(page = consumer.getAs(Integer.class).intValue())) {
            throw new CommandInvalidTypeException(consumer.consumed(), String.format("a valid page (1-%d)", pagi.getMaxPage()), consumer.consumed().getValue());
        }
        pagi.skipPages(page - pagi.page);
        if (pre != null) {
            pre.run();
        }
        pagi.display(transform, commandPrefix);
    }

    public static <T> void paginate(IArgConsumer consumer, List<T> elems, Runnable pre, Function<T, Component> transform, String commandPrefix, CommandSourceStack source) throws CommandException {
        Paginator.paginate(consumer, new Paginator<T>(source, elems), pre, transform, commandPrefix);
    }

    public static <T> void paginate(IArgConsumer consumer, T[] elems, Runnable pre, Function<T, Component> transform, String commandPrefix, CommandSourceStack source) throws CommandException {
        Paginator.paginate(consumer, Arrays.asList(elems), pre, transform, commandPrefix, source);
    }

    public static <T> void paginate(IArgConsumer consumer, Paginator<T> pagi, Function<T, Component> transform, String commandPrefix) throws CommandException {
        Paginator.paginate(consumer, pagi, null, transform, commandPrefix);
    }

    public static <T> void paginate(IArgConsumer consumer, List<T> elems, Function<T, Component> transform, String commandPrefix, CommandSourceStack source) throws CommandException {
        Paginator.paginate(consumer, new Paginator<T>(source, elems), null, transform, commandPrefix);
    }

    public static <T> void paginate(IArgConsumer consumer, T[] elems, Function<T, Component> transform, String commandPrefix, CommandSourceStack source) throws CommandException {
        Paginator.paginate(consumer, Arrays.asList(elems), null, transform, commandPrefix, source);
    }

    public static <T> void paginate(IArgConsumer consumer, Paginator<T> pagi, Runnable pre, Function<T, Component> transform) throws CommandException {
        Paginator.paginate(consumer, pagi, pre, transform, null);
    }

    public static <T> void paginate(IArgConsumer consumer, List<T> elems, Runnable pre, Function<T, Component> transform, CommandSourceStack source) throws CommandException {
        Paginator.paginate(consumer, new Paginator<T>(source, elems), pre, transform, null);
    }

    public static <T> void paginate(IArgConsumer consumer, T[] elems, Runnable pre, Function<T, Component> transform, CommandSourceStack source) throws CommandException {
        Paginator.paginate(consumer, Arrays.asList(elems), pre, transform, null, source);
    }

    public static <T> void paginate(IArgConsumer consumer, Paginator<T> pagi, Function<T, Component> transform) throws CommandException {
        Paginator.paginate(consumer, pagi, null, transform, null);
    }

    public static <T> void paginate(IArgConsumer consumer, List<T> elems, Function<T, Component> transform, CommandSourceStack source) throws CommandException {
        Paginator.paginate(consumer, new Paginator<T>(source, elems), null, transform, null);
    }

    public static <T> void paginate(IArgConsumer consumer, T[] elems, Function<T, Component> transform, CommandSourceStack source) throws CommandException {
        Paginator.paginate(consumer, Arrays.asList(elems), null, transform, null, source);
    }
}

