/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.entity;

import com.mojang.logging.LogUtils;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.utils.IBucketAccessor;
import com.player2.playerengine.util.EnchantmentUtils;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LivingEntityInteractionManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected Level world;
    protected final LivingEntity livingEntity;
    private GameType gameMode = GameType.SURVIVAL;
    @Nullable
    private GameType previousGameMode;
    private boolean mining;
    private int startMiningTime;
    private BlockPos miningPos = BlockPos.ZERO;
    private int tickCounter;
    private boolean failedToMine;
    private BlockPos failedMiningPos = BlockPos.ZERO;
    private int failedStartMiningTime;
    private int blockBreakingProgress = -1;
    private boolean brokeBlock;

    public LivingEntityInteractionManager(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
        this.world = livingEntity.level();
    }

    public GameType getGameMode() {
        return this.gameMode;
    }

    @Nullable
    public GameType getPreviousGameMode() {
        return this.previousGameMode;
    }

    public boolean isSurvivalLike() {
        return this.gameMode.isSurvival();
    }

    public boolean isCreative() {
        return this.gameMode.isCreative();
    }

    public void update() {
        ++this.tickCounter;
        if (this.failedToMine) {
            BlockState blockState = this.world.getBlockState(this.failedMiningPos);
            if (blockState.isAir()) {
                this.failedToMine = false;
            } else {
                float f = this.continueMining(blockState, this.failedMiningPos, this.failedStartMiningTime);
                if (f >= 1.0f) {
                    this.failedToMine = false;
                    this.tryBreakBlock(this.failedMiningPos);
                }
            }
        } else if (this.mining) {
            BlockState blockState = this.world.getBlockState(this.miningPos);
            if (blockState.isAir()) {
                this.world.destroyBlockProgress(this.livingEntity.getId(), this.miningPos, -1);
                this.blockBreakingProgress = -1;
                this.mining = false;
            } else {
                this.continueMining(blockState, this.miningPos, this.startMiningTime);
            }
        }
    }

    private float continueMining(BlockState state, BlockPos pos, int progress) {
        int i = this.tickCounter - progress;
        float f = this.calcBlockBreakingDelta(state, this.livingEntity, (BlockGetter)this.livingEntity.level(), pos) * (float)(i + 1);
        int j = (int)(f * 10.0f);
        if (j != this.blockBreakingProgress) {
            this.world.destroyBlockProgress(this.livingEntity.getId(), pos, j);
            this.blockBreakingProgress = j;
        }
        return f;
    }

    private void method_41250(BlockPos pos, boolean bl, int i, String string) {
    }

    public void processBlockBreakingAction(BlockPos pos, ServerboundPlayerActionPacket.Action action, Direction direction, int worldHeight, int i) {
        if (this.livingEntity.getEyePosition().distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) > Mth.square((double)6.0)) {
            this.method_41250(pos, false, i, "too far");
        } else if (pos.getY() >= worldHeight) {
            this.method_41250(pos, false, i, "too high");
        } else if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            if (this.isCreative()) {
                this.finishMining(pos, i, "creative destroy");
                return;
            }
            this.startMiningTime = this.tickCounter;
            float f = 1.0f;
            BlockState blockState = this.world.getBlockState(pos);
            if (!blockState.isAir()) {
                f = this.calcBlockBreakingDelta(blockState, this.livingEntity, (BlockGetter)this.livingEntity.level(), pos);
            }
            if (!blockState.isAir() && f >= 1.0f) {
                this.finishMining(pos, i, "insta mine");
            } else {
                if (this.mining) {
                    this.method_41250(pos, false, i, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.mining = true;
                this.miningPos = pos.immutable();
                this.brokeBlock = true;
                int j = (int)(f * 10.0f);
                this.world.destroyBlockProgress(this.livingEntity.getId(), pos, j);
                this.method_41250(pos, true, i, "actual start of destroying");
                this.blockBreakingProgress = j;
            }
        } else if (action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            if (pos.equals((Object)this.miningPos)) {
                int k = this.tickCounter - this.startMiningTime;
                BlockState blockStatex = this.world.getBlockState(pos);
                if (!blockStatex.isAir()) {
                    float g = this.calcBlockBreakingDelta(blockStatex, this.livingEntity, (BlockGetter)this.livingEntity.level(), pos) * (float)(k + 1);
                    if (g >= 0.7f) {
                        this.mining = false;
                        this.world.destroyBlockProgress(this.livingEntity.getId(), pos, -1);
                        this.finishMining(pos, i, "destroyed");
                        return;
                    }
                    if (!this.failedToMine) {
                        this.mining = false;
                        this.failedToMine = true;
                        this.failedMiningPos = pos;
                        this.failedStartMiningTime = this.startMiningTime;
                    }
                }
            }
            this.method_41250(pos, true, i, "stopped destroying");
        } else if (action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK) {
            this.mining = false;
            if (!Objects.equals(this.miningPos, pos)) {
                LOGGER.warn("Mismatch in destroy block pos: {} {}", (Object)this.miningPos, (Object)pos);
                this.world.destroyBlockProgress(this.livingEntity.getId(), this.miningPos, -1);
                this.method_41250(pos, true, i, "aborted mismatched destroying");
            }
            this.world.destroyBlockProgress(this.livingEntity.getId(), pos, -1);
            this.method_41250(pos, true, i, "aborted destroying");
        }
    }

    public float calcBlockBreakingDelta(BlockState state, LivingEntity player, BlockGetter world, BlockPos pos) {
        float f = state.getDestroySpeed(world, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = this.canHarvest(state, player.getItemInHand(InteractionHand.MAIN_HAND)) ? 30 : 100;
        return this.getBlockBreakingSpeed(player, state) / f / (float)i;
    }

    public boolean canHarvest(BlockState state, ItemStack heldItem) {
        return !state.requiresCorrectToolForDrops() || heldItem.isCorrectToolForDrops(state);
    }

    public float getBlockBreakingSpeed(LivingEntity entity, BlockState block) {
        ItemStack itemStack;
        int i;
        float f = this.livingEntity.getItemInHand(InteractionHand.MAIN_HAND).getDestroySpeed(block);
        if (f > 1.0f && (i = EnchantmentUtils.getEnchantmentLevel(itemStack = this.livingEntity.getItemInHand(InteractionHand.MAIN_HAND), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY)) > 0 && !itemStack.isEmpty()) {
            f += (float)(i * i + 1);
        }
        if (MobEffectUtil.hasDigSpeed((LivingEntity)entity)) {
            f *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification((LivingEntity)entity) + 1) * 0.2f;
        }
        if (entity.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            f *= (switch (entity.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (entity.isEyeInFluid(FluidTags.WATER) && EnchantmentUtils.getEnchantmentLevel(entity.getItemBySlot(EquipmentSlot.HEAD), (ResourceKey<Enchantment>)Enchantments.AQUA_AFFINITY) != 0) {
            f /= 5.0f;
        }
        if (!entity.onGround()) {
            f /= 5.0f;
        }
        return f;
    }

    public void finishMining(BlockPos pos, int i, String reason) {
        if (this.tryBreakBlock(pos)) {
            this.method_41250(pos, true, i, reason);
        } else {
            this.method_41250(pos, false, i, reason);
        }
    }

    public boolean tryBreakBlock(BlockPos pos) {
        BlockState blockState = this.world.getBlockState(pos);
        BlockEntity blockEntity = this.world.getBlockEntity(pos);
        Block block = blockState.getBlock();
        if (block instanceof GameMasterBlock) {
            this.world.sendBlockUpdated(pos, blockState, blockState, 3);
            return false;
        }
        this.world.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((Entity)this.livingEntity, (BlockState)blockState));
        boolean bl = this.world.removeBlock(pos, false);
        if (bl) {
            block.destroy((LevelAccessor)this.world, pos, blockState);
        }
        if (this.isCreative()) {
            return true;
        }
        ItemStack itemStack = this.livingEntity.getMainHandItem();
        ItemStack itemStack2 = itemStack.copy();
        boolean bl2 = true;
        itemStack.getItem().mineBlock(itemStack, this.world, blockState, pos, this.livingEntity);
        if (bl && bl2) {
            Block.dropResources((BlockState)blockState, (Level)this.world, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)this.livingEntity, (ItemStack)itemStack2);
        }
        return true;
    }

    public InteractionResult interactItem(LivingEntity player, Level world, ItemStack stack, InteractionHand hand) {
        if (this.gameMode == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        int i = stack.getCount();
        int j = stack.getDamageValue();
        try {
            InteractionResultHolder<ItemStack> typedActionResult;
            Item item = stack.getItem();
            if (item instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)item;
                typedActionResult = this.useBucket(bucketItem, world, player, hand);
            } else {
                typedActionResult = stack.use(world, null, hand);
            }
            ItemStack itemStack = (ItemStack)typedActionResult.getObject();
            if (itemStack == stack && itemStack.getCount() == i && itemStack.getUseDuration(player) <= 0 && itemStack.getDamageValue() == j) {
                return typedActionResult.getResult();
            }
            if (typedActionResult.getResult() == InteractionResult.FAIL && itemStack.getUseDuration(player) > 0 && !player.isUsingItem()) {
                return typedActionResult.getResult();
            }
            if (stack != itemStack) {
                player.setItemInHand(hand, itemStack);
            }
            if (this.isCreative() && itemStack != ItemStack.EMPTY) {
                itemStack.setCount(i);
                if (itemStack.isDamageableItem() && itemStack.getDamageValue() != j) {
                    itemStack.setDamageValue(j);
                }
            }
            if (itemStack.isEmpty()) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            return typedActionResult.getResult();
        }
        catch (Exception var10) {
            return InteractionResult.PASS;
        }
    }

    public InteractionResultHolder<ItemStack> useBucket(BucketItem bucket, Level world, LivingEntity user, InteractionHand hand) {
        BlockPos blockPos3;
        ItemStack itemStack = user.getItemInHand(hand);
        BlockHitResult blockHitResult = LivingEntityInteractionManager.raycast(world, user, ((IBucketAccessor)bucket).getFluid() == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE);
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        BlockPos blockPos2 = blockPos.relative(direction);
        if (((IBucketAccessor)bucket).getFluid() == Fluids.EMPTY) {
            BucketPickup fluidDrainable;
            ItemStack itemStack2;
            BlockState blockState = world.getBlockState(blockPos);
            if (blockState.getBlock() instanceof BucketPickup && !(itemStack2 = (fluidDrainable = (BucketPickup)blockState.getBlock()).pickupBlock(null, (LevelAccessor)world, blockPos, blockState)).isEmpty()) {
                fluidDrainable.getPickupSound().ifPresent(sound -> user.playSound(sound, 1.0f, 1.0f));
                world.gameEvent((Entity)user, (Holder)GameEvent.FLUID_PICKUP, blockPos);
                ItemStack itemStack3 = LivingEntityInteractionManager.exchangeStack(itemStack, user, itemStack2);
                return InteractionResultHolder.sidedSuccess((Object)itemStack3, (boolean)world.isClientSide());
            }
            return InteractionResultHolder.fail((Object)itemStack);
        }
        BlockState blockState = world.getBlockState(blockPos);
        BlockPos blockPos4 = blockPos3 = blockState.getBlock() instanceof LiquidBlockContainer && ((IBucketAccessor)bucket).getFluid() == Fluids.WATER ? blockPos : blockPos2;
        if (bucket.emptyContents(null, world, blockPos3, blockHitResult)) {
            bucket.checkExtraContent(null, world, itemStack, blockPos3);
            return InteractionResultHolder.sidedSuccess((Object)new ItemStack((ItemLike)Items.BUCKET), (boolean)world.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public boolean canPlaceOn(LivingEntity entity, BlockPos pos, Direction facing, ItemStack stack) {
        BlockPos blockPos = pos.relative(facing.getOpposite());
        BlockInWorld cachedBlockPosition = new BlockInWorld((LevelReader)entity.level(), blockPos, false);
        return stack.canPlaceOnBlockInAdventureMode(cachedBlockPosition);
    }

    protected static BlockHitResult raycast(Level world, LivingEntity player, ClipContext.Fluid fluidHandling) {
        float f = player.getXRot();
        float g = player.getYRot();
        Vec3 vec3d = player.getEyePosition();
        float h = Mth.cos((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = Mth.sin((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float k = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        float l = i * j;
        float n = h * j;
        double d = 5.0;
        Vec3 vec3d2 = vec3d.add((double)l * 5.0, (double)k * 5.0, (double)n * 5.0);
        return world.clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.OUTLINE, fluidHandling, (Entity)player));
    }

    public static ItemStack exchangeStack(ItemStack inputStack, LivingEntity player, ItemStack outputStack) {
        inputStack.shrink(1);
        if (inputStack.isEmpty()) {
            return outputStack;
        }
        if (!((IInventoryProvider)player).getLivingInventory().insertStack(outputStack)) {
            player.spawnAtLocation(outputStack);
        }
        return inputStack;
    }

    public boolean shouldCancelInteraction() {
        return false;
    }

    public InteractionResult interactBlock(LivingEntity player, Level world, ItemStack stack, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos blockPos = hitResult.getBlockPos();
        BlockState blockState = world.getBlockState(blockPos);
        if (!blockState.getBlock().isEnabled(world.enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        boolean bl = !player.getMainHandItem().isEmpty() || !player.getOffhandItem().isEmpty();
        boolean bl2 = this.shouldCancelInteraction() && bl;
        ItemStack itemStack = stack.copy();
        if (!bl2) {
            try {
                InteractionResult actionResult = blockState.useItemOn(stack, world, null, hand, hitResult).result();
                if (actionResult.consumesAction()) {
                    return actionResult;
                }
            }
            catch (NullPointerException actionResult) {
                // empty catch block
            }
        }
        if (!stack.isEmpty()) {
            InteractionResult actionResult2;
            UseOnContext itemUsageContext = new UseOnContext(this, player.level(), null, hand, player.getItemInHand(hand), hitResult){

                public boolean isSecondaryUseActive() {
                    return this.isSecondaryUseActive();
                }
            };
            if (this.isCreative()) {
                int i = stack.getCount();
                actionResult2 = stack.useOn(itemUsageContext);
                stack.setCount(i);
            } else {
                actionResult2 = stack.useOn(itemUsageContext);
            }
            return actionResult2;
        }
        return InteractionResult.PASS;
    }

    public void setWorld(ServerLevel world) {
        this.world = world;
    }

    public boolean isMining() {
        return this.mining;
    }

    public BlockPos getMiningPos() {
        return this.miningPos;
    }

    public int getBlockBreakingProgress() {
        return this.blockBreakingProgress;
    }

    public boolean hasBrokenBlock() {
        return this.brokeBlock;
    }
}

