/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class LivingEntityInventory
implements Container,
Nameable {
    public static final int ITEM_USAGE_COOLDOWN = 5;
    public static final int MAIN_SIZE = 36;
    private static final int HOTBAR_SIZE = 9;
    public static final int OFF_HAND_SLOT = 40;
    public static final int NOT_FOUND = -1;
    public static final int[] ARMOR_SLOTS = new int[]{0, 1, 2, 3};
    public static final int[] HELMET_SLOTS = new int[]{3};
    public final NonNullList<ItemStack> main = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
    public final NonNullList<ItemStack> armor = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    public final NonNullList<ItemStack> offHand = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final List<NonNullList<ItemStack>> combinedInventory = ImmutableList.of(this.main, this.armor, this.offHand);
    public int selectedSlot;
    public LivingEntity player;
    private int changeCount;

    public LivingEntityInventory(LivingEntity player) {
        this.player = player;
    }

    public ItemStack getMainHandStack() {
        return LivingEntityInventory.isValidHotbarIndex(this.selectedSlot) ? (ItemStack)this.main.get(this.selectedSlot) : ItemStack.EMPTY;
    }

    public static int getHotbarSize() {
        return 9;
    }

    private boolean canStackAddMore(ItemStack existingStack, ItemStack stack) {
        return !existingStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)existingStack, (ItemStack)stack) && existingStack.isStackable() && existingStack.getCount() < existingStack.getMaxStackSize() && existingStack.getCount() < this.getMaxStackSize();
    }

    public int getEmptySlot() {
        for (int i = 0; i < this.main.size(); ++i) {
            if (!((ItemStack)this.main.get(i)).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public void addPickBlock(ItemStack stack) {
        int i = this.getSlotWithStack(stack);
        if (LivingEntityInventory.isValidHotbarIndex(i)) {
            this.selectedSlot = i;
        } else if (i == -1) {
            int j;
            this.selectedSlot = this.getSwappableHotbarSlot();
            if (!((ItemStack)this.main.get(this.selectedSlot)).isEmpty() && (j = this.getEmptySlot()) != -1) {
                this.main.set(j, (Object)((ItemStack)this.main.get(this.selectedSlot)));
            }
            this.main.set(this.selectedSlot, (Object)stack);
        } else {
            this.swapSlotWithHotbar(i);
        }
    }

    public void swapSlotWithHotbar(int slot) {
        this.selectedSlot = this.getSwappableHotbarSlot();
        ItemStack itemStack = (ItemStack)this.main.get(this.selectedSlot);
        this.main.set(this.selectedSlot, (Object)((ItemStack)this.main.get(slot)));
        this.main.set(slot, (Object)itemStack);
    }

    public static boolean isValidHotbarIndex(int slot) {
        return slot >= 0 && slot < 9;
    }

    public int getSlotWithStack(ItemStack stack) {
        for (int i = 0; i < this.main.size(); ++i) {
            if (((ItemStack)this.main.get(i)).isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((ItemStack)this.main.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(ItemStack stack) {
        for (int i = 0; i < this.main.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.main.get(i);
            if (((ItemStack)this.main.get(i)).isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((ItemStack)this.main.get(i))) || ((ItemStack)this.main.get(i)).isDamaged() || itemStack.isEnchanted() || itemStack.has(DataComponents.CUSTOM_NAME)) continue;
            return i;
        }
        return -1;
    }

    public int getSwappableHotbarSlot() {
        int j;
        for (int i = 0; i < 9; ++i) {
            j = (this.selectedSlot + i) % 9;
            if (!((ItemStack)this.main.get(j)).isEmpty()) continue;
            return j;
        }
        for (int ix = 0; ix < 9; ++ix) {
            j = (this.selectedSlot + ix) % 9;
            if (((ItemStack)this.main.get(j)).isEnchanted()) continue;
            return j;
        }
        return this.selectedSlot;
    }

    public void scrollInHotbar(double scrollAmount) {
        int i = (int)Math.signum(scrollAmount);
        this.selectedSlot -= i;
        while (this.selectedSlot < 0) {
            this.selectedSlot += 9;
        }
        while (this.selectedSlot >= 9) {
            this.selectedSlot -= 9;
        }
    }

    public int remove(Predicate<ItemStack> shouldRemove, int maxCount, Container craftingInventory) {
        int i = 0;
        boolean bl = maxCount == 0;
        i += ContainerHelper.clearOrCountMatchingItems((Container)this, shouldRemove, (int)(maxCount - i), (boolean)bl);
        return i + ContainerHelper.clearOrCountMatchingItems((Container)craftingInventory, shouldRemove, (int)(maxCount - i), (boolean)bl);
    }

    private int addStack(ItemStack stack) {
        int i = this.getOccupiedSlotWithRoomForStack(stack);
        if (i == -1) {
            i = this.getEmptySlot();
        }
        return i == -1 ? stack.getCount() : this.addStack(i, stack);
    }

    private int addStack(int slot, ItemStack stack) {
        Item item = stack.getItem();
        int i = stack.getCount();
        ItemStack itemStack = this.getItem(slot);
        if (itemStack.isEmpty()) {
            itemStack = new ItemStack((ItemLike)item, 0);
            itemStack.applyComponents(stack.getComponents());
            this.setItem(slot, itemStack);
        }
        int j = i;
        if (i > itemStack.getMaxStackSize() - itemStack.getCount()) {
            j = itemStack.getMaxStackSize() - itemStack.getCount();
        }
        if (j > this.getMaxStackSize() - itemStack.getCount()) {
            j = this.getMaxStackSize() - itemStack.getCount();
        }
        if (j == 0) {
            return i;
        }
        itemStack.grow(j);
        itemStack.setPopTime(5);
        return i -= j;
    }

    public int getOccupiedSlotWithRoomForStack(ItemStack stack) {
        if (this.canStackAddMore(this.getItem(this.selectedSlot), stack)) {
            return this.selectedSlot;
        }
        if (this.canStackAddMore(this.getItem(40), stack)) {
            return 40;
        }
        for (int i = 0; i < this.main.size(); ++i) {
            if (!this.canStackAddMore((ItemStack)this.main.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    public void updateItems() {
        for (NonNullList<ItemStack> defaultedList : this.combinedInventory) {
            for (int i = 0; i < defaultedList.size(); ++i) {
                if (((ItemStack)defaultedList.get(i)).isEmpty()) continue;
                ((ItemStack)defaultedList.get(i)).inventoryTick(this.player.level(), (Entity)this.player, i, this.selectedSlot == i);
            }
        }
    }

    public boolean insertStack(ItemStack stack) {
        return this.insertStack(-1, stack);
    }

    public boolean insertStack(int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        try {
            int i;
            if (stack.isDamaged()) {
                if (slot == -1) {
                    slot = this.getEmptySlot();
                }
                if (slot >= 0) {
                    this.main.set(slot, (Object)stack.copyAndClear());
                    ((ItemStack)this.main.get(slot)).setPopTime(5);
                    return true;
                }
                return false;
            }
            do {
                i = stack.getCount();
                if (slot == -1) {
                    stack.setCount(this.addStack(stack));
                    continue;
                }
                stack.setCount(this.addStack(slot, stack));
            } while (!stack.isEmpty() && stack.getCount() < i);
            return stack.getCount() < i;
        }
        catch (Throwable var6) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)var6, (String)"Adding item to inventory");
            CrashReportCategory crashReportSection = crashReport.addCategory("Item being added");
            crashReportSection.setDetail("Item ID", (Object)Item.getId((Item)stack.getItem()));
            crashReportSection.setDetail("Item data", (Object)stack.getDamageValue());
            crashReportSection.setDetail("Item name", () -> stack.getHoverName().getString());
            throw new ReportedException(crashReport);
        }
    }

    public ItemStack removeItem(int slot, int amount) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> defaultedList : this.combinedInventory) {
            if (slot < defaultedList.size()) {
                list = defaultedList;
                break;
            }
            slot -= defaultedList.size();
        }
        return list != null && !((ItemStack)list.get(slot)).isEmpty() ? ContainerHelper.removeItem(list, (int)slot, (int)amount) : ItemStack.EMPTY;
    }

    public void removeOne(ItemStack stack) {
        block0: for (NonNullList<ItemStack> defaultedList : this.combinedInventory) {
            for (int i = 0; i < defaultedList.size(); ++i) {
                if (defaultedList.get(i) != stack) continue;
                defaultedList.set(i, (Object)ItemStack.EMPTY);
                continue block0;
            }
        }
    }

    public ItemStack removeItemNoUpdate(int slot) {
        NonNullList<ItemStack> defaultedList = null;
        for (NonNullList<ItemStack> defaultedList2 : this.combinedInventory) {
            if (slot < defaultedList2.size()) {
                defaultedList = defaultedList2;
                break;
            }
            slot -= defaultedList2.size();
        }
        if (defaultedList != null && !((ItemStack)defaultedList.get(slot)).isEmpty()) {
            ItemStack itemStack = (ItemStack)defaultedList.get(slot);
            defaultedList.set(slot, (Object)ItemStack.EMPTY);
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
        NonNullList<ItemStack> defaultedList = null;
        for (NonNullList<ItemStack> defaultedList2 : this.combinedInventory) {
            if (slot < defaultedList2.size()) {
                defaultedList = defaultedList2;
                break;
            }
            slot -= defaultedList2.size();
        }
        if (defaultedList != null) {
            defaultedList.set(slot, (Object)stack);
        }
    }

    public float getBlockBreakingSpeed(BlockState block) {
        return ((ItemStack)this.main.get(this.selectedSlot)).getDestroySpeed(block);
    }

    public ListTag writeNbt(HolderLookup.Provider levelRegistryAccess, ListTag nbtList) {
        CompoundTag nbtCompound;
        for (int i = 0; i < this.main.size(); ++i) {
            if (((ItemStack)this.main.get(i)).isEmpty()) continue;
            nbtCompound = new CompoundTag();
            nbtCompound.putByte("Slot", (byte)i);
            ((ItemStack)this.main.get(i)).save(levelRegistryAccess, (Tag)nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        for (int ix = 0; ix < this.armor.size(); ++ix) {
            if (((ItemStack)this.armor.get(ix)).isEmpty()) continue;
            nbtCompound = new CompoundTag();
            nbtCompound.putByte("Slot", (byte)(ix + 100));
            ((ItemStack)this.armor.get(ix)).save(levelRegistryAccess, (Tag)nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        for (int ixx = 0; ixx < this.offHand.size(); ++ixx) {
            if (((ItemStack)this.offHand.get(ixx)).isEmpty()) continue;
            nbtCompound = new CompoundTag();
            nbtCompound.putByte("Slot", (byte)(ixx + 150));
            ((ItemStack)this.offHand.get(ixx)).save(levelRegistryAccess, (Tag)nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        return nbtList;
    }

    public void readNbt(HolderLookup.Provider levelRegistryAccess, ListTag nbtList) {
        this.main.clear();
        this.armor.clear();
        this.offHand.clear();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.getCompound(i);
            int j = nbtCompound.getByte("Slot") & 0xFF;
            ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)levelRegistryAccess, (CompoundTag)nbtCompound);
            if (itemStack.isEmpty()) continue;
            if (j >= 0 && j < this.main.size()) {
                this.main.set(j, (Object)itemStack);
                continue;
            }
            if (j >= 100 && j < this.armor.size() + 100) {
                this.armor.set(j - 100, (Object)itemStack);
                continue;
            }
            if (j < 150 || j >= this.offHand.size() + 150) continue;
            this.offHand.set(j - 150, (Object)itemStack);
        }
    }

    public int getContainerSize() {
        return this.main.size() + this.armor.size() + this.offHand.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.main) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemStackx : this.armor) {
            if (itemStackx.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemStackxx : this.offHand) {
            if (itemStackxx.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> defaultedList : this.combinedInventory) {
            if (slot < defaultedList.size()) {
                list = defaultedList;
                break;
            }
            slot -= defaultedList.size();
        }
        return list == null ? ItemStack.EMPTY : (ItemStack)list.get(slot);
    }

    public Component getName() {
        return Component.translatable((String)"container.inventory");
    }

    public ItemStack getArmorStack(int slot) {
        return (ItemStack)this.armor.get(slot);
    }

    public void damageArmor(DamageSource damageSource, float amount, int[] slots) {
        if (!(amount <= 0.0f)) {
            if ((amount /= 4.0f) < 1.0f) {
                amount = 1.0f;
            }
            for (int i : slots) {
                ItemStack itemStack = (ItemStack)this.armor.get(i);
                if (damageSource.is(DamageTypeTags.IS_FIRE) && itemStack.getItem().components().has(DataComponents.FIRE_RESISTANT) || !(itemStack.getItem() instanceof ArmorItem)) continue;
                itemStack.hurtAndBreak((int)amount, this.player, this.player.getEquipmentSlotForItem(itemStack));
            }
        }
    }

    public void dropAll() {
        for (List list : this.combinedInventory) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemStack = (ItemStack)list.get(i);
                if (itemStack.isEmpty()) continue;
                this.player.spawnAtLocation(itemStack);
                list.set(i, ItemStack.EMPTY);
            }
        }
    }

    public void setChanged() {
        ++this.changeCount;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public boolean stillValid(Player player) {
        return this.player.isRemoved() ? false : !(player.distanceToSqr((Entity)this.player) > 64.0);
    }

    public boolean contains(ItemStack stack) {
        for (List list : this.combinedInventory) {
            for (ItemStack itemStack : list) {
                if (itemStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(TagKey<Item> key) {
        for (List list : this.combinedInventory) {
            for (ItemStack itemStack : list) {
                if (itemStack.isEmpty() || !itemStack.is(key)) continue;
                return true;
            }
        }
        return false;
    }

    public void clone(LivingEntityInventory other) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, other.getItem(i));
        }
        this.selectedSlot = other.selectedSlot;
    }

    public void clearContent() {
        for (List list : this.combinedInventory) {
            list.clear();
        }
    }

    public void populateRecipeFinder(StackedContents finder) {
        for (ItemStack itemStack : this.main) {
            finder.accountSimpleStack(itemStack);
        }
    }

    public ItemStack dropSelectedItem(boolean entireStack) {
        ItemStack itemStack = this.getMainHandStack();
        return itemStack.isEmpty() ? ItemStack.EMPTY : this.removeItem(this.selectedSlot, entireStack ? itemStack.getCount() : 1);
    }
}

