/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.pathing.goals;

import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.SettingsUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class GoalXZ
implements Goal {
    private static final double SQRT_2 = Math.sqrt(2.0);
    private final int x;
    private final int z;

    public GoalXZ(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public GoalXZ(BetterBlockPos pos) {
        this.x = pos.x;
        this.z = pos.z;
    }

    @Override
    public boolean isInGoal(int x, int y, int z) {
        return x == this.x && z == this.z;
    }

    @Override
    public double heuristic(int x, int y, int z) {
        int xDiff = x - this.x;
        int zDiff = z - this.z;
        return GoalXZ.calculate(xDiff, zDiff);
    }

    public String toString() {
        return String.format("GoalXZ{x=%s,z=%s}", SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.z));
    }

    public static double calculate(double xDiff, double zDiff) {
        double straight;
        double z;
        double x = Math.abs(xDiff);
        if (x < (z = Math.abs(zDiff))) {
            straight = z - x;
            diagonal = x;
        } else {
            straight = x - z;
            diagonal = z;
        }
        return ((diagonal *= SQRT_2) + straight) * BaritoneAPI.getGlobalSettings().costHeuristic.get();
    }

    public static GoalXZ fromDirection(Vec3 origin, float yaw, double distance) {
        float theta = (float)Math.toRadians(yaw);
        double x = origin.x - (double)Mth.sin((float)theta) * distance;
        double z = origin.z + (double)Mth.cos((float)theta) * distance;
        return new GoalXZ(Mth.floor((double)x), Mth.floor((double)z));
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }
}

