/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.cache;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.cache.IContainerMemory;
import com.player2.playerengine.automaton.api.cache.IRememberedInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ContainerMemory
implements IContainerMemory {
    private final Map<BlockPos, RememberedInventory> inventories = new HashMap<BlockPos, RememberedInventory>();

    public void read(HolderLookup.Provider levelRegistryAccess, CompoundTag tag) {
        try {
            ListTag nbtInventories = tag.getList("inventories", 10);
            for (int i = 0; i < nbtInventories.size(); ++i) {
                CompoundTag nbtEntry = nbtInventories.getCompound(i);
                BlockPos pos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)nbtEntry, (String)"pos").get();
                RememberedInventory rem = new RememberedInventory();
                rem.fromNbt(levelRegistryAccess, nbtEntry.getList("content", 9));
                if (rem.items.isEmpty()) continue;
                this.inventories.put(pos, rem);
            }
        }
        catch (Exception var7) {
            PlayerEngine.LOGGER.error((Object)var7);
            this.inventories.clear();
        }
    }

    public CompoundTag toNbt(HolderLookup.Provider levelRegistryAccess) {
        CompoundTag tag = new CompoundTag();
        if (BaritoneAPI.getGlobalSettings().containerMemory.get().booleanValue()) {
            ListTag list = new ListTag();
            for (Map.Entry<BlockPos, RememberedInventory> entry : this.inventories.entrySet()) {
                CompoundTag nbtEntry = new CompoundTag();
                nbtEntry.put("pos", NbtUtils.writeBlockPos((BlockPos)entry.getKey()));
                nbtEntry.put("content", (Tag)entry.getValue().toNbt(levelRegistryAccess));
                list.add((Object)nbtEntry);
            }
            tag.put("inventories", (Tag)list);
        }
        return tag;
    }

    public synchronized void setup(BlockPos pos, int windowId, int slotCount) {
        RememberedInventory inventory = this.inventories.computeIfAbsent(pos, x -> new RememberedInventory());
        inventory.windowId = windowId;
        inventory.size = slotCount;
    }

    public synchronized Optional<RememberedInventory> getInventoryFromWindow(int windowId) {
        return this.inventories.values().stream().filter(i -> i.windowId == windowId).findFirst();
    }

    @Override
    public final synchronized RememberedInventory getInventoryByPos(BlockPos pos) {
        return this.inventories.get(pos);
    }

    @Override
    public final synchronized Map<BlockPos, IRememberedInventory> getRememberedInventories() {
        return new HashMap<BlockPos, IRememberedInventory>(this.inventories);
    }

    public static class RememberedInventory
    implements IRememberedInventory {
        private final List<ItemStack> items = new ArrayList<ItemStack>();
        private int windowId;
        private int size;

        private RememberedInventory() {
        }

        @Override
        public final List<ItemStack> getContents() {
            return Collections.unmodifiableList(this.items);
        }

        @Override
        public final int getSize() {
            return this.size;
        }

        public ListTag toNbt(HolderLookup.Provider levelRegistryAccess) {
            ListTag inv = new ListTag();
            for (ItemStack item : this.items) {
                inv.add((Object)item.save(levelRegistryAccess, (Tag)new CompoundTag()));
            }
            return inv;
        }

        public void fromNbt(HolderLookup.Provider levelRegistryAccess, ListTag content) {
            for (int i = 0; i < content.size(); ++i) {
                this.items.add(ItemStack.parseOptional((HolderLookup.Provider)levelRegistryAccess, (CompoundTag)content.getCompound(i)));
            }
            this.size = this.items.size();
            this.windowId = -1;
        }
    }
}

