/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement;

import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.pathing.movement.ActionCosts;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.RayTraceUtils;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.ToolSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface MovementHelper
extends ActionCosts {
    public static boolean avoidBreaking(BlockStateInterface bsi, int x, int y, int z, BlockState state, Settings settings) {
        Block b = state.getBlock();
        return b == Blocks.ICE || b instanceof InfestedBlock || MovementHelper.avoidAdjacentBreaking(bsi, x, y + 1, z, true, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x + 1, y, z, false, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x - 1, y, z, false, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x, y, z + 1, false, settings) || MovementHelper.avoidAdjacentBreaking(bsi, x, y, z - 1, false, settings);
    }

    public static boolean avoidAdjacentBreaking(BlockStateInterface bsi, int x, int y, int z, boolean directlyAbove, Settings settings) {
        BlockState state = bsi.get0(x, y, z);
        Block block = state.getBlock();
        return !directlyAbove && block instanceof FallingBlock && settings.avoidUpdatingFallingBlocks.get() != false && FallingBlock.isFree((BlockState)bsi.get0(x, y - 1, z)) ? true : !state.getFluidState().isEmpty();
    }

    public static boolean canWalkThrough(IEntityContext ctx, BetterBlockPos pos) {
        return MovementHelper.canWalkThrough(new BlockStateInterface(ctx), pos.x, pos.y, pos.z, ctx.baritone().settings());
    }

    public static boolean canWalkThrough(BlockStateInterface bsi, int x, int y, int z, Settings settings) {
        return MovementHelper.canWalkThrough(bsi, x, y, z, bsi.get0(x, y, z), settings);
    }

    public static boolean canWalkThrough(BlockStateInterface bsi, int x, int y, int z, BlockState state, Settings settings) {
        Block block = state.getBlock();
        if (block instanceof AirBlock) {
            return true;
        }
        if (!(block instanceof BaseFireBlock || block == Blocks.TRIPWIRE || block == Blocks.COBWEB || block == Blocks.END_PORTAL || block == Blocks.COCOA || block instanceof AbstractSkullBlock || block == Blocks.BUBBLE_COLUMN || block instanceof ShulkerBoxBlock || block instanceof SlabBlock || block instanceof TrapDoorBlock || block == Blocks.HONEY_BLOCK || block == Blocks.AZALEA || block == Blocks.FLOWERING_AZALEA || block == Blocks.GLOW_LICHEN || block == Blocks.CAVE_VINES || block == Blocks.CAVE_VINES_PLANT || block == Blocks.END_ROD)) {
            if (settings.blocksToAvoid.get().contains(state.getBlock())) {
                return false;
            }
            if (block instanceof DoorBlock || block instanceof FenceGateBlock) {
                return block instanceof FenceGateBlock || DoorBlock.isWoodenDoor((BlockState)state);
            }
            if (block instanceof CarpetBlock) {
                return MovementHelper.canWalkOn(bsi, x, y - 1, z, settings);
            }
            if (block instanceof SnowLayerBlock) {
                if (!bsi.worldContainsLoadedChunk(x, z)) {
                    return true;
                }
                return (Integer)state.getValue((Property)SnowLayerBlock.LAYERS) >= 3 ? false : MovementHelper.canWalkOn(bsi, x, y - 1, z, settings);
            }
            if (MovementHelper.isFlowing(x, y, z, state, bsi)) {
                return false;
            }
            FluidState fluidState = state.getFluidState();
            if (!(fluidState.getType() instanceof WaterFluid)) {
                return state.isPathfindable(PathComputationType.LAND);
            }
            if (settings.assumeWalkOnWater.get().booleanValue()) {
                return false;
            }
            BlockState up = bsi.get0(x, y + 1, z);
            return (settings.allowSwimming.get() != false || up.getFluidState().isEmpty()) && !(up.getBlock() instanceof WaterlilyBlock);
        }
        return false;
    }

    public static boolean fullyPassable(CalculationContext context, int x, int y, int z) {
        return MovementHelper.fullyPassable(context.bsi.access, (BlockPos)context.bsi.isPassableBlockPos.set(x, y, z), context.bsi.get0(x, y, z));
    }

    public static boolean fullyPassable(IEntityContext ctx, BlockPos pos) {
        return MovementHelper.fullyPassable((BlockGetter)ctx.world(), pos, ctx.world().getBlockState(pos));
    }

    public static boolean fullyPassable(BlockGetter access, BlockPos pos, BlockState state) {
        Block block = state.getBlock();
        if (block instanceof AirBlock) {
            return true;
        }
        return !(block instanceof BaseFireBlock) && block != Blocks.TRIPWIRE && block != Blocks.COBWEB && block != Blocks.VINE && block != Blocks.LADDER && block != Blocks.COCOA && !(block instanceof DoorBlock) && !(block instanceof FenceGateBlock) && !(block instanceof SnowLayerBlock) && state.getFluidState().isEmpty() && !(block instanceof TrapDoorBlock) && !(block instanceof EndPortalBlock) && !(block instanceof SkullBlock) && !(block instanceof ShulkerBoxBlock) ? state.isPathfindable(PathComputationType.LAND) : false;
    }

    public static boolean isReplaceable(int x, int y, int z, BlockState state, BlockStateInterface bsi) {
        Block block = state.getBlock();
        if (block instanceof AirBlock) {
            return true;
        }
        if (block instanceof SnowLayerBlock) {
            return !bsi.worldContainsLoadedChunk(x, z) ? true : (Integer)state.getValue((Property)SnowLayerBlock.LAYERS) == 1;
        }
        return block != Blocks.LARGE_FERN && block != Blocks.TALL_GRASS ? state.canBeReplaced() : true;
    }

    @Deprecated
    public static boolean isReplacable(int x, int y, int z, BlockState state, BlockStateInterface bsi) {
        return MovementHelper.isReplaceable(x, y, z, state, bsi);
    }

    public static boolean isDoorPassable(IEntityContext ctx, BlockPos doorPos, BlockPos playerPos) {
        if (playerPos.equals((Object)doorPos)) {
            return false;
        }
        BlockState state = BlockStateInterface.get(ctx, doorPos);
        return !(state.getBlock() instanceof DoorBlock) ? true : MovementHelper.isHorizontalBlockPassable(doorPos, state, playerPos, DoorBlock.OPEN);
    }

    public static boolean isGatePassable(IEntityContext ctx, BlockPos gatePos, BlockPos playerPos) {
        if (playerPos.equals((Object)gatePos)) {
            return false;
        }
        BlockState state = BlockStateInterface.get(ctx, gatePos);
        return !(state.getBlock() instanceof FenceGateBlock) ? true : (Boolean)state.getValue((Property)FenceGateBlock.OPEN);
    }

    public static boolean isHorizontalBlockPassable(BlockPos blockPos, BlockState blockState, BlockPos playerPos, BooleanProperty propertyOpen) {
        Direction.Axis playerFacing;
        if (playerPos.equals((Object)blockPos)) {
            return false;
        }
        Direction.Axis facing = ((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)).getAxis();
        boolean open = (Boolean)blockState.getValue((Property)propertyOpen);
        if (!playerPos.north().equals((Object)blockPos) && !playerPos.south().equals((Object)blockPos)) {
            if (!playerPos.east().equals((Object)blockPos) && !playerPos.west().equals((Object)blockPos)) {
                return true;
            }
            playerFacing = Direction.Axis.X;
        } else {
            playerFacing = Direction.Axis.Z;
        }
        return facing == playerFacing == open;
    }

    public static boolean avoidWalkingInto(BlockState state) {
        Block block = state.getBlock();
        return !state.getFluidState().isEmpty() || block == Blocks.MAGMA_BLOCK || block == Blocks.CACTUS || block instanceof BaseFireBlock || block == Blocks.END_PORTAL || block == Blocks.COBWEB || block == Blocks.BUBBLE_COLUMN;
    }

    public static boolean canWalkOn(BlockStateInterface bsi, int x, int y, int z, BlockState state, Settings settings) {
        Block block = state.getBlock();
        if (block instanceof AirBlock || block == Blocks.MAGMA_BLOCK || block == Blocks.BUBBLE_COLUMN || block == Blocks.HONEY_BLOCK) {
            return false;
        }
        if (MovementHelper.isBlockNormalCube(state)) {
            return true;
        }
        if (state.is(BlockTags.CLIMBABLE)) {
            return true;
        }
        if (block == Blocks.FARMLAND || block == Blocks.DIRT_PATH) {
            return true;
        }
        if (block == Blocks.ENDER_CHEST || block == Blocks.CHEST || block == Blocks.TRAPPED_CHEST) {
            return true;
        }
        if (MovementHelper.isWater(state)) {
            BlockState upState = bsi.get0(x, y + 1, z);
            Block up = upState.getBlock();
            if (up != Blocks.LILY_PAD && !(up instanceof CarpetBlock)) {
                return !MovementHelper.isFlowing(x, y, z, state, bsi) && upState.getFluidState().getType() != Fluids.FLOWING_WATER ? MovementHelper.isWater(upState) ^ settings.assumeWalkOnWater.get() : MovementHelper.isWater(upState) && settings.assumeWalkOnWater.get() == false;
            }
            return true;
        }
        if (settings.assumeWalkOnLava.get().booleanValue() && MovementHelper.isLava(state) && !MovementHelper.isFlowing(x, y, z, state, bsi)) {
            return true;
        }
        if (block == Blocks.GLASS || block instanceof StainedGlassBlock) {
            return true;
        }
        if (!(block instanceof SlabBlock)) {
            return block instanceof StairBlock;
        }
        return !settings.allowWalkOnBottomSlab.get().booleanValue() ? state.getValue((Property)SlabBlock.TYPE) != SlabType.BOTTOM : true;
    }

    public static boolean canWalkOn(IEntityContext ctx, BetterBlockPos pos, BlockState state) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.x, pos.y, pos.z, state, ctx.baritone().settings());
    }

    public static boolean canWalkOn(IEntityContext ctx, BlockPos pos) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.getX(), pos.getY(), pos.getZ(), ctx.baritone().settings());
    }

    public static boolean canWalkOn(IEntityContext ctx, BetterBlockPos pos) {
        return MovementHelper.canWalkOn(new BlockStateInterface(ctx), pos.x, pos.y, pos.z, ctx.baritone().settings());
    }

    public static boolean canWalkOn(BlockStateInterface bsi, int x, int y, int z, Settings settings) {
        return MovementHelper.canWalkOn(bsi, x, y, z, bsi.get0(x, y, z), settings);
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, int x, int y, int z) {
        return MovementHelper.canPlaceAgainst(bsi, x, y, z, bsi.get0(x, y, z));
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, BlockPos pos) {
        return MovementHelper.canPlaceAgainst(bsi, pos.getX(), pos.getY(), pos.getZ());
    }

    public static boolean canPlaceAgainst(IEntityContext ctx, BlockPos pos) {
        return MovementHelper.canPlaceAgainst(new BlockStateInterface(ctx), pos);
    }

    public static boolean canPlaceAgainst(BlockStateInterface bsi, int x, int y, int z, BlockState state) {
        return MovementHelper.isBlockNormalCube(state) || state.getBlock() == Blocks.GLASS || state.getBlock() instanceof StainedGlassBlock;
    }

    public static double getMiningDurationTicks(CalculationContext context, int x, int y, int z, boolean includeFalling) {
        return MovementHelper.getMiningDurationTicks(context, x, y, z, context.get(x, y, z), includeFalling);
    }

    public static double getMiningDurationTicks(CalculationContext context, int x, int y, int z, BlockState state, boolean includeFalling) {
        if (!MovementHelper.canWalkThrough(context.bsi, x, y, z, state, context.baritone.settings())) {
            BlockState above;
            if (!state.getFluidState().isEmpty()) {
                return 1000000.0;
            }
            double mult = context.breakCostMultiplierAt(x, y, z, state);
            if (mult >= 1000000.0) {
                return 1000000.0;
            }
            if (MovementHelper.avoidBreaking(context.bsi, x, y, z, state, context.baritone.settings())) {
                return 1000000.0;
            }
            if (context.toolSet == null) {
                return 1000000.0;
            }
            double strVsBlock = context.toolSet.getStrVsBlock(state);
            if (strVsBlock <= 0.0) {
                return 1000000.0;
            }
            double result = 1.0 / strVsBlock;
            result += context.breakBlockAdditionalCost;
            result *= mult;
            if (includeFalling && (above = context.get(x, y + 1, z)).getBlock() instanceof FallingBlock) {
                result += MovementHelper.getMiningDurationTicks(context, x, y + 1, z, above, true);
            }
            return result;
        }
        return 0.0;
    }

    public static boolean isBottomSlab(BlockState state) {
        return state.getBlock() instanceof SlabBlock && state.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM;
    }

    public static void switchToBestToolFor(IEntityContext ctx, BlockState b) {
        LivingEntity entity = ctx.entity();
        if (entity instanceof IInventoryProvider) {
            MovementHelper.switchToBestToolFor(ctx, b, new ToolSet(entity), ctx.baritone().settings().preferSilkTouch.get());
        }
    }

    public static void switchToBestToolFor(IEntityContext ctx, BlockState b, ToolSet ts, boolean preferSilkTouch) {
        LivingEntityInventory inventory = ctx.inventory();
        if (inventory != null && !ctx.baritone().settings().disableAutoTool.get().booleanValue() && !ctx.baritone().settings().assumeExternalAutoTool.get().booleanValue()) {
            inventory.selectedSlot = ts.getBestSlot(b.getBlock(), preferSilkTouch);
        }
    }

    public static void moveTowards(IEntityContext ctx, MovementState state, BlockPos pos) {
        state.setTarget(new MovementState.MovementTarget(new Rotation(RotationUtils.calcRotationFromVec3d(ctx.headPos(), VecUtils.getBlockPosCenter(pos), ctx.entityRotations()).getYaw(), ctx.entity().getXRot()), false)).setInput(Input.MOVE_FORWARD, true);
    }

    public static boolean isWater(BlockState state) {
        return state.getFluidState().is(FluidTags.WATER);
    }

    public static boolean isWater(IEntityContext ctx, BlockPos bp) {
        return MovementHelper.isWater(BlockStateInterface.get(ctx, bp));
    }

    public static boolean isLava(BlockState state) {
        Fluid f = state.getFluidState().getType();
        return f == Fluids.LAVA || f == Fluids.FLOWING_LAVA;
    }

    public static boolean isLiquid(IEntityContext ctx, BlockPos p) {
        return MovementHelper.isLiquid(BlockStateInterface.get(ctx, p));
    }

    public static boolean isLiquid(BlockState blockState) {
        return !blockState.getFluidState().isEmpty();
    }

    public static boolean possiblyFlowing(BlockState state) {
        FluidState fluidState = state.getFluidState();
        return fluidState.getType() instanceof FlowingFluid && fluidState.getType().getAmount(fluidState) != 8;
    }

    public static boolean isFlowing(int x, int y, int z, BlockState state, BlockStateInterface bsi) {
        FluidState fluidState = state.getFluidState();
        if (!(fluidState.getType() instanceof FlowingFluid)) {
            return false;
        }
        return fluidState.getType().getAmount(fluidState) != 8 ? true : MovementHelper.possiblyFlowing(bsi.get0(x + 1, y, z)) || MovementHelper.possiblyFlowing(bsi.get0(x - 1, y, z)) || MovementHelper.possiblyFlowing(bsi.get0(x, y, z + 1)) || MovementHelper.possiblyFlowing(bsi.get0(x, y, z - 1));
    }

    public static boolean isBlockNormalCube(BlockState state) {
        Block block = state.getBlock();
        if (!(block instanceof BambooStalkBlock || block instanceof MovingPistonBlock || block instanceof ScaffoldingBlock || block instanceof ShulkerBoxBlock)) {
            try {
                return state.isCollisionShapeFullBlock(null, BlockPos.ZERO);
            }
            catch (NullPointerException var3) {
                return false;
            }
        }
        return false;
    }

    public static PlaceResult attemptToPlaceABlock(MovementState state, IBaritone baritone, BlockPos placeAt, boolean preferDown, boolean wouldSneak) {
        IEntityContext ctx = baritone.getEntityContext();
        Optional<Rotation> direct = RotationUtils.reachable(ctx, placeAt, wouldSneak);
        boolean found = false;
        if (direct.isPresent()) {
            state.setTarget(new MovementState.MovementTarget(direct.get(), true));
            found = true;
        }
        int i = 0;
        while (true) {
            block12: {
                block11: {
                    if (i >= 5) break block11;
                    BlockPos against1 = placeAt.relative(Movement.HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i]);
                    if (!MovementHelper.canPlaceAgainst(ctx, against1)) break block12;
                    if (!((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(false, placeAt.getX(), placeAt.getY(), placeAt.getZ())) {
                        baritone.logDebug("bb pls get me some blocks. dirt, netherrack, cobble");
                        state.setStatus(MovementStatus.UNREACHABLE);
                        return PlaceResult.NO_OPTION;
                    }
                    double faceX = ((double)(placeAt.getX() + against1.getX()) + 1.0) * 0.5;
                    double faceY = ((double)(placeAt.getY() + against1.getY()) + 0.5) * 0.5;
                    double faceZ = ((double)(placeAt.getZ() + against1.getZ()) + 1.0) * 0.5;
                    Rotation place = RotationUtils.calcRotationFromVec3d(wouldSneak ? RayTraceUtils.inferSneakingEyePosition((Entity)ctx.entity()) : ctx.headPos(), new Vec3(faceX, faceY, faceZ), ctx.entityRotations());
                    HitResult res = RayTraceUtils.rayTraceTowards((Entity)ctx.entity(), place, ctx.playerController().getBlockReachDistance(), wouldSneak);
                    if (res == null || res.getType() != HitResult.Type.BLOCK || !((BlockHitResult)res).getBlockPos().equals((Object)against1) || !((BlockHitResult)res).getBlockPos().relative(((BlockHitResult)res).getDirection()).equals((Object)placeAt)) break block12;
                    state.setTarget(new MovementState.MovementTarget(place, true));
                    found = true;
                    if (preferDown) break block12;
                }
                if (ctx.getSelectedBlock().isPresent()) {
                    BlockPos selectedBlock = ctx.getSelectedBlock().get();
                    Direction side = ((BlockHitResult)ctx.objectMouseOver()).getDirection();
                    if (selectedBlock.equals((Object)placeAt) || MovementHelper.canPlaceAgainst(ctx, selectedBlock) && selectedBlock.relative(side).equals((Object)placeAt)) {
                        if (wouldSneak) {
                            state.setInput(Input.SNEAK, true);
                        }
                        ((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(true, placeAt.getX(), placeAt.getY(), placeAt.getZ());
                        return PlaceResult.READY_TO_PLACE;
                    }
                }
                if (found) {
                    if (wouldSneak) {
                        state.setInput(Input.SNEAK, true);
                    }
                    ((Baritone)baritone).getInventoryBehavior().selectThrowawayForLocation(true, placeAt.getX(), placeAt.getY(), placeAt.getZ());
                    return PlaceResult.ATTEMPTING;
                }
                return PlaceResult.NO_OPTION;
            }
            ++i;
        }
    }

    public static boolean isTransparent(Block b) {
        return b == Blocks.AIR || b == Blocks.LAVA || b == Blocks.WATER;
    }

    public static enum PlaceResult {
        READY_TO_PLACE,
        ATTEMPTING,
        NO_OPTION;

    }
}

