/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.process;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalBlock;
import com.player2.playerengine.automaton.api.pathing.goals.GoalComposite;
import com.player2.playerengine.automaton.api.pathing.goals.GoalGetToBlock;
import com.player2.playerengine.automaton.api.pathing.goals.GoalRunAway;
import com.player2.playerengine.automaton.api.pathing.goals.GoalTwoBlocks;
import com.player2.playerengine.automaton.api.process.IGetToBlockProcess;
import com.player2.playerengine.automaton.api.process.PathingCommand;
import com.player2.playerengine.automaton.api.process.PathingCommandType;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.BlockOptionalMeta;
import com.player2.playerengine.automaton.api.utils.BlockOptionalMetaLookup;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.process.MineProcess;
import com.player2.playerengine.automaton.utils.BaritoneProcessHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public final class GetToBlockProcess
extends BaritoneProcessHelper
implements IGetToBlockProcess {
    private BlockOptionalMeta gettingTo;
    private List<BlockPos> knownLocations;
    private List<BlockPos> blacklist;
    private BlockPos start;
    private int tickCount = 0;
    private int arrivalTickCount = 0;

    public GetToBlockProcess(Baritone baritone) {
        super(baritone);
    }

    @Override
    public void getToBlock(BlockOptionalMeta block) {
        this.onLostControl();
        this.gettingTo = block;
        this.start = this.ctx.feetPos();
        this.blacklist = new ArrayList<BlockPos>();
        this.arrivalTickCount = 0;
        this.rescan(new ArrayList<BlockPos>(), new CalculationContext(this.baritone));
    }

    @Override
    public boolean isActive() {
        return this.gettingTo != null;
    }

    @Override
    public synchronized PathingCommand onTick(boolean calcFailed, boolean isSafeToCancel) {
        if (this.knownLocations == null) {
            this.rescan(new ArrayList<BlockPos>(), new CalculationContext(this.baritone));
        }
        if (this.knownLocations.isEmpty()) {
            if (this.baritone.settings().exploreForBlocks.get().booleanValue() && !calcFailed) {
                return new PathingCommand(new GoalRunAway(this, 1.0, new BlockPos[]{this.start}){

                    @Override
                    public boolean isInGoal(int x, int y, int z) {
                        return false;
                    }

                    @Override
                    public double heuristic() {
                        return Double.NEGATIVE_INFINITY;
                    }
                }, PathingCommandType.FORCE_REVALIDATE_GOAL_AND_PATH);
            }
            this.logDirect("No known locations of " + String.valueOf(this.gettingTo) + ", canceling GetToBlock");
            if (isSafeToCancel) {
                this.onLostControl();
            }
            return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
        }
        GoalComposite goal = new GoalComposite((Goal[])this.knownLocations.stream().map(this::createGoal).toArray(Goal[]::new));
        if (calcFailed) {
            if (this.baritone.settings().blacklistClosestOnFailure.get().booleanValue()) {
                this.logDirect("Unable to find any path to " + String.valueOf(this.gettingTo) + ", blacklisting presumably unreachable closest instances...");
                this.blacklistClosest();
                return this.onTick(false, isSafeToCancel);
            }
            this.logDirect("Unable to find any path to " + String.valueOf(this.gettingTo) + ", canceling GetToBlock");
            if (isSafeToCancel) {
                this.onLostControl();
            }
            return new PathingCommand(goal, PathingCommandType.CANCEL_AND_SET_GOAL);
        }
        int mineGoalUpdateInterval = this.baritone.settings().mineGoalUpdateInterval.get();
        if (mineGoalUpdateInterval != 0 && this.tickCount++ % mineGoalUpdateInterval == 0) {
            ArrayList<BlockPos> current = new ArrayList<BlockPos>(this.knownLocations);
            CalculationContext context = new CalculationContext(this.baritone, true);
            PlayerEngine.getExecutor().execute(() -> this.rescan(current, context));
        }
        if (goal.isInGoal(this.ctx.feetPos()) && goal.isInGoal(this.baritone.getPathingBehavior().pathStart()) && isSafeToCancel) {
            if (!this.rightClickOnArrival(this.gettingTo.getBlock())) {
                this.onLostControl();
                return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
            }
            if (this.rightClick()) {
                this.onLostControl();
                return new PathingCommand(null, PathingCommandType.CANCEL_AND_SET_GOAL);
            }
        }
        return new PathingCommand(goal, PathingCommandType.REVALIDATE_GOAL_AND_PATH);
    }

    @Override
    public synchronized boolean blacklistClosest() {
        ArrayList<BlockPos> newBlacklist = new ArrayList<BlockPos>();
        this.knownLocations.stream().min(Comparator.comparingDouble(arg_0 -> ((BetterBlockPos)this.ctx.feetPos()).distSqr(arg_0))).ifPresent(newBlacklist::add);
        block2: while (true) {
            block3: for (BlockPos known : this.knownLocations) {
                for (BlockPos blacklist : newBlacklist) {
                    if (!this.areAdjacent(known, blacklist)) continue;
                    newBlacklist.add(known);
                    this.knownLocations.remove(known);
                    continue block2;
                    continue block3;
                }
            }
            break;
        }
        switch (newBlacklist.size()) {
            default: 
        }
        this.baritone.logDebug("Blacklisting unreachable locations " + String.valueOf(newBlacklist));
        this.blacklist.addAll(newBlacklist);
        return !newBlacklist.isEmpty();
    }

    private boolean areAdjacent(BlockPos posA, BlockPos posB) {
        int diffZ;
        int diffY;
        int diffX = Math.abs(posA.getX() - posB.getX());
        return diffX + (diffY = Math.abs(posA.getY() - posB.getY())) + (diffZ = Math.abs(posA.getZ() - posB.getZ())) == 1;
    }

    @Override
    public synchronized void onLostControl() {
        this.gettingTo = null;
        this.knownLocations = null;
        this.start = null;
        this.blacklist = null;
        this.baritone.getInputOverrideHandler().clearAllKeys();
    }

    @Override
    public String displayName0() {
        return this.knownLocations.isEmpty() ? "Exploring randomly to find " + String.valueOf(this.gettingTo) + ", no known locations" : "Get To " + String.valueOf(this.gettingTo) + ", " + this.knownLocations.size() + " known locations";
    }

    private synchronized void rescan(List<BlockPos> known, CalculationContext context) {
        List<BlockPos> positions = MineProcess.searchWorld(context, new BlockOptionalMetaLookup(this.gettingTo), 64, known, this.blacklist, Collections.emptyList());
        positions.removeIf(this.blacklist::contains);
        this.knownLocations = positions;
    }

    private Goal createGoal(BlockPos pos) {
        if (this.walkIntoInsteadOfAdjacent(this.gettingTo.getBlock())) {
            return new GoalTwoBlocks(pos);
        }
        return this.blockOnTopMustBeRemoved(this.gettingTo.getBlock()) && MovementHelper.isBlockNormalCube(this.baritone.bsi.get0(pos.above())) ? new GoalBlock(pos.above()) : new GoalGetToBlock(pos);
    }

    private boolean rightClick() {
        for (BlockPos pos : this.knownLocations) {
            Optional<Rotation> reachable = RotationUtils.reachable(this.ctx.entity(), pos, this.ctx.playerController().getBlockReachDistance());
            if (!reachable.isPresent()) continue;
            this.baritone.getLookBehavior().updateTarget(reachable.get(), true);
            if (this.knownLocations.contains(this.ctx.getSelectedBlock().orElse(null))) {
                this.baritone.getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
            }
            if (this.arrivalTickCount++ > 20) {
                this.logDirect("Right click timed out");
                return true;
            }
            return false;
        }
        this.logDirect("Arrived but failed to right click open");
        return true;
    }

    private boolean walkIntoInsteadOfAdjacent(Block block) {
        return this.baritone.settings().enterPortal.get() == false ? false : block == Blocks.NETHER_PORTAL;
    }

    private boolean rightClickOnArrival(Block block) {
        return this.baritone.settings().rightClickContainerOnArrival.get() == false ? false : block == Blocks.CRAFTING_TABLE || block == Blocks.FURNACE || block == Blocks.ENDER_CHEST || block == Blocks.CHEST || block == Blocks.TRAPPED_CHEST;
    }

    private boolean blockOnTopMustBeRemoved(Block block) {
        return !this.rightClickOnArrival(block) ? false : block == Blocks.ENDER_CHEST || block == Blocks.CHEST || block == Blocks.TRAPPED_CHEST;
    }
}

