/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils;

import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.utils.BlockStateInterfaceAccessWrapper;
import com.player2.playerengine.automaton.utils.accessor.ServerChunkManagerAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class BlockStateInterface {
    private final ServerChunkManagerAccessor provider;
    protected final BlockGetter world;
    public final BlockPos.MutableBlockPos isPassableBlockPos;
    public final BlockGetter access;
    private LevelChunk prev = null;
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();

    public BlockStateInterface(IEntityContext ctx) {
        this((Level)ctx.world());
    }

    public BlockStateInterface(Level world) {
        this.world = world;
        this.provider = (ServerChunkManagerAccessor)world.getChunkSource();
        this.isPassableBlockPos = new BlockPos.MutableBlockPos();
        this.access = new BlockStateInterfaceAccessWrapper(this);
    }

    public boolean worldContainsLoadedChunk(int blockX, int blockZ) {
        return this.provider.automatone$getChunkNow(blockX >> 4, blockZ >> 4) != null;
    }

    public static Block getBlock(IEntityContext ctx, BlockPos pos) {
        return BlockStateInterface.get(ctx, pos).getBlock();
    }

    public static BlockState get(IEntityContext ctx, BlockPos pos) {
        return ctx.world().getBlockState(pos);
    }

    public BlockState get0(BlockPos pos) {
        return this.get0(pos.getX(), pos.getY(), pos.getZ());
    }

    public BlockState get0(int x, int y, int z) {
        if (this.world.isOutsideBuildHeight(y)) {
            return AIR;
        }
        LevelChunk cached = this.prev;
        if (cached != null && cached.getPos().x == x >> 4 && cached.getPos().z == z >> 4) {
            return BlockStateInterface.getFromChunk(this.world, (ChunkAccess)cached, x, y, z);
        }
        LevelChunk chunk = this.provider.automatone$getChunkNow(x >> 4, z >> 4);
        if (chunk != null && !chunk.isEmpty()) {
            this.prev = chunk;
            return BlockStateInterface.getFromChunk(this.world, (ChunkAccess)chunk, x, y, z);
        }
        return AIR;
    }

    public boolean isLoaded(int x, int z) {
        LevelChunk prevChunk = this.prev;
        if (prevChunk != null && prevChunk.getPos().x == x >> 4 && prevChunk.getPos().z == z >> 4) {
            return true;
        }
        prevChunk = this.provider.automatone$getChunkNow(x >> 4, z >> 4);
        if (prevChunk != null && !prevChunk.isEmpty()) {
            this.prev = prevChunk;
            return true;
        }
        return false;
    }

    public static BlockState getFromChunk(BlockGetter world, ChunkAccess chunk, int x, int y, int z) {
        LevelChunkSection section = chunk.getSections()[world.getSectionIndex(y)];
        return section.hasOnlyAir() ? AIR : section.getBlockState(x & 0xF, y & 0xF, z & 0xF);
    }
}

