/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils;

import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.util.EnchantmentUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ToolSet {
    private final Map<Block, Double> breakStrengthCache = new HashMap<Block, Double>();
    private final Function<Block, Double> backendCalculation;
    private final LivingEntity player;
    private final IBaritone baritone;

    public ToolSet(LivingEntity player) {
        this.player = player;
        this.baritone = IBaritone.KEY.get(player);
        if (this.baritone.settings().considerPotionEffects.get().booleanValue()) {
            double amplifier = this.potionAmplifier();
            Function<Double, Double> amplify = x -> amplifier * x;
            this.backendCalculation = amplify.compose(this::getBestDestructionTime);
        } else {
            this.backendCalculation = this::getBestDestructionTime;
        }
    }

    public double getStrVsBlock(BlockState state) {
        return this.breakStrengthCache.computeIfAbsent(state.getBlock(), this.backendCalculation);
    }

    private int getMaterialCost(ItemStack itemStack) {
        return itemStack.getItem() instanceof TieredItem ? 1 : -1;
    }

    public boolean hasSilkTouch(ItemStack stack) {
        return EnchantmentUtils.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH) != 0;
    }

    public int getBestSlot(Block b, boolean preferSilkTouch) {
        return this.getBestSlot(b, preferSilkTouch, false);
    }

    public int getBestSlot(Block b, boolean preferSilkTouch, boolean pathingCalculation) {
        if (b.defaultBlockState().getBlock().defaultDestroyTime() == 0.0f) {
            return ((IInventoryProvider)this.player).getLivingInventory().selectedSlot;
        }
        if (this.baritone.settings().disableAutoTool.get().booleanValue() && pathingCalculation) {
            return ((IInventoryProvider)this.player).getLivingInventory().selectedSlot;
        }
        int best = 0;
        double highestSpeed = Double.NEGATIVE_INFINITY;
        int lowestCost = Integer.MIN_VALUE;
        boolean bestSilkTouch = false;
        BlockState blockState = b.defaultBlockState();
        for (int i = 0; i < 9; ++i) {
            int cost;
            ItemStack itemStack = ((IInventoryProvider)this.player).getLivingInventory().getItem(i);
            if (!this.baritone.settings().useSwordToMine.get().booleanValue() && itemStack.getItem() instanceof SwordItem || this.baritone.settings().itemSaver.get().booleanValue() && itemStack.getDamageValue() >= itemStack.getMaxDamage() && itemStack.getMaxDamage() > 1) continue;
            double speed = ToolSet.calculateSpeedVsBlock(itemStack, blockState);
            boolean silkTouch = this.hasSilkTouch(itemStack);
            if (speed > highestSpeed) {
                highestSpeed = speed;
                best = i;
                lowestCost = this.getMaterialCost(itemStack);
                bestSilkTouch = silkTouch;
                continue;
            }
            if (speed != highestSpeed || ((cost = this.getMaterialCost(itemStack)) >= lowestCost || !silkTouch && bestSilkTouch) && (!preferSilkTouch || bestSilkTouch || !silkTouch)) continue;
            highestSpeed = speed;
            best = i;
            lowestCost = cost;
            bestSilkTouch = silkTouch;
        }
        return best;
    }

    private double getBestDestructionTime(Block b) {
        ItemStack stack = ((IInventoryProvider)this.player).getLivingInventory().getItem(this.getBestSlot(b, false, true));
        return ToolSet.calculateSpeedVsBlock(stack, b.defaultBlockState()) * this.avoidanceMultiplier(b);
    }

    private double avoidanceMultiplier(Block b) {
        return this.baritone.settings().blocksToAvoidBreaking.get().contains(b.builtInRegistryHolder().value()) ? 0.1 : 1.0;
    }

    public static double calculateSpeedVsBlock(ItemStack item, BlockState state) {
        int effLevel;
        float hardness = state.getDestroySpeed(null, null);
        if (hardness < 0.0f) {
            return -1.0;
        }
        float speed = item.getDestroySpeed(state);
        if (speed > 1.0f && (effLevel = EnchantmentUtils.getEnchantmentLevel(item, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY)) > 0 && !item.isEmpty()) {
            speed += (float)(effLevel * effLevel + 1);
        }
        return state.requiresCorrectToolForDrops() && (item.isEmpty() || !item.isCorrectToolForDrops(state)) ? (double)(speed / 100.0f) : (double)((speed /= hardness) / 30.0f);
    }

    private double potionAmplifier() {
        MobEffectInstance fatigueEffect;
        double speed = 1.0;
        MobEffectInstance hasteEffect = this.player.getEffect(MobEffects.DIG_SPEED);
        if (hasteEffect != null) {
            speed *= 1.0 + (double)(hasteEffect.getAmplifier() + 1) * 0.2;
        }
        if ((fatigueEffect = this.player.getEffect(MobEffects.DIG_SLOWDOWN)) != null) {
            switch (fatigueEffect.getAmplifier()) {
                case 0: {
                    speed *= 0.3;
                    break;
                }
                case 1: {
                    speed *= 0.09;
                    break;
                }
                case 2: {
                    speed *= 0.0027;
                    break;
                }
                default: {
                    speed *= 8.1E-4;
                }
            }
        }
        return speed;
    }
}

