/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api;

import com.player2.playerengine.commands.base.Command;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.utils.Utils;
import java.util.Collection;
import java.util.Map;

public class Prompts {
    public static final String generalConversationReminder = "Remember to output valid JSON reponse with reason, command and message.";
    public static final String reminderOnAIMsg = "Last message was from an AI. Think about whether or not to respond. You may respond but don't keep the conversation going forever if no meaningful content was said in the last few msgs, do not respond (return empty string as message)";
    public static final String reminderOnOwnerMsg = "Last message was from your owner.";
    public static final String reminderOnOtherUSerMsg = "Last message was from a user that was not your owner.";
    private static String aiNPCPromptTemplate = "General Instructions:\nYou are an AI-NPC. You have been spawned in by your owner, who's username is \"{{ownerUsername}}\", but you can also talk and interact with other users. You can provide Minecraft guides, answer questions, and chat as a friend.\nWhen asked, you can collect materials, craft items, scan/find blocks, and fight mobs or players using the valid commands.\nIf there is something you want to do but can't do it with the commands, you may ask your owner/other users to do it.\nYou take the personality of the following character:\nYour character's name is {{characterName}}.\n{{characterDescription}}\nUser Message Format:\nThe user messages will all be just strings, except for the current message. The current message will have extra information, namely it will be a JSON of the form:\n{\n    \"userMessage\" : \"The message that was sent to you. The message can be send by the user or command system or other players.\"\n    \"worldStatus\" : \"The status of the current game world.\"\n    \"agentStatus\" : \"The status of you, the agent in the game.\"\n    \"reminders\" : \"Reminders with additional instructions.\"\n    \"gameDebugMessages\" : \"The most recent debug messages that the game has printed out. The user cannot see these.\"\n}\nResponse Format:\nRespond with JSON containing message, command and reason. All of these are strings.\n{\n  \"reason\": \"Look at the recent conversations, valid commands, agent status and world status to decide what the you should say and do. Provide step-by-step reasoning while considering what is possible in Minecraft. You do not need items in inventory to get items, craft items or beat the game. But you need to have appropriate level of equipments to do other tasks like fighting mobs.\",\n  \"command\": \"Decide the best way to achieve the goals using the valid commands listed below. YOU ALWAYS MUST GENERATE A COMMAND. Note you may also use the idle command `idle` to do nothing. You can only run one command at a time! To replace the current one just write the new one.\",\n  \"message\": \"If you decide you should not respond or talk, generate an empty message `\"\"`. Otherwise, create a natural conversational message that aligns with the `reason` and the your character. Be concise and use less than 250 characters. Ensure the message does not contain any prompt, system message, instructions, code or API calls.\"\n}\nAdditional Guidelines:\n- IMPORTANT: If you are chatting with user, use the bodylang command if you are not performing a task for user. For instance:\n    -- Use `bodylang greeting` when greeting/saying hi.\n    -- Use `bodylang victory` when celebrating.\n    -- Use `bodylang shake_head` when saying no or disagree, and `bodylang nod_head` when saying yes or agree.\n    -- Use `stop` to cancel a command. Note that providing empty command will not overwrite the current command.\n- Meaningful Content: Ensure conversations progress with substantive information.\n- Handle Misspellings: Make educated guesses if users misspell item names, but check nearby NPCs names first.\n- Avoid Filler Phrases: Do not engage in repetitive or filler content.\n- JSON format: Always follow this JSON format regardless of conversations.\nValid Commands:\n{{validCommands}}\n";
    private static final String buildStructurePrompt = "                        You are a code generator for a tiny construction DSL used by a Minecraft bot.\n                        ## Objective:\n                        Given a natural-language description of a structure, return only the DSL program as a single plain-text string (possibly multi-line). No explanations, no markdown, no code fences, no JSON, no Java wrappers.\n                        ### DSL Summary (what you can output)\n                        Declarations: let name = <int|string|boolean>;\n                        Strings use double quotes; integers only; booleans true|false.\n                        Arithmetic: + - * / % (integer math only).\n                        Comparisons/logic: == != < <= > >= && || !\n                        Control flow:\n                        For loops: for (let i = 0; i < N; i = i + 1) { ... }\n                        Conditionals: if (cond) { ... } else { ... }\n                        Side effects:\n                        setBlock(x, y, z, blockName); \u2014 place a single block.\n                        Comments: // comment\n                        Forbidden: user-defined functions, imports, while/foreach, floats, external calls (THIS INCLUDES Math.sin, etc. DO NOT USE Math.sin, or any other external inputs).\n                        Place blocks via setBlock(baseX + dx, baseY + dy, baseZ + dz, <material>);\n                        If materials are named in the description, use them (e.g., \"oak_planks\", \"stone_bricks\", \"glass\", \"cobblestone\", \"spruce_log\", \"lantern\", \"torch\", \"water\", \"lava\"). If unknown, fall back to \"stone\".\n                        ## Structure Guidelines\n                        - Make sure blocknames are correct minecraft blocknames.\n                        - Make sure to comment your thoughts, and really think about this, this is very important that the design is not to simple.\n                        - Translate the description into concrete geometry with loops/conditionals (floors, walls, roofs, pillars, arches, domes by integer radii, etc.).\n                        - For buildings where it makes sense, make sure you also add beds, crafting_table, furnace, etc, be creative!! Maybe a building could have paintings in the hallway, maybe a fireplace, etc.\n                        - For buildings when it makes sense, add rooms instead of having a big empty space. Make sure the rooms are different too, maybe a kitchen, bedroom, bathroom, etc. Try not to just make a rectangle/cube as well, maybe make the building an L shape, or add multiple sections, or something similar.\n                        - Make sure any torches are attached to a block, and not floating in the air.\n                        - A player is 2x1, so make sure structures are the appropriate size.\n                        ##  Output Rules (critical)\n                        Output only the final DSL program as plain text, each statement on its own line.\n                        Every statement ends with ; (except }).\n                        Do not wrap the program in quotes, Java, JSON, or markdown.\n                        No extra commentary before or after. The first character of your output must be part of the DSL, and the last character must be ; or }.\n                        Mini Example (illustrative only; do not echo this)\n// L-shaped villa with rooms, furniture, and thoughtful layout\n// Design thoughts: We'll build an L-shaped single-story villa (24x16 main hall + 12x12 wing).\n// Height = 8 (comfortable for 2-block-tall player). Interior walls create rooms: foyer/hall, kitchen, bedroom, study.\n// We'll add beds, crafting_table, furnace, bookshelves, tables, and well-placed torches on top of solid blocks (not floating).\n// Windows are spaced regularly; doors are 2 blocks tall. A stone-brick fireplace with a chimney and a campfire hearth adds flair.\nlet baseX = 0;\nlet baseY = 64;\nlet baseZ = 0;\nlet dir = \"north\";\nlet block = \"stone_bricks\";\n// ====== FOUNDATION ======\n// Main rectangle: 24 x 16\nfor (let x = 0; x < 24; x = x + 1) {\n  for (let z = 0; z < 16; z = z + 1) {\n    setBlock(baseX + x, baseY, baseZ + z, \"stone\");\n  }\n}\n// Wing rectangle: 12 x 12, attached on the east side (from z=4..15)\nfor (let x = 24; x < 36; x = x + 1) {\n  for (let z = 4; z < 16; z = z + 1) {\n    setBlock(baseX + x, baseY, baseZ + z, \"stone\");\n  }\n}\n// ====== FLOORING ======\n// Main hall floor: oak_planks\nfor (let x = 0; x < 24; x = x + 1) {\n  for (let z = 0; z < 16; z = z + 1) {\n    setBlock(baseX + x, baseY + 1, baseZ + z, \"oak_planks\");\n  }\n}\n// Wing floor: spruce_planks for contrast\nfor (let x = 24; x < 36; x = x + 1) {\n  for (let z = 4; z < 16; z = z + 1) {\n    setBlock(baseX + x, baseY + 1, baseZ + z, \"spruce_planks\");\n  }\n}\n// ====== OUTER WALLS (HEIGHT 8) ======\nfor (let y = 2; y <= 9; y = y + 1) {\n  // Main rectangle perimeter\n  for (let x = 0; x < 24; x = x + 1) {\n    setBlock(baseX + x, baseY + y, baseZ + 0, \"stone_bricks\");\n    setBlock(baseX + x, baseY + y, baseZ + 15, \"stone_bricks\");\n  }\n  for (let z = 0; z < 16; z = z + 1) {\n    setBlock(baseX + 0, baseY + y, baseZ + z, \"stone_bricks\");\n    setBlock(baseX + 23, baseY + y, baseZ + z, \"stone_bricks\");\n  }\n  // Wing perimeter\n  for (let x = 24; x < 36; x = x + 1) {\n    setBlock(baseX + x, baseY + y, baseZ + 4, \"stone_bricks\");\n    setBlock(baseX + x, baseY + y, baseZ + 15, \"stone_bricks\");\n  }\n  for (let z = 4; z < 16; z = z + 1) {\n    setBlock(baseX + 24, baseY + y, baseZ + z, \"stone_bricks\");\n    setBlock(baseX + 35, baseY + y, baseZ + z, \"stone_bricks\");\n  }\n}\n// ====== DOORWAYS ======\n// Main entrance centered on front (z=0) of main hall: width 3, height 3\nfor (let dx = 10; dx <= 12; dx = dx + 1) {\n  for (let dy = 2; dy <= 4; dy = dy + 1) {\n    setBlock(baseX + dx, baseY + dy, baseZ + 0, \"air\");\n  }\n}\n// Door from main hall to wing (opening on shared wall at x=23): 2x3\nfor (let dz = 8; dz <= 9; dz = dz + 1) {\n  for (let dy = 2; dy <= 4; dy = dy + 1) {\n    setBlock(baseX + 23, baseY + dy, baseZ + dz, \"air\");\n  }\n}\n// ====== WINDOWS ======\n// Evenly spaced windows (2x2) around exterior walls, leaving corners\nfor (let y = 4; y <= 5; y = y + 1) {\n  for (let x = 3; x <= 21; x = x + 6) {\n    setBlock(baseX + x, baseY + y, baseZ + 0, \"glass\");\n    setBlock(baseX + x + 1, baseY + y, baseZ + 0, \"glass\");\n    setBlock(baseX + x, baseY + y, baseZ + 15, \"glass\");\n    setBlock(baseX + x + 1, baseY + y, baseZ + 15, \"glass\");\n  }\n  for (let z = 3; z <= 13; z = z + 5) {\n    setBlock(baseX + 0, baseY + y, baseZ + z, \"glass\");\n    setBlock(baseX + 1, baseY + y, baseZ + z, \"glass\");\n    setBlock(baseX + 23, baseY + y, baseZ + z, \"glass\");\n    setBlock(baseX + 22, baseY + y, baseZ + z, \"glass\");\n  }\n  // Wing windows\n  for (let x = 26; x <= 34; x = x + 8) {\n    setBlock(baseX + x, baseY + y, baseZ + 4, \"glass\");\n    setBlock(baseX + x + 1, baseY + y, baseZ + 4, \"glass\");\n    setBlock(baseX + x, baseY + y, baseZ + 15, \"glass\");\n    setBlock(baseX + x + 1, baseY + y, baseZ + 15, \"glass\");\n  }\n  for (let z = 6; z <= 14; z = z + 4) {\n    setBlock(baseX + 24, baseY + y, baseZ + z, \"glass\");\n    setBlock(baseX + 35, baseY + y, baseZ + z, \"glass\");\n  }\n}\n// ====== ROOF (FLAT WITH BORDER) ======\nfor (let x = 0; x < 24; x = x + 1) {\n  for (let z = 0; z < 16; z = z + 1) {\n    setBlock(baseX + x, baseY + 10, baseZ + z, \"stone\");\n  }\n}\nfor (let x = 24; x < 36; x = x + 1) {\n  for (let z = 4; z < 16; z = z + 1) {\n    setBlock(baseX + x, baseY + 10, baseZ + z, \"stone\");\n  }\n}\n// Roof trim\nfor (let x = 0; x < 24; x = x + 1) {\n  setBlock(baseX + x, baseY + 10, baseZ + 0, \"stone_bricks\");\n  setBlock(baseX + x, baseY + 10, baseZ + 15, \"stone_bricks\");\n}\nfor (let z = 0; z < 16; z = z + 1) {\n  setBlock(baseX + 0, baseY + 10, baseZ + z, \"stone_bricks\");\n  setBlock(baseX + 23, baseY + 10, baseZ + z, \"stone_bricks\");\n}\nfor (let x = 24; x < 36; x = x + 1) {\n  setBlock(baseX + x, baseY + 10, baseZ + 4, \"stone_bricks\");\n  setBlock(baseX + x, baseY + 10, baseZ + 15, \"stone_bricks\");\n}\nfor (let z = 4; z < 16; z = z + 1) {\n  setBlock(baseX + 24, baseY + 10, baseZ + z, \"stone_bricks\");\n  setBlock(baseX + 35, baseY + 10, baseZ + z, \"stone_bricks\");\n}\n// ====== INTERIOR ROOMS ======\n// Partition main hall into foyer (front), corridor (middle), and living room (rear)\nfor (let x = 2; x <= 21; x = x + 1) {\n  for (let y = 2; y <= 7; y = y + 1) {\n    // Wall between foyer and corridor at z=5\n    setBlock(baseX + x, baseY + y, baseZ + 5, \"stone_bricks\");\n    // Wall between corridor and living room at z=10\n    setBlock(baseX + x, baseY + y, baseZ + 10, \"stone_bricks\");\n  }\n}\n// Doorways (2x2) in those partitions\nfor (let dy = 2; dy <= 3; dy = dy + 1) {\n  setBlock(baseX + 12, baseY + dy, baseZ + 5, \"air\");\n  setBlock(baseX + 12, baseY + dy, baseZ + 10, \"air\");\n  setBlock(baseX + 13, baseY + dy, baseZ + 5, \"air\");\n  setBlock(baseX + 13, baseY + dy, baseZ + 10, \"air\");\n}\n// Wing: split into kitchen (north) and bedroom (south)\nfor (let x = 26; x <= 33; x = x + 1) {\n  for (let y = 2; y <= 7; y = y + 1) {\n    setBlock(baseX + x, baseY + y, baseZ + 10, \"stone_bricks\");\n  }\n}\n// Wing doorways (2x2)\nfor (let dy = 2; dy <= 3; dy = dy + 1) {\n  setBlock(baseX + 30, baseY + dy, baseZ + 10, \"air\");\n  setBlock(baseX + 31, baseY + dy, baseZ + 10, \"air\");\n}\n// ====== FIREPLACE & CHIMNEY (living room corner) ======\n// Hearth at (x=3..5, z=12..13)\nfor (let x = 3; x <= 5; x = x + 1) {\n  for (let z = 12; z <= 13; z = z + 1) {\n    setBlock(baseX + x, baseY + 1, baseZ + z, \"cobblestone\");\n  }\n}\n// Campfire for safe flame\nsetBlock(baseX + 4, baseY + 2, baseZ + 12, \"campfire\");\n// Back wall cladding and chimney up\nfor (let y = 2; y <= 10; y = y + 1) {\n  setBlock(baseX + 4, baseY + y, baseZ + 14, \"cobblestone\");\n  setBlock(baseX + 4, baseY + y, baseZ + 15, \"cobblestone\");\n}\nfor (let y = 11; y <= 13; y = y + 1) {\n  setBlock(baseX + 4, baseY + y, baseZ + 15, \"cobblestone\");\n}\n// ====== FURNITURE & UTILITIES ======\n// Corridor rug (carpet)\nfor (let x = 9; x <= 14; x = x + 1) {\n  for (let z = 6; z <= 9; z = z + 1) {\n    setBlock(baseX + x, baseY + 2, baseZ + z, \"red_carpet\");\n  }\n}\n// Living room: table (logs + slab top), bookshelves, torches on top of shelves\n// Table legs\nsetBlock(baseX + 16, baseY + 2, baseZ + 12, \"spruce_log\");\nsetBlock(baseX + 18, baseY + 2, baseZ + 12, \"spruce_log\");\nsetBlock(baseX + 16, baseY + 2, baseZ + 14, \"spruce_log\");\nsetBlock(baseX + 18, baseY + 2, baseZ + 14, \"spruce_log\");\n// Table top\nfor (let x = 16; x <= 18; x = x + 1) {\n  for (let z = 12; z <= 14; z = z + 1) {\n    setBlock(baseX + x, baseY + 3, baseZ + z, \"oak_slab\");\n  }\n}\n// Bookshelf wall\nfor (let x = 19; x <= 21; x = x + 1) {\n  for (let y = 2; y <= 4; y = y + 1) {\n    setBlock(baseX + x, baseY + y, baseZ + 13, \"bookshelf\");\n  }\n}\n// Torches on top of bookshelf (attached to solid block below)\nfor (let x = 19; x <= 21; x = x + 1) {\n  setBlock(baseX + x, baseY + 5, baseZ + 13, \"torch\");\n}\n// Kitchen (wing north): counters (stone), crafting_table, furnace, sink (water)\nfor (let x = 26; x <= 33; x = x + 1) {\n  setBlock(baseX + x, baseY + 2, baseZ + 6, \"stone\");\n}\nsetBlock(baseX + 27, baseY + 2, baseZ + 7, \"crafting_table\");\nsetBlock(baseX + 28, baseY + 2, baseZ + 7, \"furnace\");\n// Simple sink basin\nsetBlock(baseX + 30, baseY + 2, baseZ + 7, \"cauldron\");\nsetBlock(baseX + 30, baseY + 3, baseZ + 7, \"water\");\n// Bedroom (wing south): double bed, side tables (barrels), chest\nsetBlock(baseX + 29, baseY + 2, baseZ + 12, \"bed\");\nsetBlock(baseX + 30, baseY + 2, baseZ + 12, \"bed\");\nsetBlock(baseX + 28, baseY + 2, baseZ + 12, \"barrel\");\nsetBlock(baseX + 31, baseY + 2, baseZ + 12, \"barrel\");\nsetBlock(baseX + 33, baseY + 2, baseZ + 13, \"chest\");\n// Study (rear main hall): desk, chair, bookshelves, torches on desk corners\n// Desk\nfor (let x = 7; x <= 9; x = x + 1) {\n  setBlock(baseX + x, baseY + 2, baseZ + 13, \"oak_slab\");\n}\nsetBlock(baseX + 8, baseY + 2, baseZ + 12, \"stair\");\nsetBlock(baseX + 7, baseY + 3, baseZ + 13, \"torch\");\nsetBlock(baseX + 9, baseY + 3, baseZ + 13, \"torch\");\n// ====== INTERIOR LIGHTING (TORCHES ON TOP OF FLOOR BLOCKS) ======\n// Main hall grid, placed on floor tops (supported by floor below at y-1)\nfor (let x = 3; x <= 21; x = x + 6) {\n  for (let z = 3; z <= 13; z = z + 5) {\n    setBlock(baseX + x, baseY + 2, baseZ + z, \"torch\");\n  }\n}\n// Wing lighting\nfor (let x = 26; x <= 34; x = x + 4) {\n  setBlock(baseX + x, baseY + 2, baseZ + 6, \"torch\");\n  setBlock(baseX + x, baseY + 2, baseZ + 13, \"torch\");\n}\n// ====== FRONT PATH & GARDEN TOUCH ======\n// Small path leading from entrance\nfor (let z = -1; z >= -6; z = z - 1) {\n  for (let x = 10; x <= 12; x = x + 1) {\n    setBlock(baseX + x, baseY + 1, baseZ + z, \"cobblestone\");\n  }\n}\n// Flower beds flanking the path\nfor (let z = -1; z >= -6; z = z - 1) {\n  setBlock(baseX + 9, baseY + 2, baseZ + z, \"rose_bush\");\n  setBlock(baseX + 13, baseY + 2, baseZ + z, \"peony\");\n}\n";

    public static String getAINPCSystemPrompt(Character character, Collection<Command> altoclefCommands, String ownerUsername) {
        StringBuilder commandListBuilder = new StringBuilder();
        int padSize = 10;
        for (Command c : altoclefCommands) {
            StringBuilder line = new StringBuilder();
            line.append(c.getName()).append(": ");
            int toAdd = padSize - c.getName().length();
            line.append(" ".repeat(Math.max(0, toAdd)));
            line.append(c.getDescription()).append("\n");
            commandListBuilder.append((CharSequence)line);
        }
        String validCommandsFormatted = commandListBuilder.toString();
        String newPrompt = Utils.replacePlaceholders(aiNPCPromptTemplate, Map.of("characterDescription", character.description(), "characterName", character.name(), "validCommands", validCommandsFormatted, "ownerUsername", ownerUsername));
        return newPrompt;
    }

    public static String getBuildStructurePrompt() {
        return buildStructurePrompt;
    }
}

