/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.player2.playerengine.player2api.utils.HttpApiException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class HTTPUtils {
    public static Map<String, JsonElement> sendRequest(String baseUrl, String endpoint, boolean postRequest, JsonObject requestBody, @Nullable Map<String, String> extraHeaders) throws Exception {
        URL url = new URI(baseUrl + endpoint).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(postRequest ? "POST" : "GET");
        connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        if (extraHeaders != null) {
            for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (postRequest && requestBody != null) {
            connection.setDoOutput(true);
            try (OutputStream os2 = connection.getOutputStream();){
                byte[] input = requestBody.toString().getBytes(StandardCharsets.UTF_8);
                os2.write(input, 0, input.length);
            }
            catch (Throwable os2) {
                // empty catch block
            }
        }
        JsonObject jsonResponse = HTTPUtils.getJsonObject(connection);
        HashMap<String, JsonElement> responseMap = new HashMap<String, JsonElement>();
        for (Map.Entry entry : jsonResponse.entrySet()) {
            responseMap.put((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return responseMap;
    }

    private static JsonObject getJsonObject(HttpURLConnection connection) throws IOException {
        String line;
        int responseCode = connection.getResponseCode();
        if (responseCode >= 400) {
            String line2;
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
            StringBuilder errorResponse = new StringBuilder();
            while ((line2 = errorReader.readLine()) != null) {
                errorResponse.append(line2);
            }
            errorReader.close();
            throw new HttpApiException("HTTP " + responseCode + ": " + connection.getResponseMessage() + " Body: " + String.valueOf(errorResponse), responseCode);
        }
        if (responseCode != 200) {
            throw new IOException("HTTP " + responseCode + ": " + connection.getResponseMessage());
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
        }
        reader.close();
        return JsonParser.parseString((String)response.toString()).getAsJsonObject();
    }
}

