/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction.build_structure;

import com.player2.playerengine.PlayerEngineController;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureFromCode {
    public static final Logger LOGGER = LogManager.getLogger();

    public static Program compile(String source) {
        Lexer lex = new Lexer(source);
        List<Token> tokens = lex.lex();
        Parser parser = new Parser(tokens);
        List<Stmt> stmts = parser.parse();
        return new Program(stmts);
    }

    public static void runCode(String code, Consumer<SetBlockCommand> onSetBlock, PlayerEngineController mod) throws Exception {
        Optional<SetBlockCommand> cmd;
        Program program = StructureFromCode.compile(code);
        Runner runner = new Runner(program);
        while ((cmd = runner.next()).isPresent()) {
            if (mod.isStopping) {
                return;
            }
            SetBlockCommand data = cmd.get();
            onSetBlock.accept(data);
        }
    }

    public static void buildStructureFromCode(String code, Consumer<SetBlockCommand> onSetBlock, Consumer<String> onErrString, Runnable onFinishSuccess, PlayerEngineController mod) {
        try {
            StructureFromCode.runCode(code, _unused -> {}, mod);
            LOGGER.info("Code validated, running code for real now.");
            StructureFromCode.runCode(code, onSetBlock, mod);
            onFinishSuccess.run();
        }
        catch (Exception e) {
            String err = e.getMessage();
            String error = err == null ? "unknown error" : err;
            LOGGER.error("LLM build structure err={} ", (Object)error);
            onErrString.accept(error);
        }
    }

    static final class Lexer {
        private final String src;
        private final List<Token> tokens = new ArrayList<Token>();
        private int start = 0;
        private int current = 0;
        private int line = 1;
        private int col = 1;
        private static final Map<String, TokenType> keywords = new HashMap<String, TokenType>();

        Lexer(String src) {
            this.src = src;
        }

        List<Token> lex() {
            while (!this.isAtEnd()) {
                this.start = this.current;
                this.scanToken();
            }
            this.tokens.add(new Token(TokenType.EOF, "", null, this.line, this.col));
            return this.tokens;
        }

        private void scanToken() {
            char c = this.advance();
            switch (c) {
                case '(': {
                    this.add(TokenType.LEFT_PAREN);
                    break;
                }
                case ')': {
                    this.add(TokenType.RIGHT_PAREN);
                    break;
                }
                case '{': {
                    this.add(TokenType.LEFT_BRACE);
                    break;
                }
                case '}': {
                    this.add(TokenType.RIGHT_BRACE);
                    break;
                }
                case ',': {
                    this.add(TokenType.COMMA);
                    break;
                }
                case '.': {
                    this.add(TokenType.DOT);
                    break;
                }
                case '-': {
                    this.add(TokenType.MINUS);
                    break;
                }
                case '+': {
                    this.add(TokenType.PLUS);
                    break;
                }
                case ';': {
                    this.add(TokenType.SEMICOLON);
                    break;
                }
                case '*': {
                    this.add(TokenType.STAR);
                    break;
                }
                case '%': {
                    this.add(TokenType.PERCENT);
                    break;
                }
                case '!': {
                    this.add(this.match('=') ? TokenType.BANG_EQUAL : TokenType.BANG);
                    break;
                }
                case '=': {
                    this.add(this.match('=') ? TokenType.EQUAL_EQUAL : TokenType.EQUAL);
                    break;
                }
                case '<': {
                    this.add(this.match('=') ? TokenType.LESS_EQUAL : TokenType.LESS);
                    break;
                }
                case '>': {
                    this.add(this.match('=') ? TokenType.GREATER_EQUAL : TokenType.GREATER);
                    break;
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\n': {
                    ++this.line;
                    this.col = 0;
                    break;
                }
                case '\"': {
                    this.string();
                    break;
                }
                case '&': {
                    if (this.match('&')) {
                        this.add(TokenType.AND_AND);
                        break;
                    }
                    this.error("Unexpected character: & (did you mean &&?)");
                    break;
                }
                case '|': {
                    if (this.match('|')) {
                        this.add(TokenType.OR_OR);
                        break;
                    }
                    this.error("Unexpected character: | (did you mean ||?)");
                    break;
                }
                case '?': {
                    this.add(TokenType.QUESTION);
                    break;
                }
                case ':': {
                    this.add(TokenType.COLON);
                    break;
                }
                case '/': {
                    if (this.match('/')) {
                        while (!this.isAtEnd() && this.peek() != '\n') {
                            this.advance();
                        }
                        break;
                    }
                    if (this.match('*')) {
                        while (!(this.isAtEnd() || this.peek() == '*' && this.peekNext() == '/')) {
                            if (this.peek() == '\n') {
                                ++this.line;
                                this.col = 0;
                            }
                            this.advance();
                        }
                        if (this.isAtEnd()) break;
                        this.advance();
                        this.advance();
                        break;
                    }
                    this.add(TokenType.SLASH);
                    break;
                }
                default: {
                    if (Lexer.isDigit(c)) {
                        this.number();
                        break;
                    }
                    if (Lexer.isAlpha(c)) {
                        this.identifier();
                        break;
                    }
                    this.error("Unexpected character: " + c);
                }
            }
        }

        private void string() {
            StringBuilder sb = new StringBuilder();
            while (!this.isAtEnd() && this.peek() != '\"') {
                char c = this.advance();
                if (c == '\\') {
                    if (this.isAtEnd()) break;
                    char n = this.advance();
                    switch (n) {
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case '\"': {
                            sb.append('\"');
                            break;
                        }
                        case '\\': {
                            sb.append('\\');
                            break;
                        }
                        default: {
                            sb.append(n);
                            break;
                        }
                    }
                } else {
                    sb.append(c);
                }
                if (c != '\n') continue;
                ++this.line;
                this.col = 0;
            }
            if (this.isAtEnd()) {
                this.error("Unterminated string.");
            }
            this.advance();
            this.add(TokenType.STRING, sb.toString());
        }

        private void number() {
            while (Lexer.isDigit(this.peek())) {
                this.advance();
            }
            if (this.peek() == '.' && Lexer.isDigit(this.peekNext())) {
                this.advance();
                while (Lexer.isDigit(this.peek())) {
                    this.advance();
                }
            }
            double val = Double.parseDouble(this.src.substring(this.start, this.current));
            this.add(TokenType.NUMBER, val);
        }

        private void identifier() {
            while (Lexer.isAlphaNumeric(this.peek())) {
                this.advance();
            }
            String text = this.src.substring(this.start, this.current);
            TokenType type = keywords.get(text);
            if ("setBlock".equals(text)) {
                type = TokenType.SETBLOCK;
            }
            if (type == null) {
                type = TokenType.IDENTIFIER;
            }
            this.add(type);
        }

        private void add(TokenType type) {
            this.add(type, null);
        }

        private void add(TokenType type, Object lit) {
            this.tokens.add(new Token(type, this.src.substring(this.start, this.current), lit, this.line, this.col));
        }

        private boolean match(char expected) {
            if (this.isAtEnd() || this.src.charAt(this.current) != expected) {
                return false;
            }
            this.advance();
            return true;
        }

        private char peek() {
            return this.isAtEnd() ? (char)'\u0000' : this.src.charAt(this.current);
        }

        private char peekNext() {
            return this.current + 1 >= this.src.length() ? (char)'\u0000' : this.src.charAt(this.current + 1);
        }

        private char advance() {
            ++this.current;
            ++this.col;
            return this.src.charAt(this.current - 1);
        }

        private boolean isAtEnd() {
            return this.current >= this.src.length();
        }

        private static boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        private static boolean isAlpha(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
        }

        private static boolean isAlphaNumeric(char c) {
            return Lexer.isAlpha(c) || Lexer.isDigit(c);
        }

        private void error(String msg) {
            throw new RuntimeException("[Lexer] line " + this.line + ", col " + this.col + ": " + msg);
        }

        static {
            keywords.put("let", TokenType.LET);
            keywords.put("if", TokenType.IF);
            keywords.put("else", TokenType.ELSE);
            keywords.put("while", TokenType.WHILE);
            keywords.put("for", TokenType.FOR);
            keywords.put("true", TokenType.TRUE);
            keywords.put("false", TokenType.FALSE);
            keywords.put("nil", TokenType.NIL);
        }
    }

    static final class Parser {
        private final List<Token> tokens;
        private int current = 0;

        Parser(List<Token> tokens) {
            this.tokens = tokens;
        }

        List<Stmt> parse() {
            ArrayList<Stmt> stmts = new ArrayList<Stmt>();
            while (!this.isAtEnd()) {
                stmts.add(this.declaration());
            }
            return stmts;
        }

        private Stmt declaration() {
            if (this.match(TokenType.LET)) {
                return this.varDeclaration();
            }
            return this.statement();
        }

        private Stmt varDeclaration() {
            Token name = this.consume(TokenType.IDENTIFIER, "Expect variable name.");
            Expr init = null;
            if (this.match(TokenType.EQUAL)) {
                init = this.expression();
            }
            this.consume(TokenType.SEMICOLON, "Expect ';' after variable declaration.");
            return new Var(name, init == null ? new Literal(null) : init);
        }

        private Stmt statement() {
            if (this.match(TokenType.LEFT_BRACE)) {
                return new Block(this.block());
            }
            if (this.match(TokenType.IF)) {
                return this.ifStatement();
            }
            if (this.match(TokenType.WHILE)) {
                return this.whileStatement();
            }
            if (this.match(TokenType.FOR)) {
                return this.forStatement();
            }
            if (this.match(TokenType.SETBLOCK)) {
                return this.setBlockStatement();
            }
            return this.exprStatement();
        }

        private Stmt setBlockStatement() {
            this.consume(TokenType.LEFT_PAREN, "Expect '(' after setBlock.");
            Expr x = this.expression();
            this.consume(TokenType.COMMA, "Expect ',' after x.");
            Expr y = this.expression();
            this.consume(TokenType.COMMA, "Expect ',' after y.");
            Expr z = this.expression();
            this.consume(TokenType.COMMA, "Expect ',' after z.");
            Expr block = this.expression();
            this.consume(TokenType.RIGHT_PAREN, "Expect ')' after arguments.");
            this.consume(TokenType.SEMICOLON, "Expect ';' after setBlock.");
            return new SetBlock(x, y, z, block);
        }

        private Stmt ifStatement() {
            this.consume(TokenType.LEFT_PAREN, "Expect '(' after if.");
            Expr cond = this.expression();
            this.consume(TokenType.RIGHT_PAREN, "Expect ')' after condition.");
            Stmt thenB = this.statement();
            Stmt elseB = null;
            if (this.match(TokenType.ELSE)) {
                elseB = this.statement();
            }
            return new If(cond, thenB, elseB);
        }

        private Stmt whileStatement() {
            this.consume(TokenType.LEFT_PAREN, "Expect '(' after while.");
            Expr cond = this.expression();
            this.consume(TokenType.RIGHT_PAREN, "Expect ')' after condition.");
            Stmt body = this.statement();
            return new While(cond, body);
        }

        private Stmt forStatement() {
            Stmt init;
            this.consume(TokenType.LEFT_PAREN, "Expect '(' after for.");
            if (this.match(TokenType.SEMICOLON)) {
                init = null;
            } else if (this.match(TokenType.LET)) {
                init = this.varDeclarationNoSemi();
                this.consume(TokenType.SEMICOLON, "Expect ';' after for init.");
            } else {
                init = this.exprStatementNoSemi();
                this.consume(TokenType.SEMICOLON, "Expect ';' after for init.");
            }
            Expr cond = null;
            if (!this.check(TokenType.SEMICOLON)) {
                cond = this.expression();
            }
            this.consume(TokenType.SEMICOLON, "Expect ';' after loop condition.");
            Stmt inc = null;
            if (!this.check(TokenType.RIGHT_PAREN)) {
                inc = this.exprStatementNoSemi();
            }
            this.consume(TokenType.RIGHT_PAREN, "Expect ')' after for clauses.");
            Stmt body = this.statement();
            if (inc != null) {
                body = new Block(Arrays.asList(body, inc));
            }
            if (cond == null) {
                cond = new Literal(true);
            }
            Stmt whileStmt = new While(cond, body);
            if (init != null) {
                whileStmt = new Block(Arrays.asList(init, whileStmt));
            }
            return whileStmt;
        }

        private Stmt exprStatement() {
            Expr e = this.expression();
            this.consume(TokenType.SEMICOLON, "Expect ';' after expression.");
            return new ExprStmt(e);
        }

        private Stmt exprStatementNoSemi() {
            Expr e = this.expression();
            return new ExprStmt(e);
        }

        private Stmt varDeclarationNoSemi() {
            Token name = this.consume(TokenType.IDENTIFIER, "Expect variable name.");
            Expr init = null;
            if (this.match(TokenType.EQUAL)) {
                init = this.expression();
            }
            return new Var(name, init == null ? new Literal(null) : init);
        }

        private List<Stmt> block() {
            ArrayList<Stmt> stmts = new ArrayList<Stmt>();
            while (!this.check(TokenType.RIGHT_BRACE) && !this.isAtEnd()) {
                stmts.add(this.declaration());
            }
            this.consume(TokenType.RIGHT_BRACE, "Expect '}' after block.");
            return stmts;
        }

        private Expr expression() {
            return this.assignment();
        }

        private Expr assignment() {
            Expr expr = this.conditional();
            if (this.match(TokenType.EQUAL)) {
                Token equals = this.previous();
                Expr value = this.assignment();
                if (expr instanceof Variable) {
                    Token name = ((Variable)expr).name;
                    return new Assign(name, value);
                }
                this.error(equals, "Invalid assignment target.");
            }
            return expr;
        }

        private Expr conditional() {
            Expr expr = this.or();
            if (this.match(TokenType.QUESTION)) {
                Expr thenExpr = this.expression();
                this.consume(TokenType.COLON, "Expect ':' in ternary expression.");
                Expr elseExpr = this.conditional();
                expr = new Conditional(expr, thenExpr, elseExpr);
            }
            return expr;
        }

        private Expr or() {
            Expr expr = this.and();
            while (this.match(TokenType.OR_OR)) {
                Token op = this.previous();
                Expr right = this.and();
                expr = new Binary(expr, op, right);
            }
            return expr;
        }

        private Expr and() {
            Expr expr = this.equality();
            while (this.match(TokenType.AND_AND)) {
                Token op = this.previous();
                Expr right = this.equality();
                expr = new Binary(expr, op, right);
            }
            return expr;
        }

        private Expr equality() {
            Expr expr = this.comparison();
            while (this.match(TokenType.BANG_EQUAL, TokenType.EQUAL_EQUAL)) {
                Token op = this.previous();
                Expr right = this.comparison();
                expr = new Binary(expr, op, right);
            }
            return expr;
        }

        private Expr comparison() {
            Expr expr = this.term();
            while (this.match(TokenType.GREATER, TokenType.GREATER_EQUAL, TokenType.LESS, TokenType.LESS_EQUAL)) {
                Token op = this.previous();
                Expr right = this.term();
                expr = new Binary(expr, op, right);
            }
            return expr;
        }

        private Expr term() {
            Expr expr = this.factor();
            while (this.match(TokenType.PLUS, TokenType.MINUS)) {
                Token op = this.previous();
                Expr right = this.factor();
                expr = new Binary(expr, op, right);
            }
            return expr;
        }

        private Expr factor() {
            Expr expr = this.unary();
            while (this.match(TokenType.STAR, TokenType.SLASH, TokenType.PERCENT)) {
                Token op = this.previous();
                Expr right = this.unary();
                expr = new Binary(expr, op, right);
            }
            return expr;
        }

        private Expr unary() {
            if (this.match(TokenType.BANG, TokenType.MINUS)) {
                Token op = this.previous();
                Expr right = this.unary();
                return new Unary(op, right);
            }
            return this.primary();
        }

        private Expr primary() {
            if (this.match(TokenType.FALSE)) {
                return new Literal(false);
            }
            if (this.match(TokenType.TRUE)) {
                return new Literal(true);
            }
            if (this.match(TokenType.NIL)) {
                return new Literal(null);
            }
            if (this.match(TokenType.NUMBER)) {
                return new Literal(this.previous().literal);
            }
            if (this.match(TokenType.STRING)) {
                return new Literal(this.previous().literal);
            }
            if (this.match(TokenType.IDENTIFIER)) {
                return new Variable(this.previous());
            }
            if (this.match(TokenType.LEFT_PAREN)) {
                Expr e = this.expression();
                this.consume(TokenType.RIGHT_PAREN, "Expect ')' after expression.");
                return new Grouping(e);
            }
            this.error(this.peek(), "Expect expression.");
            return null;
        }

        private boolean match(TokenType ... types) {
            for (TokenType t : types) {
                if (!this.check(t)) continue;
                this.advance();
                return true;
            }
            return false;
        }

        private boolean check(TokenType t) {
            return !this.isAtEnd() && this.peek().type == t;
        }

        private Token advance() {
            if (!this.isAtEnd()) {
                ++this.current;
            }
            return this.previous();
        }

        private boolean isAtEnd() {
            return this.peek().type == TokenType.EOF;
        }

        private Token peek() {
            return this.tokens.get(this.current);
        }

        private Token previous() {
            return this.tokens.get(this.current - 1);
        }

        private Token consume(TokenType t, String msg) {
            if (this.check(t)) {
                return this.advance();
            }
            this.error(this.peek(), msg);
            return null;
        }

        private void error(Token t, String msg) {
            throw new RuntimeException("[Parser] line " + t.line + ", col " + t.col + ": " + msg + " Found '" + t.lexeme + "'");
        }
    }

    public static final class Program {
        final List<Stmt> statements;

        Program(List<Stmt> statements) {
            this.statements = statements;
        }
    }

    public static final class Runner {
        private final Interpreter interp;
        private final Queue<SetBlockCommand> queue = new ArrayDeque<SetBlockCommand>();
        private boolean done = false;

        public Runner(Program program) {
            this.interp = new Interpreter(program, this.queue::add);
        }

        public Optional<SetBlockCommand> next() {
            if (this.done && this.queue.isEmpty()) {
                return Optional.empty();
            }
            if (!this.queue.isEmpty()) {
                return Optional.of(this.queue.poll());
            }
            while (this.queue.isEmpty() && !this.done) {
                this.done = !this.interp.step();
            }
            return this.queue.isEmpty() ? Optional.empty() : Optional.of(this.queue.poll());
        }
    }

    public static final class SetBlockCommand {
        public final int x;
        public final int y;
        public final int z;
        public final String blockName;

        public SetBlockCommand(int x, int y, int z, String blockName) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.blockName = blockName;
        }

        public String toString() {
            return "setBlock(" + this.x + ", " + this.y + ", " + this.z + ", \"" + this.blockName + "\")";
        }
    }

    static final class Env {
        private final Env enclosing;
        private final Map<String, Object> values = new HashMap<String, Object>();

        Env(Env enclosing) {
            this.enclosing = enclosing;
        }

        void define(String name, Object value) {
            this.values.put(name, value);
        }

        Object get(Token nameTok) {
            String name = nameTok.lexeme;
            if (this.values.containsKey(name)) {
                return this.values.get(name);
            }
            if (this.enclosing != null) {
                return this.enclosing.get(nameTok);
            }
            throw new RuntimeException("Undefined variable '" + name + "'.");
        }

        void assign(Token nameTok, Object value) {
            String name = nameTok.lexeme;
            if (this.values.containsKey(name)) {
                this.values.put(name, value);
                return;
            }
            if (this.enclosing != null) {
                this.enclosing.assign(nameTok, value);
                return;
            }
            throw new RuntimeException("Undefined variable '" + name + "'.");
        }
    }

    static final class Interpreter
    implements ExprVisitor<Object>,
    StmtVisitor {
        private final Program program;
        private final Emitter emitter;
        private final Deque<Env> envStack = new ArrayDeque<Env>();
        private final Deque<Frame> frames = new ArrayDeque<Frame>();
        private boolean initialized = false;
        private int emittedCount = 0;

        Interpreter(Program program, Emitter emitter) {
            this.program = program;
            this.emitter = emitter;
            this.envStack.push(new Env(null));
        }

        boolean step() {
            if (!this.initialized) {
                this.frames.push(new Frame(this.program.statements));
                this.initialized = true;
            }
            while (!this.frames.isEmpty()) {
                Frame f = this.frames.peek();
                if (f instanceof WhileFrame) {
                    WhileFrame wf = (WhileFrame)f;
                    if (Interpreter.isTruthy(this.evaluate(wf.condition))) {
                        this.frames.push(new Frame(Interpreter.singleton(wf.body)));
                        continue;
                    }
                    this.frames.pop();
                    continue;
                }
                if (f.ip >= f.stmts.size()) {
                    this.frames.pop();
                    if (f.onClose == null) continue;
                    f.onClose.run();
                    continue;
                }
                Stmt s = f.stmts.get(f.ip++);
                int emittedBefore = this.emittedCount;
                s.accept(this);
                if (this.emittedCount <= emittedBefore) continue;
                return true;
            }
            return false;
        }

        private void emit(SetBlockCommand cmd) {
            ++this.emittedCount;
            this.emitter.emit(cmd);
        }

        @Override
        public void visitExprStmt(ExprStmt s) {
            this.evaluate(s.expr);
        }

        @Override
        public void visitPrintStmt(PrintStmt s) {
            System.out.println(Interpreter.stringify(this.evaluate(s.expr)));
        }

        @Override
        public void visitVarStmt(Var s) {
            Object val = this.evaluate(s.initializer);
            this.env().define(s.name.lexeme, val);
        }

        @Override
        public void visitBlockStmt(Block s) {
            this.pushEnv();
            this.frames.push(new Frame(s.statements, () -> this.popEnv()));
        }

        @Override
        public void visitIfStmt(If s) {
            if (Interpreter.isTruthy(this.evaluate(s.condition))) {
                this.frames.push(new Frame(Interpreter.singleton(s.thenBranch)));
            } else if (s.elseBranch != null) {
                this.frames.push(new Frame(Interpreter.singleton(s.elseBranch)));
            }
        }

        @Override
        public void visitWhileStmt(While s) {
            this.frames.push(new WhileFrame(s.condition, s.body));
        }

        @Override
        public void visitForStmt(For s) {
            this.frames.push(new Frame(Interpreter.singleton(s.body)));
        }

        @Override
        public void visitSetBlockStmt(SetBlock s) {
            int x = Interpreter.toInt(this.evaluate(s.x));
            int y = Interpreter.toInt(this.evaluate(s.y));
            int z = Interpreter.toInt(this.evaluate(s.z));
            String block = String.valueOf(this.evaluate(s.block));
            this.emit(new SetBlockCommand(x, y, z, block));
        }

        @Override
        public Object visitBinary(Binary e) {
            if (e.op.type == TokenType.OR_OR) {
                Object l = this.evaluate(e.left);
                if (Interpreter.isTruthy(l)) {
                    return true;
                }
                return Interpreter.isTruthy(this.evaluate(e.right));
            }
            if (e.op.type == TokenType.AND_AND) {
                Object l = this.evaluate(e.left);
                if (!Interpreter.isTruthy(l)) {
                    return false;
                }
                return Interpreter.isTruthy(this.evaluate(e.right));
            }
            Object l = this.evaluate(e.left);
            Object r = this.evaluate(e.right);
            switch (e.op.type.ordinal()) {
                case 7: {
                    if (l instanceof Double && r instanceof Double) {
                        return (Double)l + (Double)r;
                    }
                    return Interpreter.stringify(l) + Interpreter.stringify(r);
                }
                case 6: {
                    Interpreter.checkNumber(l, e.op);
                    Interpreter.checkNumber(r, e.op);
                    return (Double)l - (Double)r;
                }
                case 11: {
                    Interpreter.checkNumber(l, e.op);
                    Interpreter.checkNumber(r, e.op);
                    return (Double)l * (Double)r;
                }
                case 10: {
                    Interpreter.checkNumber(l, e.op);
                    Interpreter.checkNumber(r, e.op);
                    return (Double)l / (Double)r;
                }
                case 8: {
                    Interpreter.checkNumber(l, e.op);
                    Interpreter.checkNumber(r, e.op);
                    return (Double)l % (Double)r;
                }
                case 16: {
                    Interpreter.checkNumber(l, e.op);
                    Interpreter.checkNumber(r, e.op);
                    return (Double)l > (Double)r;
                }
                case 17: {
                    Interpreter.checkNumber(l, e.op);
                    Interpreter.checkNumber(r, e.op);
                    return (Double)l >= (Double)r;
                }
                case 18: {
                    Interpreter.checkNumber(l, e.op);
                    Interpreter.checkNumber(r, e.op);
                    return (Double)l < (Double)r;
                }
                case 19: {
                    Interpreter.checkNumber(l, e.op);
                    Interpreter.checkNumber(r, e.op);
                    return (Double)l <= (Double)r;
                }
                case 15: {
                    return Interpreter.isEqual(l, r);
                }
                case 13: {
                    return !Interpreter.isEqual(l, r);
                }
            }
            throw new RuntimeException("Unknown binary op: " + String.valueOf((Object)e.op.type));
        }

        @Override
        public Object visitConditional(Conditional e) {
            Object cond = this.evaluate(e.condition);
            if (Interpreter.isTruthy(cond)) {
                return this.evaluate(e.thenExpr);
            }
            return this.evaluate(e.elseExpr);
        }

        @Override
        public Object visitUnary(Unary e) {
            Object v = this.evaluate(e.right);
            switch (e.op.type.ordinal()) {
                case 6: {
                    Interpreter.checkNumber(v, e.op);
                    return -((Double)v).doubleValue();
                }
                case 12: {
                    return !Interpreter.isTruthy(v);
                }
            }
            throw new RuntimeException("Unknown unary op: " + String.valueOf((Object)e.op.type));
        }

        @Override
        public Object visitLiteral(Literal e) {
            return e.value;
        }

        @Override
        public Object visitGrouping(Grouping e) {
            return this.evaluate(e.expr);
        }

        @Override
        public Object visitVariable(Variable e) {
            return this.env().get(e.name);
        }

        @Override
        public Object visitAssign(Assign e) {
            Object val = this.evaluate(e.value);
            this.env().assign(e.name, val);
            return val;
        }

        private Object evaluate(Expr e) {
            return e.accept(this);
        }

        private Env env() {
            return this.envStack.peek();
        }

        private void pushEnv() {
            this.envStack.push(new Env(this.env()));
        }

        private void popEnv() {
            this.envStack.pop();
        }

        private static boolean isTruthy(Object v) {
            if (v == null) {
                return false;
            }
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
            if (v instanceof Double) {
                return (Double)v != 0.0;
            }
            String s = String.valueOf(v);
            return !s.isEmpty();
        }

        private static boolean isEqual(Object a, Object b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null) {
                return false;
            }
            if (a instanceof Double && b instanceof Double) {
                return ((Double)a).doubleValue() == ((Double)b).doubleValue();
            }
            return String.valueOf(a).equals(String.valueOf(b));
        }

        private static void checkNumber(Object v, Token at) {
            if (!(v instanceof Double)) {
                throw new RuntimeException("Operand must be a number at token '" + at.lexeme + "'");
            }
        }

        private static String stringify(Object v) {
            if (v == null) {
                return "nil";
            }
            if (v instanceof Double) {
                double d = (Double)v;
                if (d == Math.rint(d)) {
                    return String.valueOf((long)d);
                }
                return String.valueOf(d);
            }
            return String.valueOf(v);
        }

        private static int toInt(Object v) {
            if (v instanceof Double) {
                return (int)Math.round((Double)v);
            }
            try {
                return Integer.parseInt(String.valueOf(v));
            }
            catch (Exception e) {
                throw new RuntimeException("Expected integer-like value, got: " + String.valueOf(v));
            }
        }

        private static List<Stmt> singleton(Stmt s) {
            return Collections.singletonList(s);
        }

        static interface Emitter {
            public void emit(SetBlockCommand var1);
        }

        static class Frame {
            final List<Stmt> stmts;
            int ip = 0;
            final Runnable onClose;

            Frame(List<Stmt> stmts) {
                this(stmts, null);
            }

            Frame(List<Stmt> stmts, Runnable onClose) {
                this.stmts = stmts;
                this.onClose = onClose;
            }
        }

        static final class WhileFrame
        extends Frame {
            final Expr condition;
            final Stmt body;

            WhileFrame(Expr condition, Stmt body) {
                super(Collections.emptyList());
                this.condition = condition;
                this.body = body;
            }
        }
    }

    static final class SetBlock
    implements Stmt {
        final Expr x;
        final Expr y;
        final Expr z;
        final Expr block;

        SetBlock(Expr x, Expr y, Expr z, Expr block) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.block = block;
        }

        @Override
        public void accept(StmtVisitor v) {
            v.visitSetBlockStmt(this);
        }
    }

    static final class For
    implements Stmt {
        final Stmt initializer;
        final Expr condition;
        final Stmt increment;
        final Stmt body;

        For(Stmt init, Expr cond, Stmt inc, Stmt body) {
            this.initializer = init;
            this.condition = cond;
            this.increment = inc;
            this.body = body;
        }

        @Override
        public void accept(StmtVisitor v) {
            v.visitForStmt(this);
        }
    }

    static final class While
    implements Stmt {
        final Expr condition;
        final Stmt body;

        While(Expr c, Stmt b) {
            this.condition = c;
            this.body = b;
        }

        @Override
        public void accept(StmtVisitor v) {
            v.visitWhileStmt(this);
        }
    }

    static final class If
    implements Stmt {
        final Expr condition;
        final Stmt thenBranch;
        final Stmt elseBranch;

        If(Expr c, Stmt t, Stmt e) {
            this.condition = c;
            this.thenBranch = t;
            this.elseBranch = e;
        }

        @Override
        public void accept(StmtVisitor v) {
            v.visitIfStmt(this);
        }
    }

    static final class Block
    implements Stmt {
        final List<Stmt> statements;

        Block(List<Stmt> s) {
            this.statements = s;
        }

        @Override
        public void accept(StmtVisitor v) {
            v.visitBlockStmt(this);
        }
    }

    static final class Var
    implements Stmt {
        final Token name;
        final Expr initializer;

        Var(Token n, Expr init) {
            this.name = n;
            this.initializer = init;
        }

        @Override
        public void accept(StmtVisitor v) {
            v.visitVarStmt(this);
        }
    }

    static final class PrintStmt
    implements Stmt {
        final Expr expr;

        PrintStmt(Expr e) {
            this.expr = e;
        }

        @Override
        public void accept(StmtVisitor v) {
            v.visitPrintStmt(this);
        }
    }

    static final class ExprStmt
    implements Stmt {
        final Expr expr;

        ExprStmt(Expr e) {
            this.expr = e;
        }

        @Override
        public void accept(StmtVisitor v) {
            v.visitExprStmt(this);
        }
    }

    static interface StmtVisitor {
        public void visitExprStmt(ExprStmt var1);

        public void visitPrintStmt(PrintStmt var1);

        public void visitVarStmt(Var var1);

        public void visitBlockStmt(Block var1);

        public void visitIfStmt(If var1);

        public void visitWhileStmt(While var1);

        public void visitForStmt(For var1);

        public void visitSetBlockStmt(SetBlock var1);
    }

    static interface Stmt {
        public void accept(StmtVisitor var1);
    }

    static final class Assign
    implements Expr {
        final Token name;
        final Expr value;

        Assign(Token n, Expr v) {
            this.name = n;
            this.value = v;
        }

        @Override
        public <R> R accept(ExprVisitor<R> v) {
            return v.visitAssign(this);
        }
    }

    static final class Variable
    implements Expr {
        final Token name;

        Variable(Token n) {
            this.name = n;
        }

        @Override
        public <R> R accept(ExprVisitor<R> v) {
            return v.visitVariable(this);
        }
    }

    static final class Grouping
    implements Expr {
        final Expr expr;

        Grouping(Expr e) {
            this.expr = e;
        }

        @Override
        public <R> R accept(ExprVisitor<R> v) {
            return v.visitGrouping(this);
        }
    }

    static final class Literal
    implements Expr {
        final Object value;

        Literal(Object v) {
            this.value = v;
        }

        @Override
        public <R> R accept(ExprVisitor<R> v) {
            return v.visitLiteral(this);
        }
    }

    static final class Unary
    implements Expr {
        final Token op;
        final Expr right;

        Unary(Token o, Expr r) {
            this.op = o;
            this.right = r;
        }

        @Override
        public <R> R accept(ExprVisitor<R> v) {
            return v.visitUnary(this);
        }
    }

    static final class Binary
    implements Expr {
        final Expr left;
        final Token op;
        final Expr right;

        Binary(Expr l, Token o, Expr r) {
            this.left = l;
            this.op = o;
            this.right = r;
        }

        @Override
        public <R> R accept(ExprVisitor<R> v) {
            return v.visitBinary(this);
        }
    }

    static final class Conditional
    implements Expr {
        final Expr condition;
        final Expr thenExpr;
        final Expr elseExpr;

        Conditional(Expr condition, Expr thenExpr, Expr elseExpr) {
            this.condition = condition;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
        }

        @Override
        public <R> R accept(ExprVisitor<R> v) {
            return v.visitConditional(this);
        }
    }

    static interface ExprVisitor<R> {
        public R visitBinary(Binary var1);

        public R visitUnary(Unary var1);

        public R visitLiteral(Literal var1);

        public R visitGrouping(Grouping var1);

        public R visitVariable(Variable var1);

        public R visitAssign(Assign var1);

        public R visitConditional(Conditional var1);
    }

    static interface Expr {
        public <R> R accept(ExprVisitor<R> var1);
    }

    static final class Token {
        final TokenType type;
        final String lexeme;
        final Object literal;
        final int line;
        final int col;

        Token(TokenType type, String lexeme, Object literal, int line, int col) {
            this.type = type;
            this.lexeme = lexeme;
            this.literal = literal;
            this.line = line;
            this.col = col;
        }

        public String toString() {
            return String.valueOf((Object)this.type) + " '" + this.lexeme + "'" + (String)(this.literal != null ? " -> " + String.valueOf(this.literal) : "");
        }
    }

    static enum TokenType {
        LEFT_PAREN,
        RIGHT_PAREN,
        LEFT_BRACE,
        RIGHT_BRACE,
        COMMA,
        DOT,
        MINUS,
        PLUS,
        PERCENT,
        SEMICOLON,
        SLASH,
        STAR,
        BANG,
        BANG_EQUAL,
        EQUAL,
        EQUAL_EQUAL,
        GREATER,
        GREATER_EQUAL,
        LESS,
        LESS_EQUAL,
        AND_AND,
        OR_OR,
        QUESTION,
        COLON,
        IDENTIFIER,
        STRING,
        NUMBER,
        LET,
        IF,
        ELSE,
        WHILE,
        FOR,
        TRUE,
        FALSE,
        NIL,
        SETBLOCK,
        EOF;

    }
}

