/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceBlockNearbyTask;
import com.player2.playerengine.tasks.container.StoreInContainerTask;
import com.player2.playerengine.trackers.storage.ContainerCache;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class StoreInAnyContainerTask
extends Task {
    private final ItemTarget[] toStore;
    private final boolean getIfNotPresent;

    public StoreInAnyContainerTask(boolean getIfNotPresent, ItemTarget ... toStore) {
        this.getIfNotPresent = getIfNotPresent;
        this.toStore = toStore;
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        ItemTarget[] itemsToStore = this.getItemsToStore(this.controller);
        if (itemsToStore.length == 0) {
            return null;
        }
        if (this.getIfNotPresent) {
            for (ItemTarget target : this.toStore) {
                if (this.controller.getItemStorage().getItemCount(target) >= target.getTargetCount()) continue;
                this.setDebugState("Collecting " + String.valueOf(target) + " before storing.");
                return TaskCatalogue.getItemTask(target);
            }
        }
        Predicate<BlockPos> isValidContainer = pos -> {
            if (WorldHelper.isChest(this.controller, pos) && WorldHelper.isSolidBlock(this.controller, pos.above()) && !WorldHelper.canBreak(this.controller, pos.above())) {
                return false;
            }
            Optional<ContainerCache> cache = this.controller.getItemStorage().getContainerAtPosition((BlockPos)pos);
            if (cache.isPresent() && cache.get().isFull()) {
                return false;
            }
            return WorldHelper.isChest(this.controller, pos) && this.controller.getModSettings().shouldAvoidSearchingForDungeonChests() ? !this.isDungeonChest(this.controller, (BlockPos)pos) : true;
        };
        Optional<BlockPos> closestContainer = this.controller.getBlockScanner().getNearestBlock(isValidContainer, StoreInContainerTask.CONTAINER_BLOCKS);
        if (closestContainer.isPresent()) {
            this.setDebugState("Found a container; storing items.");
            return new StoreInContainerTask(closestContainer.get(), false, itemsToStore);
        }
        for (Block containerBlock : StoreInContainerTask.CONTAINER_BLOCKS) {
            if (!this.controller.getItemStorage().hasItem(containerBlock.asItem())) continue;
            this.setDebugState("Placing a container nearby.");
            return new PlaceBlockNearbyTask(pos -> !WorldHelper.isChest(this.controller, pos) || WorldHelper.isAir(this.controller, pos.above()), containerBlock);
        }
        this.setDebugState("Obtaining a chest to store items.");
        return TaskCatalogue.getItemTask(Items.CHEST, 1);
    }

    @Override
    public boolean isFinished() {
        return this.getItemsToStore(this.controller).length == 0;
    }

    private ItemTarget[] getItemsToStore(PlayerEngineController controller) {
        return (ItemTarget[])Arrays.stream(this.toStore).filter(target -> controller.getItemStorage().hasItem(target.getMatches())).toArray(ItemTarget[]::new);
    }

    private boolean isDungeonChest(PlayerEngineController controller, BlockPos pos) {
        int range = 6;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dz = -range; dz <= range; ++dz) {
                if (!controller.getWorld().getBlockState(pos.offset(dx, 0, dz)).is(Blocks.SPAWNER)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof StoreInAnyContainerTask)) {
            bl = false;
        } else {
            StoreInAnyContainerTask task = (StoreInAnyContainerTask)other;
            bl = task.getIfNotPresent == this.getIfNotPresent && Arrays.equals(task.toStore, this.toStore);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Storing in any container: " + Arrays.toString(this.toStore);
    }
}

