/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.entity;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.GoalRunAway;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToEntityTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.speedrun.beatgame.BeatMinecraftTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.slots.Slot;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class AbstractDoToEntityTask
extends Task
implements ITaskRequiresGrounded {
    protected final MovementProgressChecker progress = new MovementProgressChecker();
    private final double maintainDistance;
    private final double combatGuardLowerRange;
    private final double combatGuardLowerFieldRadius;
    private TimeoutWanderTask wanderTask;

    protected AbstractDoToEntityTask(double maintainDistance, double combatGuardLowerRange, double combatGuardLowerFieldRadius) {
        this.maintainDistance = maintainDistance;
        this.combatGuardLowerRange = combatGuardLowerRange;
        this.combatGuardLowerFieldRadius = combatGuardLowerFieldRadius;
    }

    protected AbstractDoToEntityTask(double maintainDistance) {
        this(maintainDistance, 0.0, Double.POSITIVE_INFINITY);
    }

    protected AbstractDoToEntityTask(double combatGuardLowerRange, double combatGuardLowerFieldRadius) {
        this(-1.0, combatGuardLowerRange, combatGuardLowerFieldRadius);
    }

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        this.progress.reset();
        ItemStack cursorStack = StorageHelper.getItemStackInCursorSlot(this.controller);
        if (!cursorStack.isEmpty()) {
            Optional<Slot> moveTo = mod.getItemStorage().getSlotThatCanFitInPlayerInventory(cursorStack, false);
            moveTo.ifPresent(slot -> mod.getSlotHandler().clickSlot((Slot)slot, 0, ClickType.PICKUP));
            if (ItemHelper.canThrowAwayStack(mod, cursorStack)) {
                mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, ClickType.PICKUP);
            }
            Optional<Slot> garbage = StorageHelper.getGarbageSlot(mod);
            garbage.ifPresent(slot -> mod.getSlotHandler().clickSlot((Slot)slot, 0, ClickType.PICKUP));
            mod.getSlotHandler().clickSlot(Slot.UNDEFINED, 0, ClickType.PICKUP);
        }
    }

    @Override
    protected Task onTick() {
        Optional<Entity> checkEntity;
        PlayerEngineController mod = this.controller;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progress.reset();
        }
        if ((checkEntity = this.getEntityTarget(mod)).isEmpty()) {
            mod.getMobDefenseChain().resetTargetEntity();
            mod.getMobDefenseChain().resetForceField();
        } else {
            mod.getMobDefenseChain().setTargetEntity(checkEntity.get());
        }
        if (checkEntity.isPresent()) {
            boolean tooClose;
            Entity entity = checkEntity.get();
            double playerReach = mod.getModSettings().getEntityReachRange();
            EntityHitResult result = LookHelper.raycast((Entity)mod.getPlayer(), entity, playerReach);
            double sqDist = entity.distanceToSqr((Entity)mod.getPlayer());
            if (sqDist < this.combatGuardLowerRange * this.combatGuardLowerRange) {
                mod.getMobDefenseChain().setForceFieldRange(this.combatGuardLowerFieldRadius);
            } else {
                mod.getMobDefenseChain().resetForceField();
            }
            double maintainDistance = this.maintainDistance >= 0.0 ? this.maintainDistance : playerReach - 1.0;
            boolean bl = tooClose = sqDist < maintainDistance * maintainDistance;
            if (tooClose && !mod.getBaritone().getCustomGoalProcess().isActive()) {
                mod.getBaritone().getCustomGoalProcess().setGoalAndPath(new GoalRunAway(maintainDistance, entity.blockPosition()));
            }
            if (mod.getControllerExtras().inRange(entity) && result != null && result.getType() == HitResult.Type.ENTITY && !mod.getFoodChain().needsToEat() && !mod.getMLGBucketChain().isFalling(mod) && mod.getMLGBucketChain().doneMLG() && !mod.getMLGBucketChain().isChorusFruiting() && mod.getBaritone().getPathingBehavior().isSafeToCancel() && mod.getPlayer().onGround()) {
                this.progress.reset();
                return this.onEntityInteract(mod, entity);
            }
            if (!tooClose) {
                this.setDebugState("Approaching target");
                if (!this.progress.check(mod)) {
                    this.progress.reset();
                    Debug.logMessage("Failed to get to target, blacklisting.");
                    mod.getEntityTracker().requestEntityUnreachable(entity);
                }
                return new GetToEntityTask(entity, maintainDistance);
            }
        }
        if (BeatMinecraftTask.isTaskRunning(mod, this.wanderTask)) {
            return this.wanderTask;
        }
        if (!mod.getBaritone().getPathingBehavior().isSafeToCancel()) {
            return null;
        }
        this.wanderTask = new TimeoutWanderTask();
        return this.wanderTask;
    }

    @Override
    protected boolean isEqual(Task other) {
        if (other instanceof AbstractDoToEntityTask) {
            AbstractDoToEntityTask task = (AbstractDoToEntityTask)other;
            if (!this.doubleCheck(task.maintainDistance, this.maintainDistance)) {
                return false;
            }
            if (!this.doubleCheck(task.combatGuardLowerFieldRadius, this.combatGuardLowerFieldRadius)) {
                return false;
            }
            return !this.doubleCheck(task.combatGuardLowerRange, this.combatGuardLowerRange) ? false : this.isSubEqual(task);
        }
        return false;
    }

    private boolean doubleCheck(double a, double b) {
        return Double.isInfinite(a) == Double.isInfinite(b) ? true : Math.abs(a - b) < 0.1;
    }

    @Override
    protected void onStop(Task interruptTask) {
        PlayerEngineController mod = this.controller;
        mod.getMobDefenseChain().setTargetEntity(null);
        mod.getMobDefenseChain().resetForceField();
    }

    protected abstract boolean isSubEqual(AbstractDoToEntityTask var1);

    protected abstract Task onEntityInteract(PlayerEngineController var1, Entity var2);

    protected abstract Optional<Entity> getEntityTarget(PlayerEngineController var1);
}

