/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.entity;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToEntityTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.KillAndLootTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;

public class HeroTask
extends Task {
    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getFoodChain().needsToEat()) {
            this.setDebugState("Eat first.");
            return null;
        }
        Optional<Entity> experienceOrb = mod.getEntityTracker().getClosestEntity(ExperienceOrb.class);
        if (experienceOrb.isPresent()) {
            this.setDebugState("Getting experience.");
            return new GetToEntityTask(experienceOrb.get());
        }
        assert (this.controller.getWorld() != null);
        Iterable hostiles = this.controller.getWorld().getAllEntities();
        if (hostiles != null) {
            for (Entity hostile : hostiles) {
                Optional<Entity> closestHostile;
                if (!(hostile instanceof Monster) && !(hostile instanceof Slime) || !(closestHostile = mod.getEntityTracker().getClosestEntity(hostile.getClass())).isPresent()) continue;
                this.setDebugState("Killing hostiles or picking hostile drops.");
                return new KillAndLootTask(hostile.getClass(), new ItemTarget(ItemHelper.HOSTILE_MOB_DROPS));
            }
        }
        if (mod.getEntityTracker().itemDropped(ItemHelper.HOSTILE_MOB_DROPS)) {
            this.setDebugState("Picking hostile drops.");
            return new PickupDroppedItemTask(new ItemTarget(ItemHelper.HOSTILE_MOB_DROPS), true);
        }
        this.setDebugState("Searching for hostile mobs.");
        return new TimeoutWanderTask();
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof HeroTask;
    }

    @Override
    protected String toDebugString() {
        return "Killing all hostile mobs.";
    }
}

