/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.compound.ConstructNetherPortalBucketTask;
import com.player2.playerengine.tasks.construction.compound.ConstructNetherPortalObsidianTask;
import com.player2.playerengine.tasks.movement.EnterNetherPortalTask;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;

public class DefaultGoToDimensionTask
extends Task {
    private final Dimension target;
    private final Task cachedNetherBucketConstructionTask = new ConstructNetherPortalBucketTask();

    public DefaultGoToDimensionTask(Dimension target) {
        this.target = target;
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        if (WorldHelper.getCurrentDimension(this.controller) == this.target) {
            return null;
        }
        switch (this.target) {
            case NETHER: {
                switch (WorldHelper.getCurrentDimension(this.controller)) {
                    case END: {
                        return this.goToOverworldFromEndTask();
                    }
                    case OVERWORLD: {
                        return this.goToNetherFromOverworldTask();
                    }
                }
                break;
            }
            case END: {
                switch (WorldHelper.getCurrentDimension(this.controller)) {
                    case NETHER: {
                        return this.goToOverworldFromNetherTask();
                    }
                    case OVERWORLD: {
                        return this.goToEndTask();
                    }
                }
                break;
            }
            case OVERWORLD: {
                switch (WorldHelper.getCurrentDimension(this.controller)) {
                    case NETHER: {
                        return this.goToOverworldFromNetherTask();
                    }
                    case END: {
                        return this.goToOverworldFromEndTask();
                    }
                }
            }
        }
        this.setDebugState(String.valueOf((Object)WorldHelper.getCurrentDimension(this.controller)) + " -> " + String.valueOf((Object)this.target) + " is NOT IMPLEMENTED YET!");
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof DefaultGoToDimensionTask) {
            DefaultGoToDimensionTask task = (DefaultGoToDimensionTask)other;
            bl = task.target == this.target;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Going to dimension: " + String.valueOf((Object)this.target) + " (default version)";
    }

    @Override
    public boolean isFinished() {
        return WorldHelper.getCurrentDimension(this.controller) == this.target;
    }

    private Task goToOverworldFromNetherTask() {
        if (this.netherPortalIsClose(this.controller)) {
            this.setDebugState("Going to nether portal");
            return new EnterNetherPortalTask(Dimension.NETHER);
        }
        Optional<BlockPos> closest = this.controller.getMiscBlockTracker().getLastUsedNetherPortal(Dimension.NETHER);
        if (closest.isPresent()) {
            this.setDebugState("Going to last nether portal pos");
            return new GetToBlockTask(closest.get());
        }
        this.setDebugState("Constructing nether portal with obsidian");
        return new ConstructNetherPortalObsidianTask();
    }

    private Task goToOverworldFromEndTask() {
        this.setDebugState("TODO: Go to center portal (at 0,0). If it doesn't exist, kill ender dragon lol");
        return null;
    }

    private Task goToNetherFromOverworldTask() {
        if (this.netherPortalIsClose(this.controller)) {
            this.setDebugState("Going to nether portal");
            return new EnterNetherPortalTask(Dimension.NETHER);
        }
        return switch (this.controller.getModSettings().getOverworldToNetherBehaviour().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.cachedNetherBucketConstructionTask;
            case 1 -> new GetToBlockTask(this.controller.getModSettings().getHomeBasePosition());
        };
    }

    private Task goToEndTask() {
        this.setDebugState("TODO: Get to End, Same as BeatMinecraft");
        return null;
    }

    private boolean netherPortalIsClose(PlayerEngineController mod) {
        if (!mod.getBlockScanner().anyFound(Blocks.NETHER_PORTAL)) {
            return false;
        }
        Optional<BlockPos> closest = mod.getBlockScanner().getNearestBlock(Blocks.NETHER_PORTAL);
        return closest.isPresent() && closest.get().closerThan(new Vec3i((int)mod.getPlayer().position().x, (int)mod.getPlayer().position().y, (int)mod.getPlayer().position().z), 2000.0);
    }

    public static enum OVERWORLD_TO_NETHER_BEHAVIOUR {
        BUILD_PORTAL_VANILLA,
        GO_TO_HOME_BASE;

    }
}

