/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceObsidianBucketTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.tasks.resources.SatisfyMiningRequirementTask;
import com.player2.playerengine.tasks.resources.TradeWithPiglinsTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.time.TimerGame;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CollectObsidianTask
extends ResourceTask {
    private final TimerGame placeWaterTimeout = new TimerGame(6.0);
    private final MovementProgressChecker lavaTimeout = new MovementProgressChecker();
    private final Set<BlockPos> lavaBlacklist = new HashSet<BlockPos>();
    private final int count;
    private Task forceCompleteTask = null;
    private BlockPos lavaWaitCurrentPos;
    private PlaceObsidianBucketTask placeObsidianTask;

    public CollectObsidianTask(int count) {
        super(Items.OBSIDIAN, count);
        this.count = count;
    }

    private static BlockPos getLavaStructurePos(BlockPos lavaPos) {
        return lavaPos.offset(1, 1, 0);
    }

    private static BlockPos getLavaWaterPos(BlockPos lavaPos) {
        return lavaPos.above();
    }

    private static BlockPos getGoodObsidianPosition(PlayerEngineController mod) {
        BlockPos start = mod.getPlayer().blockPosition().offset(-3, -3, -3);
        BlockPos end = mod.getPlayer().blockPosition().offset(3, 3, 3);
        for (BlockPos pos : WorldHelper.scanRegion(start, end)) {
            if (WorldHelper.canBreak(mod, pos) && WorldHelper.canPlace(mod, pos)) continue;
            return null;
        }
        return mod.getPlayer().blockPosition();
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
        mod.getBehaviour().setRayTracingFluidHandling(ClipContext.Fluid.SOURCE_ONLY);
        mod.getBehaviour().avoidBlockPlacing(pos -> this.lavaWaitCurrentPos != null ? pos.equals((Object)this.lavaWaitCurrentPos) || pos.equals((Object)CollectObsidianTask.getLavaWaterPos(this.lavaWaitCurrentPos)) : false);
        mod.getBehaviour().avoidBlockBreaking(pos -> this.lavaWaitCurrentPos != null ? pos.equals((Object)CollectObsidianTask.getLavaStructurePos(this.lavaWaitCurrentPos)) : false);
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        BlockPos goodPos;
        if (this.lavaWaitCurrentPos != null && mod.getChunkTracker().isChunkLoaded(this.lavaWaitCurrentPos) && mod.getWorld().getBlockState(this.lavaWaitCurrentPos).getBlock() != Blocks.LAVA) {
            this.lavaWaitCurrentPos = null;
        }
        if (!StorageHelper.miningRequirementMet(this.controller, MiningRequirement.DIAMOND)) {
            this.setDebugState("Getting diamond pickaxe first");
            return new SatisfyMiningRequirementTask(MiningRequirement.DIAMOND);
        }
        if (this.forceCompleteTask != null && this.forceCompleteTask.isActive() && !this.forceCompleteTask.isFinished()) {
            return this.forceCompleteTask;
        }
        Predicate<BlockPos> goodObsidian = blockPos -> blockPos.closerToCenterThan((Position)mod.getPlayer().position(), 800.0) && WorldHelper.canBreak(mod, blockPos);
        if (mod.getBlockScanner().anyFound(goodObsidian, Blocks.OBSIDIAN) || mod.getEntityTracker().itemDropped(Items.OBSIDIAN)) {
            this.setDebugState("Mining/Collecting obsidian");
            this.placeObsidianTask = null;
            return new MineAndCollectTask(new ItemTarget(Items.OBSIDIAN, this.count), new Block[]{Blocks.OBSIDIAN}, MiningRequirement.DIAMOND);
        }
        if (WorldHelper.getCurrentDimension(mod) == Dimension.NETHER) {
            double AVERAGE_GOLD_PER_OBSIDIAN = 11.475;
            int gold_buffer = (int)(11.475 * (double)this.count);
            this.setDebugState("We can't place water, so we're trading for obsidian");
            return new TradeWithPiglinsTask(gold_buffer, Items.OBSIDIAN, this.count);
        }
        if (this.placeObsidianTask == null) {
            goodPos = CollectObsidianTask.getGoodObsidianPosition(mod);
            if (goodPos == null) {
                this.setDebugState("Walking until we find a spot to place obsidian");
                return new TimeoutWanderTask();
            }
            this.placeObsidianTask = new PlaceObsidianBucketTask(goodPos);
        }
        if (this.placeObsidianTask != null && !mod.getItemStorage().hasItem(Items.LAVA_BUCKET) && !this.placeObsidianTask.getPos().closerToCenterThan((Position)mod.getPlayer().position(), 4.0) && (goodPos = CollectObsidianTask.getGoodObsidianPosition(mod)) != null) {
            Debug.logMessage("(nudged obsidian target closer)");
            this.placeObsidianTask = new PlaceObsidianBucketTask(goodPos);
        }
        this.setDebugState("Placing Obsidian");
        return this.placeObsidianTask;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof CollectObsidianTask) {
            CollectObsidianTask task = (CollectObsidianTask)other;
            bl = task.count == this.count;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect " + this.count + " blocks of obsidian";
    }
}

