/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.StorageHelper;
import net.minecraft.world.item.Item;

public class GetBuildingMaterialsTask
extends Task {
    private final int count;

    public GetBuildingMaterialsTask(int count) {
        this.count = count;
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        Item[] throwaways = this.controller.getModSettings().getThrowawayItems(this.controller, true);
        return new MineAndCollectTask(new ItemTarget[]{new ItemTarget(throwaways, this.count)}, MiningRequirement.WOOD);
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof GetBuildingMaterialsTask) {
            GetBuildingMaterialsTask task = (GetBuildingMaterialsTask)other;
            bl = task.count == this.count;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isFinished() {
        return StorageHelper.getBuildingMaterialCount(this.controller) >= this.count;
    }

    @Override
    protected String toDebugString() {
        return "Collecting " + this.count + " building materials.";
    }
}

