/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.baritone;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.pathing.goals.GoalXZ;
import com.player2.playerengine.automaton.api.pathing.goals.GoalYLevel;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import java.util.List;
import net.minecraft.world.entity.Entity;

public abstract class GoalRunAwayFromEntities
implements Goal {
    private final PlayerEngineController mod;
    private final double distance;
    private final boolean xzOnly;
    private final double penaltyFactor;

    public GoalRunAwayFromEntities(PlayerEngineController mod, double distance, boolean xzOnly, double penaltyFactor) {
        this.mod = mod;
        this.distance = distance;
        this.xzOnly = xzOnly;
        this.penaltyFactor = penaltyFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInGoal(int x, int y, int z) {
        List<Entity> entities = this.getEntities(this.mod);
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            if (!entities.isEmpty()) {
                for (Entity entity : entities) {
                    double sqDistance;
                    if (entity == null || !entity.isAlive() || !((sqDistance = this.xzOnly ? entity.position().subtract((double)x, (double)y, (double)z).multiply(1.0, 0.0, 1.0).lengthSqr() : entity.distanceToSqr((double)x, (double)y, (double)z)) < this.distance * this.distance)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double heuristic(int x, int y, int z) {
        double costSum = 0.0;
        List<Entity> entities = this.getEntities(this.mod);
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            int max = 10;
            int counter = 0;
            if (!entities.isEmpty()) {
                for (Entity entity : entities) {
                    ++counter;
                    if (entity == null || !entity.isAlive()) continue;
                    double cost = this.getCostOfEntity(entity, x, y, z);
                    costSum = cost != 0.0 ? (costSum += 1.0 / cost) : (costSum += 1000.0);
                    if (counter < max) continue;
                    break;
                }
            }
            if (counter > 0) {
                costSum /= (double)counter;
            }
            return costSum * this.penaltyFactor;
        }
    }

    protected abstract List<Entity> getEntities(PlayerEngineController var1);

    protected double getCostOfEntity(Entity entity, int x, int y, int z) {
        double heuristic = 0.0;
        if (!this.xzOnly) {
            heuristic += GoalYLevel.calculate(entity.blockPosition().getY(), y);
        }
        return heuristic + GoalXZ.calculate(entity.blockPosition().getX() - x, entity.blockPosition().getZ() - z);
    }
}

